/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.drools.core.util.DateUtils;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.util.ColumnUtilitiesBase;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.XLSColumnUtilities;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.oracle.DataType;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;

public class DataBuilder {
    private static final int FIRST_DATA_ROW = 9;
    private static final String DROOLS_DATE_TIME_FORMAT_KEY = "drools.dateformat";
    private static final String DEFAULT_DATE_TIME_FORMAT = "dd-MMM-yyyy";
    private final Sheet sheet;
    private final GuidedDecisionTable52 dtable;
    private final ColumnUtilitiesBase utilsWithRespectForLists;
    private final ColumnUtilitiesBase utilsWithNoRespectForLists;
    private int rowCount = 9;

    public DataBuilder(Sheet sheet, GuidedDecisionTable52 dtable, PackageDataModelOracle dmo) {
        this.sheet = (Sheet)PortablePreconditions.checkNotNull((String)"sheet", (Object)sheet);
        this.dtable = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"dtable", (Object)dtable);
        PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.utilsWithRespectForLists = new XLSColumnUtilities(dtable, dmo, true);
        this.utilsWithNoRespectForLists = new XLSColumnUtilities(dtable, dmo, false);
    }

    public void build() {
        for (List row : this.dtable.getData()) {
            new DataRowBuilder(row).build();
        }
    }

    class DataRowBuilder {
        private final Row xlsRow;
        private final Set<String> addedInserts;
        private final List<DTCellValue52> row;
        private int sourceColumnIndex;
        private int targetColumnIndex;

        public DataRowBuilder(List<DTCellValue52> row) {
            this.xlsRow = DataBuilder.this.sheet.createRow(DataBuilder.this.rowCount);
            this.addedInserts = new HashSet<String>();
            this.sourceColumnIndex = 0;
            this.targetColumnIndex = -1;
            this.row = row;
        }

        public void build() {
            for (DTCellValue52 cell : this.row) {
                if (this.sourceColumnIndex == 1) {
                    this.xlsRow.createCell(this.targetColumnIndex).setCellValue(cell.getStringValue());
                } else if (this.sourceColumnIndex > 1) {
                    ActionInsertFactCol52 column;
                    if (DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex) instanceof ActionInsertFactCol52 && !this.addedInserts.contains((column = (ActionInsertFactCol52)DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex)).getBoundName())) {
                        this.addedInserts.add(column.getBoundName());
                        this.xlsRow.createCell(this.targetColumnIndex).setCellValue("X");
                        ++this.targetColumnIndex;
                    }
                    if (DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex) instanceof ActionRetractFactCol52) {
                        if (cell.getStringValue() != null && !cell.getStringValue().trim().isEmpty()) {
                            this.xlsRow.createCell(this.targetColumnIndex).setCellValue(cell.getStringValue());
                        }
                    } else {
                        DataType.DataTypes dataType = this.getColumnDataType(this.sourceColumnIndex);
                        this.setValue(cell, dataType);
                    }
                }
                ++this.sourceColumnIndex;
                ++this.targetColumnIndex;
            }
            DataBuilder.this.rowCount++;
        }

        private void setValue(DTCellValue52 cell, DataType.DataTypes dataType) {
            switch (dataType) {
                case STRING: {
                    this.setStringValue(cell);
                    break;
                }
                case NUMERIC: 
                case NUMERIC_BIGDECIMAL: 
                case NUMERIC_BIGINTEGER: 
                case NUMERIC_BYTE: 
                case NUMERIC_DOUBLE: 
                case NUMERIC_FLOAT: 
                case NUMERIC_INTEGER: 
                case NUMERIC_LONG: 
                case NUMERIC_SHORT: {
                    this.setNumericValue(cell);
                    break;
                }
                case DATE: {
                    this.setDateValue(cell);
                    break;
                }
                case BOOLEAN: {
                    this.setBooleanValue(cell);
                }
            }
        }

        private void setNumericValue(DTCellValue52 cell) {
            Number numericValue = cell.getNumericValue();
            if (numericValue != null) {
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue(numericValue.toString());
            }
        }

        private void setBooleanValue(DTCellValue52 cell) {
            Boolean booleanValue = cell.getBooleanValue();
            if (booleanValue != null) {
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue(booleanValue.toString());
            }
        }

        private void setDateValue(DTCellValue52 cell) {
            Date dateValue = cell.getDateValue();
            if (dateValue != null) {
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue(String.format("\"%s\"", DateUtils.format((Date)dateValue)));
            }
        }

        private void setStringValue(DTCellValue52 cell) {
            if (this.isTheRealCellValueString(this.sourceColumnIndex) && cell.getStringValue() != null) {
                if (cell.getStringValue() != null && !cell.getStringValue().isEmpty()) {
                    this.xlsRow.createCell(this.targetColumnIndex).setCellValue(String.format("\"%s\"", this.fixStringValue(cell)));
                }
            } else if (Objects.equals(DataType.DataTypes.STRING, cell.getDataType())) {
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue(cell.getStringValue());
            } else {
                this.setValue(cell, cell.getDataType());
            }
        }

        private String fixStringValue(DTCellValue52 cell) {
            if (cell.getStringValue().length() > 2 && cell.getStringValue().startsWith("\"") && cell.getStringValue().endsWith("\"")) {
                return cell.getStringValue().substring(1, cell.getStringValue().length() - 1);
            }
            return cell.getStringValue();
        }

        private boolean isTheRealCellValueString(int sourceColumnIndex) {
            return !(DataBuilder.this.dtable.getExpandedColumns().get(sourceColumnIndex) instanceof AttributeCol52) && Objects.equals(DataType.DataTypes.STRING, DataBuilder.this.utilsWithNoRespectForLists.getTypeSafeType((BaseColumn)DataBuilder.this.dtable.getExpandedColumns().get(sourceColumnIndex)));
        }

        private DataType.DataTypes getColumnDataType(int columnIndex) {
            return DataBuilder.this.utilsWithRespectForLists.getTypeSafeType((BaseColumn)DataBuilder.this.dtable.getExpandedColumns().get(columnIndex));
        }
    }
}

