/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.Simulation;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.util.ScenarioBeanUtil;
import org.drools.scenariosimulation.backend.util.ScenarioBeanWrapper;
import org.drools.workbench.screens.scenariosimulation.backend.server.AbstractScenarioValidation;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValidationError;
import org.kie.api.runtime.KieContainer;

public class RULEScenarioValidation
extends AbstractScenarioValidation {
    public static final RULEScenarioValidation INSTANCE = new RULEScenarioValidation();

    @Override
    public List<FactMappingValidationError> validate(Simulation simulation, KieContainer kieContainer) {
        ArrayList<FactMappingValidationError> errors = new ArrayList<FactMappingValidationError>();
        HashMap<String, Object> beanInstanceMap = new HashMap<String, Object>();
        for (FactMapping factMapping : simulation.getSimulationDescriptor().getFactMappings()) {
            if (RULEScenarioValidation.isToSkip(factMapping)) continue;
            List<String> steps = this.expressionElementToString(factMapping);
            try {
                String targetClassName;
                String instanceClassName = factMapping.getFactIdentifier().getClassName();
                if (steps.isEmpty()) {
                    ScenarioBeanUtil.loadClass((String)instanceClassName, (ClassLoader)kieContainer.getClassLoader());
                    continue;
                }
                Object bean = beanInstanceMap.computeIfAbsent(instanceClassName, className -> ScenarioBeanUtil.fillBean((String)className, Collections.emptyMap(), (ClassLoader)kieContainer.getClassLoader()));
                List<String> stepsToField = steps.subList(0, steps.size() - 1);
                String lastStep = steps.get(steps.size() - 1);
                ScenarioBeanWrapper beanBeforeLastStep = ScenarioBeanUtil.navigateToObject((Object)bean, stepsToField, (boolean)true);
                ScenarioBeanWrapper beanWrapper = ScenarioBeanUtil.navigateToObject((Object)beanBeforeLastStep.getBean(), Collections.singletonList(lastStep), (boolean)false);
                String string = targetClassName = beanWrapper.getBeanClass() != null ? beanWrapper.getBeanClass().getCanonicalName() : null;
                if (Objects.equals(factMapping.getClassName(), targetClassName)) continue;
                errors.add(FactMappingValidationError.createFieldChangedError((FactMapping)factMapping, (String)targetClassName));
            }
            catch (ScenarioException e) {
                errors.add(FactMappingValidationError.createGenericError((FactMapping)factMapping, (String)e.getMessage()));
            }
        }
        return errors;
    }
}

