/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.bavet.common;

import java.util.List;
import java.util.function.Function;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfigurationProvider;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintConfigurationDescriptor;
import org.optaplanner.core.impl.domain.constraintweight.descriptor.ConstraintWeightDescriptor;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.stream.bavet.BavetConstraintFactory;
import org.optaplanner.core.impl.score.stream.bavet.common.BavetConstraint;
import org.optaplanner.core.impl.score.stream.bavet.uni.BavetFromUniConstraintStream;

public abstract class BavetAbstractConstraintStream<Solution_>
implements ConstraintStream {
    protected final BavetConstraintFactory<Solution_> constraintFactory;

    public BavetAbstractConstraintStream(BavetConstraintFactory<Solution_> constraintFactory) {
        this.constraintFactory = constraintFactory;
    }

    protected Function<Solution_, Score<?>> buildConstraintWeightExtractor(String constraintPackage, String constraintName) {
        this.validateConstraintId(constraintPackage, constraintName);
        SolutionDescriptor<Solution_> solutionDescriptor = this.constraintFactory.getSolutionDescriptor();
        ConstraintConfigurationDescriptor<Solution_> configurationDescriptor = solutionDescriptor.getConstraintConfigurationDescriptor();
        if (configurationDescriptor == null) {
            throw new IllegalStateException("The constraint (" + constraintName + ") of package (" + constraintPackage + ") does not hard-code a constraint weight and there is no @" + ConstraintConfigurationProvider.class.getSimpleName() + " on the solution class (" + solutionDescriptor.getSolutionClass() + ").\nMaybe add a @" + ConstraintConfiguration.class.getSimpleName() + " class or use " + ConstraintStream.class.getSimpleName() + ".penalize()/reward() instead of penalizeConfigurable()/rewardConfigurable.");
        }
        ConstraintWeightDescriptor<Solution_> weightDescriptor = configurationDescriptor.findConstraintWeightDescriptor(constraintPackage, constraintName);
        if (weightDescriptor == null) {
            throw new IllegalStateException("The constraint (" + constraintName + ") of package (" + constraintPackage + ") does not hard-code a constraint weight and there is no such @" + ConstraintWeight.class.getSimpleName() + " on the constraintConfigurationClass (" + configurationDescriptor.getConstraintConfigurationClass() + ").\nMaybe there is a typo in the constraintPackage or constraintName of one of the @" + ConstraintWeight.class.getSimpleName() + " members.\nMaybe add a @" + ConstraintWeight.class.getSimpleName() + " member for it.");
        }
        return weightDescriptor.createExtractor();
    }

    protected Function<Solution_, Score<?>> buildConstraintWeightExtractor(String constraintPackage, String constraintName, Score<?> constraintWeight) {
        this.validateConstraintId(constraintPackage, constraintName);
        this.constraintFactory.getSolutionDescriptor().validateConstraintWeight(constraintPackage, constraintName, constraintWeight);
        return solution -> constraintWeight;
    }

    protected void validateConstraintId(String constraintPackage, String constraintName) {
        if (constraintPackage == null) {
            throw new IllegalStateException("The constraint (" + constraintName + ") cannot have a null package (" + constraintPackage + ").");
        }
        if (constraintName == null) {
            throw new IllegalStateException("The constraint of package (" + constraintPackage + ") cannot have a null name (" + constraintName + ").");
        }
    }

    protected BavetConstraint<Solution_> buildConstraint(String constraintPackage, String constraintName, Score<?> constraintWeight, boolean positive) {
        Function<Solution_, Score<?>> constraintWeightExtractor = this.buildConstraintWeightExtractor(constraintPackage, constraintName, constraintWeight);
        List<BavetFromUniConstraintStream<Solution_, Object>> fromStreamList = this.getFromStreamList();
        return new BavetConstraint<Solution_>(this.constraintFactory, constraintPackage, constraintName, constraintWeightExtractor, positive, fromStreamList);
    }

    protected BavetConstraint<Solution_> buildConstraintConfigurable(String constraintPackage, String constraintName, boolean positive) {
        Function<Solution_, Score<?>> constraintWeightExtractor = this.buildConstraintWeightExtractor(constraintPackage, constraintName);
        List<BavetFromUniConstraintStream<Solution_, Object>> fromStreamList = this.getFromStreamList();
        return new BavetConstraint<Solution_>(this.constraintFactory, constraintPackage, constraintName, constraintWeightExtractor, positive, fromStreamList);
    }

    public abstract List<BavetFromUniConstraintStream<Solution_, Object>> getFromStreamList();

    @Override
    public BavetConstraintFactory<Solution_> getConstraintFactory() {
        return this.constraintFactory;
    }
}

