/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.score.stream.tri;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.optaplanner.core.impl.score.stream.common.JoinerType;
import org.optaplanner.core.impl.score.stream.tri.AbstractTriJoiner;
import org.optaplanner.core.impl.score.stream.tri.SingleTriJoiner;

public final class CompositeTriJoiner<A, B, C>
extends AbstractTriJoiner<A, B, C> {
    private final List<SingleTriJoiner<A, B, C>> joinerList;

    public CompositeTriJoiner(List<SingleTriJoiner<A, B, C>> joinerList) {
        if (joinerList.isEmpty()) {
            throw new IllegalArgumentException("The joinerList (" + joinerList + ") must not be empty.");
        }
        this.joinerList = joinerList;
    }

    public List<SingleTriJoiner<A, B, C>> getJoinerList() {
        return this.joinerList;
    }

    @Override
    public BiFunction<A, B, Object[]> getLeftCombinedMapping() {
        return CompositeTriJoiner.buildCombinedMappingBi(this.joinerList, SingleTriJoiner::getLeftMapping);
    }

    @Override
    public JoinerType[] getJoinerTypes() {
        return (JoinerType[])this.joinerList.stream().map(SingleTriJoiner::getJoinerType).toArray(JoinerType[]::new);
    }

    @Override
    public Function<C, Object[]> getRightCombinedMapping() {
        return CompositeTriJoiner.buildCombinedMappingUni(this.joinerList, SingleTriJoiner::getRightMapping);
    }
}

