/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.command.util;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.registry.command.CommandRegistry;

@Dependent
public class RedoCommandHandler<C extends Command> {
    private final CommandRegistry<C> registry;

    protected RedoCommandHandler() {
        this(null);
    }

    @Inject
    public RedoCommandHandler(CommandRegistry<C> commandRegistry) {
        this.registry = commandRegistry;
    }

    public boolean onUndoCommandExecuted(C command) {
        this.registry.register(command);
        return this.isEnabled();
    }

    public boolean onCommandExecuted(C command) {
        if (this.isEnabled()) {
            Command last = this.registry.peek();
            if (last.equals(command)) {
                this.registry.pop();
            } else {
                this.clear();
            }
        }
        return this.isEnabled();
    }

    public CommandResult<?> execute(Object context, CommandManager commandManager) {
        if (this.registry.isEmpty()) {
            return GraphCommandResultBuilder.SUCCESS;
        }
        Command last = this.registry.peek();
        return commandManager.execute(context, last);
    }

    public boolean isEnabled() {
        return !this.registry.isEmpty();
    }

    public void clear() {
        this.registry.clear();
    }

    protected CommandRegistry<C> getRegistry() {
        return this.registry;
    }
}

