/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.factory.impl;

import java.util.HashSet;
import java.util.Set;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionId;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

public abstract class AbstractElementFactory<C, D extends Definition<C>, T extends Element<D>>
implements ElementFactory<C, D, T> {
    protected AbstractElementFactory() {
    }

    protected abstract DefinitionManager getDefinitionManager();

    protected void appendLabels(Set<String> target, Object definition) {
        target.addAll(AbstractElementFactory.computeLabels(this.getDefinitionManager().adapters().registry().getDefinitionAdapter(definition.getClass()), definition));
    }

    public static <T> Set<String> computeLabels(DefinitionAdapter<T> adapter, T definition) {
        HashSet<String> target = new HashSet<String>();
        DefinitionId id = adapter.getId(definition);
        target.add(id.value());
        if (id.isDynamic()) {
            target.add(id.type());
        }
        target.addAll(adapter.getLabels(definition));
        return target;
    }
}

