/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.command.impl;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.logging.Logger;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.violations.BoundsExceededViolation;

@Portable
public final class UpdateElementPositionCommand
extends AbstractGraphCommand {
    private static Logger LOGGER = Logger.getLogger(UpdateElementPositionCommand.class.getName());
    private final String uuid;
    private final Point2D location;
    private final Point2D previousLocation;
    private transient Node<? extends View<?>, Edge> node;
    private Element<? extends View<?>> parent;
    private Boolean isDocked;

    public UpdateElementPositionCommand(@MapsTo(value="uuid") String uuid, @MapsTo(value="location") Point2D location, @MapsTo(value="previousLocation") Point2D previousLocation) {
        this.uuid = (String)PortablePreconditions.checkNotNull((String)"uuid", (Object)uuid);
        this.location = (Point2D)PortablePreconditions.checkNotNull((String)"location", (Object)location);
        this.previousLocation = (Point2D)PortablePreconditions.checkNotNull((String)"previousLocation", (Object)previousLocation);
        this.node = null;
    }

    public UpdateElementPositionCommand(Node<? extends View<?>, Edge> node, Point2D location) {
        this(node.getUUID(), location, GraphUtils.getPosition((View)node.getContent()));
        this.node = (Node)PortablePreconditions.checkNotNull((String)"node", node);
    }

    public Point2D getLocation() {
        return this.location;
    }

    public Point2D getPreviousLocation() {
        return this.previousLocation;
    }

    public Node<?, Edge> getNode() {
        return this.node;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
        return this.execute(context, bounds -> {});
    }

    public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
        return this.execute(context, bounds -> ((View)this.node.getContent()).setBounds(bounds));
    }

    private CommandResult<RuleViolation> execute(GraphCommandExecutionContext context, Consumer<Bounds> boundsConsumer) {
        Graph<?, Node> graph = this.getGraph(context);
        Node<? extends View<?>, Edge> element = this.getNodeNotNull(context);
        Bounds targetBounds = this.getTargetBounds((Element<? extends View<?>>)element);
        Bounds parentBounds = this.getParentBounds((Element)this.getNodeNotNull(context), (Graph<DefinitionSet, Node>)graph);
        boundsConsumer.accept(targetBounds);
        if (this.areBoundsExceeded(element, targetBounds, parentBounds)) {
            return new GraphCommandResultBuilder().addViolation(new BoundsExceededViolation(parentBounds).setUUID(this.node.getUUID())).build();
        }
        return GraphCommandResultBuilder.SUCCESS;
    }

    private boolean areBoundsExceeded(Node<? extends View<?>, Edge> element, Bounds bounds, Bounds parentBounds) {
        return !GraphUtils.checkBoundsExceeded(parentBounds, bounds) && !this.isDockedNode(element);
    }

    private boolean isDockedNode(Node<? extends View<?>, Edge> element) {
        if (Objects.isNull(this.isDocked)) {
            this.isDocked = GraphUtils.isDockedNode(element);
        }
        return this.isDocked;
    }

    private Bounds getTargetBounds(Element<? extends View<?>> element) {
        return UpdateElementPositionCommand.computeCandidateBounds(element, this.location);
    }

    private Bounds getParentBounds(Element element, Graph<DefinitionSet, Node> graph) {
        if (Objects.isNull(this.parent)) {
            this.parent = GraphUtils.getParent((Node)element);
        }
        if (this.parent != null && !GraphUtils.isRootNode(this.parent, graph)) {
            double[] size = GraphUtils.getNodeSize((View)this.parent.getContent());
            return Bounds.create((double)0.0, (double)0.0, (double)size[0], (double)size[1]);
        }
        return null;
    }

    public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
        UpdateElementPositionCommand undoCommand = new UpdateElementPositionCommand(this.getNodeNotNull(context), this.previousLocation);
        return undoCommand.execute(context);
    }

    private Node<? extends View<?>, Edge> getNodeNotNull(GraphCommandExecutionContext context) {
        if (null == this.node) {
            this.node = super.getNodeNotNull(context, this.uuid);
        }
        return this.node;
    }

    public static Bounds computeCandidateBounds(Element<? extends View<?>> element, Point2D location) {
        double[] oldSize = GraphUtils.getNodeSize((View)element.getContent());
        double w = oldSize[0];
        double h = oldSize[1];
        return Bounds.create((double)location.getX(), (double)location.getY(), (double)(location.getX() + w), (double)(location.getY() + h));
    }

    public String toString() {
        return "UpdateElementPositionCommand [element=" + this.uuid + ", location=" + this.location + ", previousLocation=" + this.previousLocation + "]";
    }
}

