/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent.local;

import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.ValidateUtils;

public class AgentImpl
implements SshAgent {
    private final List<Pair<KeyPair, String>> keys = new ArrayList<Pair<KeyPair, String>>();
    private final AtomicBoolean open = new AtomicBoolean(true);

    @Override
    public boolean isOpen() {
        return this.open.get();
    }

    @Override
    public List<Pair<PublicKey, String>> getIdentities() throws IOException {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        return GenericUtils.map(this.keys, kp -> new Pair(((KeyPair)kp.getFirst()).getPublic(), kp.getSecond()));
    }

    @Override
    public byte[] sign(PublicKey key, byte[] data) throws IOException {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        try {
            Signature verif;
            Pair<KeyPair, String> pp = Objects.requireNonNull(AgentImpl.getKeyPair(this.keys, key), "Key not found");
            KeyPair kp = ValidateUtils.checkNotNull(pp.getFirst(), "No key pair for agent=%s", (Object)pp.getSecond());
            PublicKey pubKey = ValidateUtils.checkNotNull(kp.getPublic(), "No public key for agent=%s", (Object)pp.getSecond());
            if (pubKey instanceof DSAPublicKey) {
                verif = (Signature)BuiltinSignatures.dsa.create();
            } else if (pubKey instanceof ECPublicKey) {
                ECPublicKey ecKey = (ECPublicKey)pubKey;
                verif = BuiltinSignatures.getByCurveSize(ecKey.getParams());
            } else if (pubKey instanceof RSAPublicKey) {
                verif = (Signature)BuiltinSignatures.rsa.create();
            } else if ("EdDSA".equalsIgnoreCase(pubKey.getAlgorithm())) {
                verif = (Signature)BuiltinSignatures.ed25519.create();
            } else {
                throw new InvalidKeySpecException("Unsupported key type: " + pubKey.getClass().getSimpleName());
            }
            verif.initSigner(kp.getPrivate());
            verif.update(data);
            return verif.sign();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    @Override
    public void addIdentity(KeyPair key, String comment) throws IOException {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        this.keys.add(new Pair<KeyPair, String>(Objects.requireNonNull(key, "No key"), comment));
    }

    @Override
    public void removeIdentity(PublicKey key) throws IOException {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        Pair<KeyPair, String> kp = AgentImpl.getKeyPair(this.keys, key);
        if (kp == null) {
            throw new SshException("Key not found");
        }
        this.keys.remove(kp);
    }

    @Override
    public void removeAllIdentities() throws IOException {
        if (!this.isOpen()) {
            throw new SshException("Agent closed");
        }
        this.keys.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.open.getAndSet(false)) {
            this.keys.clear();
        }
    }

    protected static Pair<KeyPair, String> getKeyPair(Collection<Pair<KeyPair, String>> keys, PublicKey key) {
        if (GenericUtils.isEmpty(keys) || key == null) {
            return null;
        }
        for (Pair<KeyPair, String> k : keys) {
            KeyPair kp = k.getFirst();
            if (!KeyUtils.compareKeys(key, kp.getPublic())) continue;
            return k;
        }
        return null;
    }
}

