/*
 * Decompiled with CFR 0.152.
 */
package org.kie.dmn.core.compiler;

import java.util.List;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.dmn.core.impl.DMNModelImpl;
import org.kie.dmn.core.util.Msg;
import org.kie.dmn.core.util.MsgUtil;
import org.kie.dmn.feel.parser.feel11.FEELParser;
import org.kie.dmn.model.api.DMNModelInstrumentedBase;
import org.kie.dmn.model.api.NamedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DMNCompilerHelper {
    private static final Logger logger = LoggerFactory.getLogger(DMNCompilerHelper.class);

    public static boolean checkVariableName(DMNModelImpl model, NamedElement element, String variableName) {
        List errors = FEELParser.checkVariableName((String)variableName);
        if (!errors.isEmpty()) {
            MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, (DMNModelInstrumentedBase)element, model, null, (FEELEvent)errors.get(0), Msg.INVALID_NAME, variableName, ((FEELEvent)errors.get(0)).getMessage());
            return false;
        }
        return true;
    }

    public static void reportMissingVariable(DMNModelImpl model, NamedElement node, DMNModelInstrumentedBase source, Msg.Message1 message) {
        MsgUtil.reportMessage(logger, DMNMessage.Severity.ERROR, source, model, null, null, message, node.getIdentifierString());
    }

    private DMNCompilerHelper() {
    }
}

