/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.query;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import org.kie.workbench.common.services.refactoring.backend.server.query.NamedQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.response.ResponseBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindResourcesQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringMapPageRow;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KProperty;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.Path;
import org.uberfire.paging.PageResponse;

public abstract class AbstractFindIdsQuery
extends FindResourcesQuery
implements NamedQuery {
    @Inject
    private BpmnProcessIdsResponseBuilder responseBuilder;
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;

    public abstract String getName();

    protected abstract ResourceType getProcessIdResourceType();

    public ResponseBuilder getResponseBuilder() {
        this.responseBuilder.setIOService(this.ioService);
        this.responseBuilder.setProcessIdResourceType(this.getProcessIdResourceType());
        return this.responseBuilder;
    }

    public void validateTerms(Set<ValueIndexTerm> queryTerms) throws IllegalArgumentException {
        this.checkInvalidAndRequiredTerms(queryTerms, this.getName(), new String[]{ValueResourceIndexTerm.class.getSimpleName()}, new Predicate[]{t -> {
            if (!(t instanceof ValueResourceIndexTerm)) {
                return false;
            }
            return ((ValueResourceIndexTerm)t).getTerm().equals(this.getProcessIdResourceType().toString());
        }});
        this.checkTermsSize(1, queryTerms);
    }

    public static class BpmnProcessIdsResponseBuilder
    implements ResponseBuilder {
        private IOService ioService;
        private ResourceType processIdResourceType;

        public BpmnProcessIdsResponseBuilder() {
        }

        public BpmnProcessIdsResponseBuilder(IOService ioService, ResourceType processIdResourceType) {
            this.ioService = ioService;
            this.processIdResourceType = processIdResourceType;
        }

        public void setIOService(IOService ioService) {
            this.ioService = ioService;
        }

        public void setProcessIdResourceType(ResourceType resourceType) {
            this.processIdResourceType = resourceType;
        }

        public PageResponse<RefactoringPageRow> buildResponse(int pageSize, int startRow, List<KObject> kObjects) {
            int hits = kObjects.size();
            PageResponse response = new PageResponse();
            List<RefactoringPageRow> result = this.buildResponse(kObjects);
            response.setTotalRowSize(hits);
            response.setPageRowList(result);
            response.setTotalRowSizeExact(true);
            response.setStartRowIndex(startRow);
            response.setLastPage(pageSize * startRow + 2 >= hits);
            return response;
        }

        public List<RefactoringPageRow> buildResponse(List<KObject> kObjects) {
            ArrayList<RefactoringPageRow> result = new ArrayList<RefactoringPageRow>(kObjects.size());
            for (KObject kObject : kObjects) {
                for (KProperty property : kObject.getProperties()) {
                    if (!property.getName().equals(this.processIdResourceType.toString())) continue;
                    String bpmnProcessId = (String)property.getValue();
                    org.uberfire.backend.vfs.Path path = Paths.convert((Path)this.ioService.get(URI.create(kObject.getKey())));
                    HashMap<String, org.uberfire.backend.vfs.Path> map = new HashMap<String, org.uberfire.backend.vfs.Path>();
                    map.put(bpmnProcessId, path);
                    RefactoringMapPageRow row = new RefactoringMapPageRow();
                    row.setValue(map);
                    result.add((RefactoringPageRow)row);
                }
            }
            return result;
        }
    }
}

