/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.backend.service;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.soup.commons.util.Sets;
import org.kie.workbench.common.services.refactoring.backend.server.query.standard.FindRuleFlowNamesQuery;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueSharedPartIndexTerm;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;

@ApplicationScoped
public class RuleFlowGroupQueryService {
    private final RefactoringQueryService queryService;
    private final Function<List<RefactoringPageRow>, List<String>> resultToSelectorData;
    public static Function<List<RefactoringPageRow>, List<String>> DEFAULT_RESULT_CONVERTER = rows -> rows.stream().map(RuleFlowGroupQueryService::getValue).filter(RuleFlowGroupQueryService::isNotEmpty).distinct().collect(Collectors.toList());

    public RuleFlowGroupQueryService() {
        this(null);
    }

    @Inject
    public RuleFlowGroupQueryService(RefactoringQueryService queryService) {
        this(queryService, DEFAULT_RESULT_CONVERTER);
    }

    RuleFlowGroupQueryService(RefactoringQueryService queryService, Function<List<RefactoringPageRow>, List<String>> resultToSelectorData) {
        this.queryService = queryService;
        this.resultToSelectorData = resultToSelectorData;
    }

    public List<String> getRuleFlowGroupNames() {
        List queryResult = this.queryService.query(FindRuleFlowNamesQuery.NAME, new Sets.Builder().add((Object)new ValueSharedPartIndexTerm("*", PartType.RULEFLOW_GROUP, ValueIndexTerm.TermSearchType.WILDCARD)).build());
        return this.resultToSelectorData.apply(queryResult);
    }

    private static String getValue(RefactoringPageRow row) {
        return (String)((Map)row.getValue()).get("name");
    }

    private static boolean isNotEmpty(String s) {
        return null != s && s.trim().length() > 0;
    }
}

