/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.workitem;

import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.bpmn.workitem.ServiceTask;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionRegistry;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.definition.builder.Builder;
import org.kie.workbench.common.stunner.core.factory.definition.DefinitionFactory;

@ApplicationScoped
public class ServiceTaskFactory
implements DefinitionFactory<ServiceTask> {
    private static final String PREFIX = BindableAdapterUtils.getGenericClassName(ServiceTask.class);
    private final Supplier<WorkItemDefinitionRegistry> registry;

    protected ServiceTaskFactory() {
        this.registry = null;
    }

    @Inject
    public ServiceTaskFactory(Instance<WorkItemDefinitionRegistry> registry) {
        this.registry = () -> registry.get();
    }

    public ServiceTaskFactory(Supplier<WorkItemDefinitionRegistry> registry) {
        this.registry = registry;
    }

    public boolean accepts(String identifier) {
        return identifier.startsWith(PREFIX);
    }

    public ServiceTask build(String identifier) {
        String name = BindableAdapterUtils.getDynamicId(ServiceTask.class, (String)identifier);
        return null != name ? this.buildItem(name) : ServiceTaskBuilder.newInstance();
    }

    public ServiceTask buildItem(String workItemName) {
        WorkItemDefinition workItemDefinition = this.getRegistry().get(workItemName);
        if (null != workItemDefinition) {
            return new ServiceTaskBuilder(workItemDefinition).build();
        }
        throw new RuntimeException("No service task builder found for [" + workItemName + "]");
    }

    private WorkItemDefinitionRegistry getRegistry() {
        return this.registry.get();
    }

    public static class ServiceTaskBuilder
    implements Builder<ServiceTask> {
        private final WorkItemDefinition workItemDefinition;

        public ServiceTaskBuilder(WorkItemDefinition workItemDefinition) {
            this.workItemDefinition = workItemDefinition;
        }

        public static ServiceTask newInstance() {
            return new ServiceTask();
        }

        public ServiceTask build() {
            ServiceTask serviceTask = ServiceTaskBuilder.newInstance();
            String name = this.workItemDefinition.getName();
            ServiceTaskBuilder.setProperties(this.workItemDefinition, serviceTask);
            serviceTask.getExecutionSet().getTaskName().setValue(name);
            serviceTask.getGeneral().getName().setValue(this.workItemDefinition.getDisplayName());
            serviceTask.getGeneral().getDocumentation().setValue(this.workItemDefinition.getDocumentation());
            serviceTask.setDescription(this.workItemDefinition.getDescription());
            serviceTask.getDataIOSet().getAssignmentsinfo().setValue(this.workItemDefinition.getParameters() + this.workItemDefinition.getResults());
            return serviceTask;
        }

        public static ServiceTask setProperties(WorkItemDefinition workItemDefinition, ServiceTask serviceTask) {
            String name = workItemDefinition.getName();
            serviceTask.setName(name);
            serviceTask.getTaskType().setRawType(name);
            serviceTask.setCategory(workItemDefinition.getCategory());
            serviceTask.setDefaultHandler(workItemDefinition.getDefaultHandler());
            return serviceTask;
        }
    }
}

