/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestHandler;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.threadpool.ThreadPool;

public class BulkProcessor
implements Closeable {
    private final int bulkActions;
    private final long bulkSize;
    private final ThreadPool.Cancellable cancellableFlushTask;
    private final AtomicLong executionIdGen = new AtomicLong();
    private BulkRequest bulkRequest;
    private final BulkRequestHandler bulkRequestHandler;
    private volatile boolean closed = false;

    public static Builder builder(Client client, Listener listener) {
        Objects.requireNonNull(client, "client");
        Objects.requireNonNull(listener, "listener");
        return new Builder(client::bulk, listener, client.threadPool());
    }

    BulkProcessor(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, BackoffPolicy backoffPolicy, Listener listener, int concurrentRequests, int bulkActions, ByteSizeValue bulkSize, @Nullable TimeValue flushInterval, ThreadPool threadPool) {
        this.bulkActions = bulkActions;
        this.bulkSize = bulkSize.getBytes();
        this.bulkRequest = new BulkRequest();
        this.bulkRequestHandler = concurrentRequests == 0 ? BulkRequestHandler.syncHandler(consumer, backoffPolicy, listener, threadPool) : BulkRequestHandler.asyncHandler(consumer, backoffPolicy, listener, threadPool, concurrentRequests);
        this.cancellableFlushTask = this.startFlushTask(flushInterval, threadPool);
    }

    @Override
    public void close() {
        try {
            this.awaitClose(0L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized boolean awaitClose(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.closed) {
            return true;
        }
        this.closed = true;
        this.cancellableFlushTask.cancel();
        if (this.bulkRequest.numberOfActions() > 0) {
            this.execute();
        }
        return this.bulkRequestHandler.awaitClose(timeout, unit);
    }

    public BulkProcessor add(IndexRequest request) {
        return this.add((DocWriteRequest)request);
    }

    public BulkProcessor add(DeleteRequest request) {
        return this.add((DocWriteRequest)request);
    }

    public BulkProcessor add(DocWriteRequest request) {
        return this.add(request, null);
    }

    public BulkProcessor add(DocWriteRequest request, @Nullable Object payload) {
        this.internalAdd(request, payload);
        return this;
    }

    boolean isOpen() {
        return !this.closed;
    }

    protected void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("bulk process already closed");
        }
    }

    private synchronized void internalAdd(DocWriteRequest request, @Nullable Object payload) {
        this.ensureOpen();
        this.bulkRequest.add(request, payload);
        this.executeIfNeeded();
    }

    @Deprecated
    public BulkProcessor add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType) throws Exception {
        return this.add(data, defaultIndex, defaultType, null, null);
    }

    public BulkProcessor add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, XContentType xContentType) throws Exception {
        return this.add(data, defaultIndex, defaultType, null, null, xContentType);
    }

    @Deprecated
    public synchronized BulkProcessor add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable String defaultPipeline, @Nullable Object payload) throws Exception {
        this.bulkRequest.add(data, defaultIndex, defaultType, null, null, null, defaultPipeline, payload, true);
        this.executeIfNeeded();
        return this;
    }

    public synchronized BulkProcessor add(BytesReference data, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable String defaultPipeline, @Nullable Object payload, XContentType xContentType) throws Exception {
        this.bulkRequest.add(data, defaultIndex, defaultType, null, null, null, defaultPipeline, payload, true, xContentType);
        this.executeIfNeeded();
        return this;
    }

    private ThreadPool.Cancellable startFlushTask(TimeValue flushInterval, ThreadPool threadPool) {
        if (flushInterval == null) {
            return new ThreadPool.Cancellable(){

                @Override
                public void cancel() {
                }

                @Override
                public boolean isCancelled() {
                    return true;
                }
            };
        }
        return threadPool.scheduleWithFixedDelay(new Flush(), flushInterval, "generic");
    }

    private void executeIfNeeded() {
        this.ensureOpen();
        if (!this.isOverTheLimit()) {
            return;
        }
        this.execute();
    }

    private void execute() {
        BulkRequest bulkRequest = this.bulkRequest;
        long executionId = this.executionIdGen.incrementAndGet();
        this.bulkRequest = new BulkRequest();
        this.bulkRequestHandler.execute(bulkRequest, executionId);
    }

    private boolean isOverTheLimit() {
        if (this.bulkActions != -1 && this.bulkRequest.numberOfActions() >= this.bulkActions) {
            return true;
        }
        return this.bulkSize != -1L && this.bulkRequest.estimatedSizeInBytes() >= this.bulkSize;
    }

    public synchronized void flush() {
        this.ensureOpen();
        if (this.bulkRequest.numberOfActions() > 0) {
            this.execute();
        }
    }

    class Flush
    implements Runnable {
        Flush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BulkProcessor bulkProcessor = BulkProcessor.this;
            synchronized (bulkProcessor) {
                if (BulkProcessor.this.closed) {
                    return;
                }
                if (BulkProcessor.this.bulkRequest.numberOfActions() == 0) {
                    return;
                }
                BulkProcessor.this.execute();
            }
        }
    }

    public static class Builder {
        private final BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer;
        private final Listener listener;
        private final ThreadPool threadPool;
        private int concurrentRequests = 1;
        private int bulkActions = 1000;
        private ByteSizeValue bulkSize = new ByteSizeValue(5L, ByteSizeUnit.MB);
        private TimeValue flushInterval = null;
        private BackoffPolicy backoffPolicy = BackoffPolicy.exponentialBackoff();

        public Builder(BiConsumer<BulkRequest, ActionListener<BulkResponse>> consumer, Listener listener, ThreadPool threadPool) {
            this.consumer = consumer;
            this.listener = listener;
            this.threadPool = threadPool;
        }

        public Builder setConcurrentRequests(int concurrentRequests) {
            this.concurrentRequests = concurrentRequests;
            return this;
        }

        public Builder setBulkActions(int bulkActions) {
            this.bulkActions = bulkActions;
            return this;
        }

        public Builder setBulkSize(ByteSizeValue bulkSize) {
            this.bulkSize = bulkSize;
            return this;
        }

        public Builder setFlushInterval(TimeValue flushInterval) {
            this.flushInterval = flushInterval;
            return this;
        }

        public Builder setBackoffPolicy(BackoffPolicy backoffPolicy) {
            if (backoffPolicy == null) {
                throw new NullPointerException("'backoffPolicy' must not be null. To disable backoff, pass BackoffPolicy.noBackoff()");
            }
            this.backoffPolicy = backoffPolicy;
            return this;
        }

        public BulkProcessor build() {
            return new BulkProcessor(this.consumer, this.backoffPolicy, this.listener, this.concurrentRequests, this.bulkActions, this.bulkSize, this.flushInterval, this.threadPool);
        }
    }

    public static interface Listener {
        public void beforeBulk(long var1, BulkRequest var3);

        public void afterBulk(long var1, BulkRequest var3, BulkResponse var4);

        public void afterBulk(long var1, BulkRequest var3, Throwable var4);
    }
}

