/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.entity.pillar;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.SelectorConfig;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.heuristic.selector.entity.pillar.SubPillarConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.move.generic.SubPillarType;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.DefaultPillarSelector;
import org.optaplanner.core.impl.heuristic.selector.entity.pillar.PillarSelector;

@XStreamAlias(value="pillarSelector")
public class PillarSelectorConfig
extends SelectorConfig<PillarSelectorConfig> {
    @XStreamAlias(value="entitySelector")
    protected EntitySelectorConfig entitySelectorConfig = null;
    protected Boolean subPillarEnabled = null;
    protected Integer minimumSubPillarSize = null;
    protected Integer maximumSubPillarSize = null;

    public EntitySelectorConfig getEntitySelectorConfig() {
        return this.entitySelectorConfig;
    }

    public void setEntitySelectorConfig(EntitySelectorConfig entitySelectorConfig) {
        this.entitySelectorConfig = entitySelectorConfig;
    }

    @Deprecated
    public Boolean getSubPillarEnabled() {
        return this.subPillarEnabled;
    }

    @Deprecated
    public void setSubPillarEnabled(Boolean subPillarEnabled) {
        this.subPillarEnabled = subPillarEnabled;
    }

    public Integer getMinimumSubPillarSize() {
        return this.minimumSubPillarSize;
    }

    public void setMinimumSubPillarSize(Integer minimumSubPillarSize) {
        this.minimumSubPillarSize = minimumSubPillarSize;
    }

    public Integer getMaximumSubPillarSize() {
        return this.maximumSubPillarSize;
    }

    public void setMaximumSubPillarSize(Integer maximumSubPillarSize) {
        this.maximumSubPillarSize = maximumSubPillarSize;
    }

    public PillarSelector buildPillarSelector(HeuristicConfigPolicy configPolicy, SubPillarType subPillarType, Class<? extends Comparator> subPillarSequenceComparatorClass, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder, List<String> variableNameIncludeList) {
        if (this.subPillarEnabled != null && subPillarType != null) {
            throw new IllegalArgumentException("Property subPillarEnabled (" + this.subPillarEnabled + ") on pillarSelectorConfig (" + this + ") must not be present when subPillarType (" + (Object)((Object)subPillarType) + ") is set on the parent MoveSelectorConfig.");
        }
        if (subPillarType != SubPillarType.SEQUENCE && subPillarSequenceComparatorClass != null) {
            throw new IllegalArgumentException("Subpillar type (" + (Object)((Object)subPillarType) + ") on pillarSelectorConfig (" + this + ") is not " + (Object)((Object)SubPillarType.SEQUENCE) + ", yet subPillarSequenceComparatorClass (" + subPillarSequenceComparatorClass + ") is provided.");
        }
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) > 0) {
            throw new IllegalArgumentException("The pillarSelectorConfig (" + this + ")'s minimumCacheType (" + (Object)((Object)minimumCacheType) + ") must not be higher than " + (Object)((Object)SelectionCacheType.STEP) + " because the pillars change every step.");
        }
        boolean subPillarActuallyEnabled = this.subPillarEnabled != null ? this.subPillarEnabled : subPillarType != SubPillarType.NONE;
        EntitySelectorConfig entitySelectorConfig_ = this.entitySelectorConfig == null ? new EntitySelectorConfig() : this.entitySelectorConfig;
        EntitySelector entitySelector = entitySelectorConfig_.buildEntitySelector(configPolicy, minimumCacheType, SelectionOrder.ORIGINAL);
        List<GenuineVariableDescriptor> variableDescriptors = this.deduceVariableDescriptorList(entitySelector.getEntityDescriptor(), variableNameIncludeList);
        if (!(subPillarActuallyEnabled || this.minimumSubPillarSize == null && this.maximumSubPillarSize == null)) {
            throw new IllegalArgumentException("The pillarSelectorConfig (" + this + ") must not disable subpillars while providing minimumSubPillarSize (" + this.minimumSubPillarSize + ") or maximumSubPillarSize (" + this.maximumSubPillarSize + ").");
        }
        SubPillarConfigPolicy subPillarPolicy = subPillarActuallyEnabled ? this.configureSubPillars(subPillarType, subPillarSequenceComparatorClass, entitySelector, this.minimumSubPillarSize, this.maximumSubPillarSize) : SubPillarConfigPolicy.withoutSubpillars();
        return new DefaultPillarSelector(entitySelector, variableDescriptors, inheritedSelectionOrder.toRandomSelectionBoolean(), subPillarPolicy);
    }

    private SubPillarConfigPolicy configureSubPillars(SubPillarType pillarType, Class<? extends Comparator> pillarOrderComparatorClass, EntitySelector entitySelector, Integer minimumSubPillarSize, Integer maximumSubPillarSize) {
        int actualMinimumSubPillarSize = (Integer)ObjectUtils.defaultIfNull((Object)minimumSubPillarSize, (Object)1);
        int actualMaximumSubPillarSize = (Integer)ObjectUtils.defaultIfNull((Object)maximumSubPillarSize, (Object)Integer.MAX_VALUE);
        if (pillarType == null) {
            return SubPillarConfigPolicy.withSubpillars(actualMinimumSubPillarSize, actualMaximumSubPillarSize);
        }
        switch (pillarType) {
            case ALL: {
                return SubPillarConfigPolicy.withSubpillars(actualMinimumSubPillarSize, actualMaximumSubPillarSize);
            }
            case SEQUENCE: {
                if (pillarOrderComparatorClass == null) {
                    Class<?> entityClass = entitySelector.getEntityDescriptor().getEntityClass();
                    boolean isComparable = Comparable.class.isAssignableFrom(entityClass);
                    if (!isComparable) {
                        throw new IllegalArgumentException("Pillar type (" + (Object)((Object)pillarType) + ") on pillarSelectorConfig (" + this + ") does not provide pillarOrderComparatorClass while the entity (" + entityClass.getCanonicalName() + ") does not implement Comparable.");
                    }
                    Comparator comparator = Comparable::compareTo;
                    return SubPillarConfigPolicy.sequential(actualMinimumSubPillarSize, actualMaximumSubPillarSize, comparator);
                }
                Comparator comparator = ConfigUtils.newInstance(this, "pillarOrderComparatorClass", pillarOrderComparatorClass);
                return SubPillarConfigPolicy.sequential(actualMinimumSubPillarSize, actualMaximumSubPillarSize, comparator);
            }
        }
        throw new IllegalStateException("Subpillars can not be enabled and disabled at the same time.");
    }

    @Override
    public void inherit(PillarSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.entitySelectorConfig = ConfigUtils.inheritConfig(this.entitySelectorConfig, inheritedConfig.getEntitySelectorConfig());
        this.subPillarEnabled = ConfigUtils.inheritOverwritableProperty(this.subPillarEnabled, inheritedConfig.getSubPillarEnabled());
        this.minimumSubPillarSize = ConfigUtils.inheritOverwritableProperty(this.minimumSubPillarSize, inheritedConfig.getMinimumSubPillarSize());
        this.maximumSubPillarSize = ConfigUtils.inheritOverwritableProperty(this.maximumSubPillarSize, inheritedConfig.getMaximumSubPillarSize());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelectorConfig + ")";
    }
}

