/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.server;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.project.backend.server.utils.PathUtil;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.examples.backend.server.BaseProjectImportService;
import org.kie.workbench.common.screens.examples.model.Credentials;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.examples.service.ProjectImportService;
import org.kie.workbench.common.screens.examples.validation.ImportProjectValidators;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

@Service
@ApplicationScoped
public class ProjectImportServiceImpl
extends BaseProjectImportService
implements ProjectImportService {
    private static final Pattern STRIP_DOT_GIT = Pattern.compile("\\.git$");
    private Logger logger = LoggerFactory.getLogger(ProjectImportServiceImpl.class);
    private RepositoryFactory repositoryFactory;
    private final PathUtil pathUtil;
    private final Event<NewProjectEvent> newProjectEvent;
    private final RepositoryService repoService;
    private final Set<Repository> clonedRepositories = new HashSet<Repository>();

    @Inject
    public ProjectImportServiceImpl(@Named(value="ioStrategy") IOService ioService, MetadataService metadataService, RepositoryFactory repositoryFactory, KieModuleService moduleService, ImportProjectValidators validators, PathUtil pathUtil, WorkspaceProjectService projectService, ProjectScreenService projectScreenService, Event<NewProjectEvent> newProjectEvent, RepositoryService repoService, SpaceConfigStorageRegistry spaceConfigStorageRegistry) {
        super(ioService, metadataService, validators, moduleService, projectService, projectScreenService, spaceConfigStorageRegistry);
        this.repositoryFactory = repositoryFactory;
        this.pathUtil = pathUtil;
        this.newProjectEvent = newProjectEvent;
        this.repoService = repoService;
    }

    @Override
    protected Repository resolveGitRepository(ExampleRepository repository) {
        try {
            String url = repository.getUrl();
            String alias = this.getRepositoryAlias(url);
            Credentials credentials = repository.getCredentials();
            String username = null;
            String password = null;
            if (credentials != null) {
                username = credentials.getUsername();
                password = credentials.getPassword();
            }
            Map<String, Object> env = this.buildGitEnv(url, username, password, true);
            RepositoryInfo repositoryConfig = this.createConfigGroup(alias, env);
            Repository repo = this.repositoryFactory.newRepository(repositoryConfig);
            this.clonedRepositories.add(repo);
            return repo;
        }
        catch (Exception e) {
            this.logger.error("Error during create repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public int priority() {
        return 0;
    }

    public void dispose() {
        for (Repository repository : this.clonedRepositories) {
            try {
                if (!repository.getDefaultBranch().isPresent()) continue;
                this.ioService.delete(Paths.convert((org.uberfire.backend.vfs.Path)((Branch)repository.getDefaultBranch().get()).getPath()).getFileSystem().getPath(null, new String[0]), new DeleteOption[0]);
            }
            catch (Exception e) {
                this.logger.warn("Unable to remove transient Repository '" + repository.getAlias() + "'.", (Throwable)e);
            }
        }
    }

    public WorkspaceProjectContextChangeEvent importProjects(OrganizationalUnit activeOU, List<ImportProject> projects) {
        PortablePreconditions.checkNotNull((String)"activeOU", (Object)activeOU);
        PortablePreconditions.checkNotNull((String)"projects", projects);
        PortablePreconditions.checkCondition((String)"Must have at least one Project", (projects.size() > 0 ? 1 : 0) != 0);
        return (WorkspaceProjectContextChangeEvent)this.spaceConfigStorageRegistry.getBatch(activeOU.getSpace().getName()).run(context -> {
            List importedProjects = projects.stream().map(exampleProject -> {
                WorkspaceProject project = this.importProject(activeOU, (ImportProject)exampleProject);
                project = this.renameIfNecessary(activeOU, project);
                this.newProjectEvent.fire((Object)new NewProjectEvent(project));
                return project;
            }).collect(Collectors.toList());
            if (importedProjects.size() == 1) {
                WorkspaceProject importedProject = (WorkspaceProject)importedProjects.get(0);
                return new WorkspaceProjectContextChangeEvent(importedProject, importedProject.getMainModule());
            }
            return new WorkspaceProjectContextChangeEvent(activeOU);
        });
    }

    public WorkspaceProject importProject(OrganizationalUnit organizationalUnit, ImportProject importProject) {
        return (WorkspaceProject)this.spaceConfigStorageRegistry.getBatch(organizationalUnit.getSpace().getName()).run(context -> {
            Path rootPath = this.getProjectRoot(importProject);
            String origin = importProject.getOrigin();
            if (this.pathUtil.convert(importProject.getRoot()).equals(rootPath)) {
                String username = null;
                String password = null;
                Credentials credentials = importProject.getCredentials();
                List branches = importProject.getSelectedBranches();
                if (credentials != null) {
                    username = credentials.getUsername();
                    password = credentials.getPassword();
                }
                return this.importProject(organizationalUnit, origin, username, password, branches);
            }
            RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
            configurations.setInit(false);
            configurations.setOrigin(origin);
            configurations.setBranches(this.getBranches(importProject, rootPath));
            Credentials credentials = importProject.getCredentials();
            if (credentials != null && credentials.getUsername() != null && credentials.getPassword() != null) {
                configurations.setUserName(credentials.getUsername());
                configurations.setPassword(credentials.getPassword());
            }
            configurations.setMirror(false);
            String subdirectoryPath = this.pathUtil.stripRepoNameAndSpace(this.pathUtil.stripProtocolAndBranch(importProject.getRoot().toURI()));
            configurations.setSubdirectory(subdirectoryPath);
            Repository importedRepo = this.repoService.createRepository(organizationalUnit, GitRepository.SCHEME.toString(), importProject.getName(), configurations);
            WorkspaceProject project = this.projectService.resolveProject(importedRepo);
            this.newProjectEvent.fire((Object)new NewProjectEvent(project));
            return project;
        });
    }

    public WorkspaceProject importProject(OrganizationalUnit targetOU, String repositoryURL, String username, String password, List<String> branches) {
        return (WorkspaceProject)this.spaceConfigStorageRegistry.getBatch(targetOU.getSpace().getName()).run(context -> {
            RepositoryEnvironmentConfigurations config = new RepositoryEnvironmentConfigurations();
            config.setOrigin(repositoryURL);
            if (username != null && password != null) {
                config.setUserName(username);
                config.setPassword(password);
            }
            config.setBranches(branches);
            String targetProjectName = this.inferProjectName(repositoryURL);
            Repository repo = this.repoService.createRepository(targetOU, GitRepository.SCHEME.toString(), targetProjectName, config);
            return this.projectService.resolveProject(repo);
        });
    }

    @Override
    protected ImportProject makeExampleProject(Module module, ExampleRepository repository) {
        String description = this.readDescription(module);
        List<String> tags = this.getTags(module);
        return new ImportProject(module.getRootPath(), module.getModuleName(), description, repository.getUrl(), tags, repository.getCredentials(), this.getBranches(this.getProjectRoot(module.getRootPath()), module.getRootPath()), true);
    }

    private List<String> getBranches(ImportProject importProject, Path rootPath) {
        if (importProject.getSelectedBranches() == null || importProject.getSelectedBranches().isEmpty()) {
            return this.getBranches(rootPath, importProject.getRoot());
        }
        return importProject.getSelectedBranches();
    }

    List<String> getBranches(Path rootPath, org.uberfire.backend.vfs.Path projectPath) {
        FileSystem fs = rootPath.getFileSystem();
        String exampleRootPath = this.pathUtil.stripRepoNameAndSpace(this.pathUtil.stripProtocolAndBranch(projectPath.toURI()));
        return StreamSupport.stream(fs.getRootDirectories().spliterator(), false).filter(root -> this.exists(root.resolve(exampleRootPath))).map(arg_0 -> ((PathUtil)this.pathUtil).convert(arg_0)).map(root -> this.pathUtil.extractBranch(root.toURI())).flatMap(oBranch -> oBranch.map(Stream::of).orElse(Stream.empty())).collect(Collectors.toList());
    }

    private boolean exists(Path path) {
        try {
            FileSystemProvider provider = path.getFileSystem().provider();
            provider.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return true;
        }
        catch (NoSuchFileException nfe) {
            return false;
        }
    }

    String inferProjectName(String repositoryURL) {
        if ((repositoryURL = repositoryURL.replaceAll("\\\\", "/")).endsWith(".git")) {
            repositoryURL = repositoryURL.substring(0, repositoryURL.length() - 4);
        }
        if (repositoryURL.endsWith("/")) {
            repositoryURL = repositoryURL.substring(0, repositoryURL.length() - 1);
        }
        if (repositoryURL.lastIndexOf(47) < 0) {
            return "new-project";
        }
        return repositoryURL.substring(repositoryURL.lastIndexOf(47) + 1);
    }

    private Path getProjectRoot(ImportProject importProject) {
        return this.getProjectRoot(importProject.getRoot());
    }

    private Path getProjectRoot(org.uberfire.backend.vfs.Path rootPath) {
        return Stream.iterate(this.pathUtil.convert(rootPath), p -> p.getParent()).filter(p -> p != null && p.getParent() == null).findFirst().get();
    }
}

