/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.dtable.backend.server.conversion;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.drools.core.util.DateUtils;
import org.drools.core.util.StringUtils;
import org.drools.workbench.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemCol52;
import org.drools.workbench.models.guided.dtable.shared.model.ActionWorkItemSetFieldCol52;
import org.drools.workbench.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.workbench.models.guided.dtable.shared.model.BaseColumn;
import org.drools.workbench.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.workbench.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.workbench.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.workbench.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.workbench.models.guided.dtable.shared.util.ColumnUtilitiesBase;
import org.drools.workbench.screens.guided.dtable.backend.server.conversion.XLSColumnUtilities;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.soup.project.datamodel.oracle.DataType;
import org.kie.soup.project.datamodel.oracle.PackageDataModelOracle;

public class DataBuilder {
    private static final int FIRST_DATA_ROW = 9;
    private final Sheet sheet;
    private final GuidedDecisionTable52 dtable;
    private final ColumnUtilitiesBase utilsWithRespectForLists;
    private final ColumnUtilitiesBase utilsWithNoRespectForLists;
    private int rowCount = 9;

    public DataBuilder(Sheet sheet, GuidedDecisionTable52 dtable, PackageDataModelOracle dmo) {
        this.sheet = (Sheet)PortablePreconditions.checkNotNull((String)"sheet", (Object)sheet);
        this.dtable = (GuidedDecisionTable52)PortablePreconditions.checkNotNull((String)"dtable", (Object)dtable);
        PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.utilsWithRespectForLists = new XLSColumnUtilities(dtable, dmo, true);
        this.utilsWithNoRespectForLists = new XLSColumnUtilities(dtable, dmo, false);
    }

    public void build() {
        for (List row : this.dtable.getData()) {
            new DataRowBuilder(row).build();
        }
    }

    class DataRowBuilder {
        private final Row xlsRow;
        private final Set<String> addedInserts;
        private final List<DTCellValue52> row;
        private int sourceColumnIndex;
        private int targetColumnIndex;

        public DataRowBuilder(List<DTCellValue52> row) {
            this.xlsRow = DataBuilder.this.sheet.createRow(DataBuilder.this.rowCount);
            this.addedInserts = new HashSet<String>();
            this.sourceColumnIndex = 0;
            this.targetColumnIndex = -1;
            this.row = row;
        }

        public void build() {
            for (DTCellValue52 cell : this.row) {
                if (this.sourceColumnIndex == 1) {
                    this.xlsRow.createCell(this.targetColumnIndex).setCellValue(cell.getStringValue());
                } else if (this.sourceColumnIndex > 1) {
                    BaseColumn baseColumn = (BaseColumn)DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex);
                    if (baseColumn instanceof ActionInsertFactCol52) {
                        this.addActionInsertFirstColumn();
                    }
                    if (this.isOperator("== null") || this.isOperator("!= null")) {
                        this.xlsRow.createCell(this.targetColumnIndex).setCellValue("null");
                    } else if (this.isWorkItemColumn()) {
                        if (cell.getBooleanValue() != null && cell.getBooleanValue().booleanValue()) {
                            this.xlsRow.createCell(this.targetColumnIndex).setCellValue("X");
                        }
                    } else if (DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex) instanceof ActionRetractFactCol52) {
                        if (!StringUtils.isEmpty((CharSequence)cell.getStringValue())) {
                            this.xlsRow.createCell(this.targetColumnIndex).setCellValue(cell.getStringValue());
                        }
                    } else {
                        this.setValue(cell, this.getColumnDataType(this.sourceColumnIndex));
                    }
                }
                ++this.sourceColumnIndex;
                ++this.targetColumnIndex;
            }
            DataBuilder.this.rowCount++;
        }

        private boolean isWorkItemColumn() {
            BaseColumn column = (BaseColumn)DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex);
            return column instanceof ActionWorkItemCol52 || column instanceof ActionWorkItemSetFieldCol52;
        }

        private void addActionInsertFirstColumn() {
            ActionInsertFactCol52 column = (ActionInsertFactCol52)DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex);
            if (!this.addedInserts.contains(column.getBoundName())) {
                this.addedInserts.add(column.getBoundName());
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue("X");
                ++this.targetColumnIndex;
            }
        }

        private void setValue(DTCellValue52 cell, DataType.DataTypes dataType) {
            switch (dataType) {
                case STRING: {
                    this.setStringValue(cell);
                    break;
                }
                case NUMERIC: 
                case NUMERIC_BIGDECIMAL: 
                case NUMERIC_BIGINTEGER: 
                case NUMERIC_BYTE: 
                case NUMERIC_DOUBLE: 
                case NUMERIC_FLOAT: 
                case NUMERIC_INTEGER: 
                case NUMERIC_LONG: 
                case NUMERIC_SHORT: {
                    this.setNumericValue(cell);
                    break;
                }
                case DATE: {
                    this.setDateValue(cell);
                    break;
                }
                case BOOLEAN: {
                    this.setBooleanValue(cell);
                }
            }
        }

        private void setNumericValue(DTCellValue52 cell) {
            Number numericValue = cell.getNumericValue();
            if (numericValue != null) {
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue(numericValue.toString());
            }
        }

        private void setBooleanValue(DTCellValue52 cell) {
            Boolean booleanValue = cell.getBooleanValue();
            if (booleanValue != null) {
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue(booleanValue.toString());
            }
        }

        private void setDateValue(DTCellValue52 cell) {
            Date dateValue = cell.getDateValue();
            if (dateValue != null) {
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue(String.format("\"%s\"", DateUtils.format((Date)dateValue)));
            }
        }

        private void setStringValue(DTCellValue52 cell) {
            if (this.isTheRealCellValueString(this.sourceColumnIndex) && cell.getStringValue() != null) {
                if (cell.getStringValue() != null && !cell.getStringValue().isEmpty()) {
                    if (this.isOperator("in")) {
                        this.xlsRow.createCell(this.targetColumnIndex).setCellValue(String.format("(%s)", this.fixStringValue(cell)));
                    } else {
                        this.xlsRow.createCell(this.targetColumnIndex).setCellValue(String.format("\"%s\"", this.fixStringValue(cell)));
                    }
                }
            } else if (Objects.equals(DataType.DataTypes.STRING, cell.getDataType())) {
                this.xlsRow.createCell(this.targetColumnIndex).setCellValue(cell.getStringValue());
            } else {
                this.setValue(cell, cell.getDataType());
            }
        }

        private boolean isOperator(String operator) {
            if (DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex) instanceof ConditionCol52) {
                ConditionCol52 column = (ConditionCol52)DataBuilder.this.dtable.getExpandedColumns().get(this.sourceColumnIndex);
                return Objects.equals(column.getOperator(), operator);
            }
            return false;
        }

        private String fixStringValue(DTCellValue52 cell) {
            if (cell.getStringValue().length() > 2 && cell.getStringValue().startsWith("\"") && cell.getStringValue().endsWith("\"")) {
                return cell.getStringValue().substring(1, cell.getStringValue().length() - 1);
            }
            return cell.getStringValue();
        }

        private boolean isTheRealCellValueString(int sourceColumnIndex) {
            return !(DataBuilder.this.dtable.getExpandedColumns().get(sourceColumnIndex) instanceof AttributeCol52) && !(DataBuilder.this.dtable.getExpandedColumns().get(sourceColumnIndex) instanceof MetadataCol52) && !this.isFormula(sourceColumnIndex) && Objects.equals(DataType.DataTypes.STRING, DataBuilder.this.utilsWithNoRespectForLists.getTypeSafeType((BaseColumn)DataBuilder.this.dtable.getExpandedColumns().get(sourceColumnIndex)));
        }

        private boolean isFormula(int sourceColumnIndex) {
            int constraintValueType;
            return DataBuilder.this.dtable.getExpandedColumns().get(sourceColumnIndex) instanceof ConditionCol52 && ((constraintValueType = ((ConditionCol52)DataBuilder.this.dtable.getExpandedColumns().get(sourceColumnIndex)).getConstraintValueType()) == 3 || constraintValueType == 5);
        }

        private DataType.DataTypes getColumnDataType(int columnIndex) {
            return DataBuilder.this.utilsWithRespectForLists.getTypeSafeType((BaseColumn)DataBuilder.this.dtable.getExpandedColumns().get(columnIndex));
        }
    }
}

