/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.process.workitem.okta;

import com.okta.sdk.client.Client;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.user.User;
import org.jbpm.process.workitem.core.AbstractLogOrThrowWorkItemHandler;
import org.jbpm.process.workitem.core.util.RequiredParameterValidator;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidAuth;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.jbpm.process.workitem.okta.OktaAuth;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="OktaAddUserToGroup.wid", name="OktaAddUserToGroup", displayName="OktaAddUserToGroup", defaultHandler="mvel: new org.jbpm.process.workitem.okta.AddUserToGroupWorkitemHandler(\"apiToken\")", documentation="okta-workitem/index.html", category="okta-workitem", icon="OktaAddUserToGroup.png", parameters={@WidParameter(name="UserId", required=true), @WidParameter(name="GroupId", required=true)}, mavenDepends={@WidMavenDepends(group="org.jbpm.contrib", artifact="okta-workitem", version="7.29.0.Final")}, serviceInfo=@WidService(category="Okta", description="Interact with Okta management API", keywords="okta,auth,user,add,group", action=@WidAction(title="Add user to group in Okta"), authinfo=@WidAuth(required=true, params={"apiToken"}, paramsdescription={"Okta api token"}, referencesite="https://developer.okta.com/")))
public class AddUserToGroupWorkitemHandler
extends AbstractLogOrThrowWorkItemHandler {
    private Client oktaClient;
    private OktaAuth auth = new OktaAuth();

    public AddUserToGroupWorkitemHandler() throws Exception {
        try {
            this.oktaClient = this.auth.authorize();
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with Okta: " + e.getMessage());
        }
    }

    public AddUserToGroupWorkitemHandler(String apiToken) throws Exception {
        try {
            this.oktaClient = this.auth.authorize(apiToken);
        }
        catch (Exception e) {
            throw new IllegalAccessException("Unable to authenticate with Okta: " + e.getMessage());
        }
    }

    public AddUserToGroupWorkitemHandler(Client oktaClient) {
        this.oktaClient = oktaClient;
    }

    public void executeWorkItem(WorkItem workItem, WorkItemManager workItemManager) {
        try {
            RequiredParameterValidator.validate(((Object)((Object)this)).getClass(), (WorkItem)workItem);
            String userId = (String)workItem.getParameter("UserId");
            String groupId = (String)workItem.getParameter("GroupId");
            User user = this.oktaClient.getUser(userId);
            if (user == null) {
                throw new IllegalArgumentException("Not able to find user with id: " + userId);
            }
            Group group = this.oktaClient.getGroup(groupId);
            if (group != null) {
                throw new IllegalArgumentException("Not able to find group with id: " + groupId);
            }
            user.addToGroup(groupId);
            workItemManager.completeWorkItem(workItem.getId(), null);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void abortWorkItem(WorkItem wi, WorkItemManager wim) {
    }
}

