/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.backend.validation.FileNameValidator;
import org.uberfire.ext.editor.commons.service.ValidationService;

@Service
@ApplicationScoped
public class ValidationServiceImpl
implements ValidationService {
    @Any
    @Inject
    private Instance<FileNameValidator> fileNameValidatorBeans;
    private List<FileNameValidator> sortedValidators = new ArrayList<FileNameValidator>();

    @PostConstruct
    public void configureValidators() {
        for (FileNameValidator fileNameValidator : this.fileNameValidatorBeans) {
            this.sortedValidators.add(fileNameValidator);
        }
        Collections.sort(this.sortedValidators, new Comparator<FileNameValidator>(){

            @Override
            public int compare(FileNameValidator o1, FileNameValidator o2) {
                return o2.getPriority() - o1.getPriority();
            }
        });
    }

    public boolean isFileNameValid(String fileName) {
        for (FileNameValidator fileNameValidator : this.sortedValidators) {
            if (!fileNameValidator.accept(fileName)) continue;
            return fileNameValidator.isValid(fileName);
        }
        return false;
    }

    public boolean isFileNameValid(Path path, String fileName) {
        for (FileNameValidator fileNameValidator : this.sortedValidators) {
            if (!fileNameValidator.accept(path)) continue;
            return fileNameValidator.isValid(fileName);
        }
        return false;
    }
}

