/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedNotificationsInfos;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.associations.AssociationType;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationTypeListValue;
import org.kie.workbench.common.stunner.bpmn.definition.property.notification.NotificationsInfo;

public class NotificationsInfos {
    private static Set<String> RESERVED_ASSIGNMENTS = new HashSet<String>(Arrays.asList(AssociationType.NOT_COMPLETED_NOTIFY.getName(), AssociationType.NOT_STARTED_NOTIFY.getName()));

    public static NotificationsInfo of(List<DataInputAssociation> dataInputAssociations) {
        NotificationTypeListValue notifications = new NotificationTypeListValue();
        dataInputAssociations.forEach(din -> {
            String body;
            Assignment assignment;
            DataInput targetRef = (DataInput)din.getTargetRef();
            if (NotificationsInfos.isReservedIdentifier(targetRef.getName()) && !din.getAssignment().isEmpty() && (assignment = (Assignment)din.getAssignment().get(0)) != null && (body = ((FormalExpression)assignment.getFrom()).getBody()) != null) {
                Arrays.stream(NotificationsInfos.replaceBracket(body).split("\\^")).forEach(b -> notifications.addValue(ParsedNotificationsInfos.of(targetRef.getName(), b)));
            }
        });
        return new NotificationsInfo(notifications);
    }

    public static boolean isReservedIdentifier(String targetName) {
        return RESERVED_ASSIGNMENTS.contains(targetName);
    }

    private static String replaceBracket(String original) {
        return original.replaceFirst("\\[", "").replace("]", "");
    }
}

