/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.textannotation;

import org.eclipse.bpmn2.TextAnnotation;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.NodeConverter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.TextAnnotationPropertyReader;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Documentation;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;

public class TextAnnotationConverter
implements NodeConverter<TextAnnotation> {
    private final TypedFactoryManager typedFactoryManager;
    private PropertyReaderFactory propertyReaderFactory;

    public TextAnnotationConverter(TypedFactoryManager typedFactoryManager, PropertyReaderFactory propertyReaderFactory) {
        this.typedFactoryManager = typedFactoryManager;
        this.propertyReaderFactory = propertyReaderFactory;
    }

    @Override
    public Result<BpmnNode> convert(TextAnnotation element) {
        return this.convert(element, this.propertyReaderFactory.of(element));
    }

    private Result<BpmnNode> convert(TextAnnotation element, TextAnnotationPropertyReader p) {
        Node node = this.typedFactoryManager.newNode(element.getId(), org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation.class);
        org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation definition = (org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation)((View)node.getContent()).getDefinition();
        definition.setGeneral(new BPMNGeneralSet(new Name(p.getName()), new Documentation(p.getDocumentation())));
        ((View)node.getContent()).setBounds(p.getBounds());
        definition.setDimensionsSet(p.getRectangleDimensionsSet());
        definition.setFontSet(p.getFontSet());
        definition.setBackgroundSet(p.getBackgroundSet());
        return Result.success(BpmnNode.of(node, p), new MarshallingMessage[0]);
    }
}

