/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.java.nio.fs.jgit.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.internal.ketch.KetchLeader;
import org.eclipse.jgit.internal.ketch.KetchLeaderCache;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RefSpec;
import org.uberfire.commons.data.Pair;
import org.uberfire.java.nio.base.FileDiff;
import org.uberfire.java.nio.base.TextualDiff;
import org.uberfire.java.nio.fs.jgit.JGitFileSystemProviderConfiguration;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.commands.Clone;
import org.uberfire.java.nio.fs.jgit.util.commands.CreateRepository;
import org.uberfire.java.nio.fs.jgit.util.commands.Fork;
import org.uberfire.java.nio.fs.jgit.util.commands.SubdirectoryClone;
import org.uberfire.java.nio.fs.jgit.util.model.CommitContent;
import org.uberfire.java.nio.fs.jgit.util.model.CommitHistory;
import org.uberfire.java.nio.fs.jgit.util.model.CommitInfo;
import org.uberfire.java.nio.fs.jgit.util.model.PathInfo;

public interface Git {
    public static Git createRepository(File repoDir) {
        return Git.createRepository(repoDir, null, JGitFileSystemProviderConfiguration.DEFAULT_GIT_HTTP_SSL_VERIFY);
    }

    public static Git createRepository(File repoDir, boolean sslVerify) {
        return Git.createRepository(repoDir, null, sslVerify);
    }

    public static Git createRepository(File repoDir, File hookDir) {
        return Git.createRepository(repoDir, hookDir, null, JGitFileSystemProviderConfiguration.DEFAULT_GIT_HTTP_SSL_VERIFY);
    }

    public static Git createRepository(File repoDir, File hookDir, boolean sslVerify) {
        return Git.createRepository(repoDir, hookDir, null, sslVerify);
    }

    public static Git createRepository(File repoDir, File hookDir, KetchLeaderCache leaders) {
        return new CreateRepository(repoDir, hookDir, leaders, JGitFileSystemProviderConfiguration.DEFAULT_GIT_HTTP_SSL_VERIFY).execute().get();
    }

    public static Git createRepository(File repoDir, File hookDir, KetchLeaderCache leaders, boolean sslVerify) {
        return new CreateRepository(repoDir, hookDir, leaders, sslVerify).execute().get();
    }

    public static Git fork(File gitRepoContainerDir, String origin, String name, List<String> branches, CredentialsProvider credential, KetchLeaderCache leaders, File hookDir) {
        return new Fork(gitRepoContainerDir, origin, name, branches, credential, leaders, hookDir, JGitFileSystemProviderConfiguration.DEFAULT_GIT_HTTP_SSL_VERIFY).execute();
    }

    public static Git fork(File gitRepoContainerDir, String origin, String name, List<String> branches, CredentialsProvider credential, KetchLeaderCache leaders, File hookDir, boolean sslVerify) {
        return new Fork(gitRepoContainerDir, origin, name, branches, credential, leaders, hookDir, sslVerify).execute();
    }

    public static Git clone(File repoDest, String origin, boolean isMirror, List<String> branches, CredentialsProvider credential, KetchLeaderCache leaders, File hookDir) {
        return new Clone(repoDest, origin, isMirror, branches, credential, leaders, hookDir, JGitFileSystemProviderConfiguration.DEFAULT_GIT_HTTP_SSL_VERIFY).execute().get();
    }

    public static Git clone(File repoDest, String origin, boolean isMirror, List<String> branches, CredentialsProvider credential, KetchLeaderCache leaders, File hookDir, boolean sslVerify) {
        return new Clone(repoDest, origin, isMirror, branches, credential, leaders, hookDir, sslVerify).execute().get();
    }

    public static Git cloneSubdirectory(File repoDest, String origin, String subdirectory, List<String> branches, CredentialsProvider credential, KetchLeaderCache leaders, File hookDir) {
        return new SubdirectoryClone(repoDest, origin, subdirectory, branches, credential, leaders, hookDir, JGitFileSystemProviderConfiguration.DEFAULT_GIT_HTTP_SSL_VERIFY).execute();
    }

    public static Git cloneSubdirectory(File repoDest, String origin, String subdirectory, List<String> branches, CredentialsProvider credential, KetchLeaderCache leaders, File hookDir, boolean sslVerify) {
        return new SubdirectoryClone(repoDest, origin, subdirectory, branches, credential, leaders, hookDir, sslVerify).execute();
    }

    public void convertRefTree();

    public void deleteRef(Ref var1);

    public Ref getRef(String var1);

    public void push(CredentialsProvider var1, Pair<String, String> var2, boolean var3, Collection<RefSpec> var4) throws InvalidRemoteException;

    public void gc();

    public RevCommit getCommit(String var1);

    public RevCommit getLastCommit(String var1);

    public RevCommit getLastCommit(Ref var1) throws IOException;

    public RevCommit getCommonAncestorCommit(String var1, String var2);

    public CommitHistory listCommits(Ref var1, String var2) throws IOException, GitAPIException;

    public List<RevCommit> listCommits(String var1, String var2);

    public List<RevCommit> listCommits(ObjectId var1, ObjectId var2);

    public Repository getRepository();

    public ObjectId getTreeFromRef(String var1);

    public void fetch(CredentialsProvider var1, Pair<String, String> var2, Collection<RefSpec> var3) throws InvalidRemoteException;

    public void syncRemote(Pair<String, String> var1) throws InvalidRemoteException;

    public List<String> merge(String var1, String var2);

    public List<String> merge(String var1, String var2, boolean var3);

    public boolean revertMerge(String var1, String var2, String var3, String var4);

    public void cherryPick(JGitPathImpl var1, String ... var2);

    public void cherryPick(String var1, String ... var2);

    public void createRef(String var1, String var2);

    public List<FileDiff> diffRefs(String var1, String var2);

    public List<TextualDiff> textualDiffRefs(String var1, String var2);

    public List<TextualDiff> textualDiffRefs(String var1, String var2, String var3, String var4);

    public List<String> conflictBranchesChecker(String var1, String var2);

    public void squash(String var1, String var2, String var3);

    public boolean commit(String var1, CommitInfo var2, boolean var3, ObjectId var4, CommitContent var5);

    public List<DiffEntry> listDiffs(String var1, String var2);

    public List<DiffEntry> listDiffs(ObjectId var1, ObjectId var2);

    public Map<String, File> mapDiffContent(String var1, String var2, String var3);

    public InputStream blobAsInputStream(String var1, String var2);

    public RevCommit getFirstCommit(Ref var1) throws IOException;

    public List<Ref> listRefs();

    public List<ObjectId> resolveObjectIds(String ... var1);

    public RevCommit resolveRevCommit(ObjectId var1) throws IOException;

    public List<RefSpec> updateRemoteConfig(Pair<String, String> var1, Collection<RefSpec> var2) throws IOException, URISyntaxException;

    public PathInfo getPathInfo(String var1, String var2);

    public List<PathInfo> listPathContent(String var1, String var2);

    public boolean isHEADInitialized();

    public void setHeadAsInitialized();

    public void refUpdate(String var1, RevCommit var2) throws IOException, ConcurrentRefUpdateException;

    public KetchLeader getKetchLeader();

    public boolean isKetchEnabled();

    public void enableKetch();

    public void updateRepo(Repository var1);

    public void updateLeaders(KetchLeaderCache var1);
}

