/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties;

import org.assertj.core.api.Assertions;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.SubProcess;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.MultipleInstanceSubProcessPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;

public class MultipleInstanceSubProcessPropertyWriterTest {
    private MultipleInstanceSubProcessPropertyWriter tested = new MultipleInstanceSubProcessPropertyWriter(Factories.bpmn2.createSubProcess(), (VariableScope)new FlatVariableScope());

    @Test
    public void nullInputOutputsShouldNotThrow() {
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        MultipleInstanceSubProcessPropertyWriter p = new MultipleInstanceSubProcessPropertyWriter(subProcess, (VariableScope)new FlatVariableScope());
        Assertions.assertThatCode(() -> {
            p.setInput(null);
            p.setOutput(null);
            MultipleInstanceSubProcessPropertyWriter.createDataInput(null, null);
            MultipleInstanceSubProcessPropertyWriter.createDataOutput(null, null);
            p.setCompletionCondition(null);
        }).doesNotThrowAnyException();
    }

    @Test
    public void completionConditionMustBeWrappedInCdata() {
        String expression = "x<1";
        String expected = "<![CDATA[" + expression + "]]>";
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        MultipleInstanceSubProcessPropertyWriter p = new MultipleInstanceSubProcessPropertyWriter(subProcess, (VariableScope)new FlatVariableScope());
        p.setCompletionCondition(expression);
        MultiInstanceLoopCharacteristics loopCharacteristics = (MultiInstanceLoopCharacteristics)subProcess.getLoopCharacteristics();
        FormalExpression completionCondition = (FormalExpression)loopCharacteristics.getCompletionCondition();
        Assertions.assertThat((String)expected).isEqualTo((Object)completionCondition.getBody());
    }

    @Test
    public void testSetIsAsync() {
        this.tested.setAsync(Boolean.TRUE);
        Assert.assertTrue((boolean)((Boolean)CustomElement.async.of((BaseElement)this.tested.getFlowElement()).get()));
    }

    @Test
    public void testSetSlaDueDate() {
        String slaDueDate = "12/25/1983";
        this.tested.setSlaDueDate(new SLADueDate(slaDueDate));
        Assert.assertTrue((boolean)((String)CustomElement.slaDueDate.of((BaseElement)this.tested.getFlowElement()).get()).contains(slaDueDate));
    }
}

