/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Bpmn2Factory;
import org.eclipse.bpmn2.DataObject;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Lane;
import org.eclipse.bpmn2.LaneSet;
import org.eclipse.bpmn2.ManualTask;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.Task;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNEdge;
import org.eclipse.bpmn2.di.BPMNPlane;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.impl.LaneImpl;
import org.eclipse.dd.dc.Bounds;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.stunner.bpmn.BPMNDefinitionSet;
import org.kie.workbench.common.stunner.bpmn.BPMNTestDefinitionFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.ConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.processes.ProcessConverterDelegate;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BasePropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.core.backend.StunnerTestingGraphBackendAPI;
import org.kie.workbench.common.stunner.core.factory.definition.TypeDefinitionFactory;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.marshaller.MarshallingMessage;
import org.kie.workbench.common.stunner.core.validation.Violation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ProcessConverterDelegateTest {
    @Mock
    private PropertyReaderFactory propertyReaderFactory;
    private DefinitionResolver definitionResolver;
    private BaseConverterFactory factory;
    @Mock
    private BasePropertyReader basePropertyReader;
    @Mock
    private Process process;
    @Mock
    private BPMNDiagram diagram;
    @Mock
    private BPMNPlane plane;
    private BpmnNode parentNode;
    private ProcessConverterDelegate converterDelegate;
    @Mock
    private Definitions definitions;

    @Before
    public void setUp() throws Exception {
        this.parentNode = new BpmnNode.Simple((Node)new NodeImpl("ParentNode"), this.basePropertyReader);
        Mockito.when((Object)this.diagram.getPlane()).thenReturn((Object)this.plane);
        List<Process> rootElements = Collections.singletonList(this.process);
        List<BPMNDiagram> diagrams = Collections.singletonList(this.diagram);
        Mockito.when((Object)this.definitions.getRootElements()).thenReturn(rootElements);
        Mockito.when((Object)this.definitions.getDiagrams()).thenReturn(diagrams);
        Mockito.when((Object)this.definitions.getRelationships()).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.plane.getPlaneElement()).thenReturn(new ArrayList());
        this.definitionResolver = new DefinitionResolver(this.definitions, Collections.emptyList());
        StunnerTestingGraphBackendAPI api = StunnerTestingGraphBackendAPI.build(BPMNDefinitionSet.class, (TypeDefinitionFactory)new BPMNTestDefinitionFactory());
        TypedFactoryManager typedFactoryManager = new TypedFactoryManager(api.getFactoryManager());
        this.factory = new ConverterFactory(this.definitionResolver, typedFactoryManager);
        this.converterDelegate = new ProcessConverterDelegate(typedFactoryManager, this.propertyReaderFactory, this.definitionResolver, this.factory);
    }

    @Test
    public void testConvertEdges() {
        Task task1 = ProcessConverterDelegateTest.mockTask("1");
        Task task2 = ProcessConverterDelegateTest.mockTask("2");
        BpmnNode.Simple task1Node = this.mockTaskNode(task1);
        BpmnNode.Simple task2Node = this.mockTaskNode(task2);
        SequenceFlow sequenceFlow = this.mockSequenceFlow("seq1", (FlowNode)task1, (FlowNode)task2);
        List<BaseElement> elements = Arrays.asList(sequenceFlow, task1, task2);
        Assert.assertFalse((boolean)((Boolean)this.converterDelegate.convertEdges(this.parentNode, elements, new HashMap()).value()));
        Map nodes = new Maps.Builder().put((Object)task1.getId(), (Object)task1Node).put((Object)task2.getId(), (Object)task2Node).build();
        Assert.assertTrue((boolean)((Boolean)this.converterDelegate.convertEdges(this.parentNode, elements, nodes).value()));
    }

    private BpmnNode.Simple mockTaskNode(Task task) {
        BPMNShape shape = (BPMNShape)Mockito.mock(BPMNShape.class);
        Mockito.when((Object)shape.getBounds()).thenReturn(Mockito.mock(Bounds.class));
        this.plane.getPlaneElement().add(shape);
        Mockito.when((Object)shape.getBpmnElement()).thenReturn((Object)task);
        return new BpmnNode.Simple((Node)new NodeImpl(task.getId()), this.basePropertyReader);
    }

    private SequenceFlow mockSequenceFlow(String id, FlowNode source, FlowNode target) {
        SequenceFlow sequenceFlow = Bpmn2Factory.eINSTANCE.createSequenceFlow();
        sequenceFlow.setSourceRef(source);
        sequenceFlow.setTargetRef(target);
        sequenceFlow.setId(id);
        BPMNEdge shape = (BPMNEdge)Mockito.mock(BPMNEdge.class);
        Mockito.when((Object)shape.getWaypoint()).thenReturn(Collections.emptyList());
        this.plane.getPlaneElement().add(shape);
        Mockito.when((Object)shape.getBpmnElement()).thenReturn((Object)sequenceFlow);
        return sequenceFlow;
    }

    @Test
    public void testConvertEdgesIgnoredNonEdgeElement() {
        HashMap nodes = new HashMap();
        List<BaseElement> elements = Arrays.asList(ProcessConverterDelegateTest.mockTask("1"));
        Assert.assertFalse((boolean)((Boolean)this.converterDelegate.convertEdges(this.parentNode, elements, nodes).value()));
    }

    @Test
    public void testConvertUnsupportedChildNodes() {
        List laneSets = Collections.emptyList();
        List<FlowElement> flowElements = Arrays.asList(ProcessConverterDelegateTest.mockTask("1"), ProcessConverterDelegateTest.mockTask("2"), ProcessConverterDelegateTest.mockUnsupportedTask("3"), ProcessConverterDelegateTest.mockUnsupportedDataObject("4"));
        Result result = this.converterDelegate.convertChildNodes(this.parentNode, flowElements, laneSets);
        List messages = result.messages();
        Assert.assertEquals((long)2L, (long)messages.size());
        Assert.assertTrue((boolean)messages.stream().map(MarshallingMessage::getViolationType).allMatch(arg_0 -> Violation.Type.WARNING.equals(arg_0)));
    }

    @Test
    public void testConvertLanes() {
        Task task0_1 = ProcessConverterDelegateTest.mockTask("TASK0_1");
        Task task0_2 = ProcessConverterDelegateTest.mockTask("TASK0_2");
        Task task0_3 = ProcessConverterDelegateTest.mockTask("TASK0_3");
        Task task1_1 = ProcessConverterDelegateTest.mockTask("TASK1_1");
        Lane lane1 = ProcessConverterDelegateTest.mockLane("Lane1", "Lane1Name", new FlowNode[]{task1_1});
        Task task2_1 = ProcessConverterDelegateTest.mockTask("TASK2_1");
        Lane lane2 = ProcessConverterDelegateTest.mockLane("Lane2", "Lane2Name", new FlowNode[]{task2_1});
        LaneSet laneSet1 = ProcessConverterDelegateTest.mockLaneSet("LaneSet1", lane1, lane2);
        Task task3_2_1 = ProcessConverterDelegateTest.mockTask("TASK3_2_1");
        Task task3_2_2 = ProcessConverterDelegateTest.mockTask("TASK3_2_2");
        Lane lane3_2 = ProcessConverterDelegateTest.mockLane("Lane3_2", "Lane3_2Name", new FlowNode[]{task3_2_1, task3_2_2});
        Task task3_1_2_1 = ProcessConverterDelegateTest.mockTask("TASK3_1_2_1");
        Lane lane3_1_2 = ProcessConverterDelegateTest.mockLane("Lane3_1_2", "Lane3_1_2Name", new FlowNode[]{task3_1_2_1});
        Task task3_1_1_1_1 = ProcessConverterDelegateTest.mockTask("task3_1_1_1_1");
        Lane lane3_1_1_1 = ProcessConverterDelegateTest.mockLane("Lane3_1_1_1", "lane3_1_1_1Name", new FlowNode[]{task3_1_1_1_1});
        Task task3_1_1_2_1 = ProcessConverterDelegateTest.mockTask("task3_1_1_2_1");
        Lane lane3_1_1_2 = ProcessConverterDelegateTest.mockLane("Lane3_1_1_2", "lane3_1_1_2Name", new FlowNode[]{task3_1_1_2_1});
        Lane lane3_1_1 = ProcessConverterDelegateTest.mockLane("Lane3_1_1", "Lane3_1_1Name", ProcessConverterDelegateTest.mockLaneSet("laneSet3_1_1", lane3_1_1_1, lane3_1_1_2));
        Lane lane3_1 = ProcessConverterDelegateTest.mockLane("Lane3_1", "Lane3_1Name", ProcessConverterDelegateTest.mockLaneSet("laneSet3_1", lane3_1_1, lane3_1_2));
        Lane lane3 = ProcessConverterDelegateTest.mockLane("Lane3", "Lane3Name", ProcessConverterDelegateTest.mockLaneSet("LaneSet3", lane3_1, lane3_2));
        LaneSet laneSet2 = ProcessConverterDelegateTest.mockLaneSet("LaneSet2", lane3);
        List<FlowElement> flowElements = Arrays.asList(task0_1, task0_2, task0_3, task1_1, task2_1, task3_1_1_1_1, task3_1_1_2_1, task3_1_2_1, task3_2_1, task3_2_2);
        List<LaneSet> laneSets = Arrays.asList(laneSet1, laneSet2);
        Result result = this.converterDelegate.convertChildNodes(this.parentNode, flowElements, laneSets);
        Map nodes = (Map)result.value();
        Assert.assertEquals((long)16L, (long)nodes.size());
        Assert.assertEquals((long)9L, (long)this.parentNode.getChildren().size());
        ProcessConverterDelegateTest.assertHasChildren(this.parentNode, task0_1.getId(), task0_2.getId(), task0_3.getId(), lane1.getId(), lane2.getId(), lane3_2.getId(), lane3_1_2.getId(), lane3_1_1_1.getId(), lane3_1_1_2.getId());
        BpmnNode lane1Node = ProcessConverterDelegateTest.getChildById(this.parentNode, lane1.getId());
        Assert.assertNotNull((Object)lane1Node);
        ProcessConverterDelegateTest.assertHasChildren(lane1Node, task1_1.getId());
        BpmnNode lane2Node = ProcessConverterDelegateTest.getChildById(this.parentNode, lane2.getId());
        Assert.assertNotNull((Object)lane2Node);
        ProcessConverterDelegateTest.assertHasChildren(lane2Node, task2_1.getId());
        BpmnNode lane3_1_1_1Node = ProcessConverterDelegateTest.getChildById(this.parentNode, lane3_1_1_1.getId());
        Assert.assertNotNull((Object)lane3_1_1_1Node);
        ProcessConverterDelegateTest.assertHasChildren(lane3_1_1_1Node, task3_1_1_1_1.getId());
        BpmnNode lane3_1_1_2Node = ProcessConverterDelegateTest.getChildById(this.parentNode, lane3_1_1_2.getId());
        Assert.assertNotNull((Object)lane3_1_1_2Node);
        ProcessConverterDelegateTest.assertHasChildren(lane3_1_1_2Node, task3_1_1_2_1.getId());
        BpmnNode lane3_1_2Node = ProcessConverterDelegateTest.getChildById(this.parentNode, lane3_1_2.getId());
        Assert.assertNotNull((Object)lane3_1_2Node);
        ProcessConverterDelegateTest.assertHasChildren(lane3_1_2Node, task3_1_2_1.getId());
        BpmnNode lane3_2Node = ProcessConverterDelegateTest.getChildById(this.parentNode, lane3_2.getId());
        ProcessConverterDelegateTest.assertHasChildren(lane3_2Node, new String[0]);
        ProcessConverterDelegateTest.assertHasChildren(lane3_2Node, task3_2_1.getId(), task3_2_2.getId());
        List messages = result.messages();
        Assert.assertEquals((long)4L, (long)messages.size());
        Assert.assertTrue((boolean)messages.stream().map(MarshallingMessage::getMessageKey).allMatch("MarshallingMessage.childLaneSetConverted"::equals));
    }

    private static void assertHasChildren(BpmnNode bpmnNode, String ... nodeIds) {
        Arrays.stream(nodeIds).forEach(nodeId -> Assert.assertTrue((boolean)bpmnNode.getChildren().stream().anyMatch(child -> Objects.equals(child.value().getUUID(), nodeId))));
    }

    private static BpmnNode getChildById(BpmnNode bpmnNode, String nodeId) {
        return bpmnNode.getChildren().stream().filter(child -> Objects.equals(child.value().getUUID(), nodeId)).findFirst().orElse(null);
    }

    private static Task mockTask(String id) {
        Task task = Bpmn2Factory.eINSTANCE.createTask();
        task.setId(id);
        return task;
    }

    private static Task mockUnsupportedTask(String id) {
        ManualTask task = Bpmn2Factory.eINSTANCE.createManualTask();
        task.setId(id);
        return task;
    }

    private static DataObject mockUnsupportedDataObject(String id) {
        DataObject element = Bpmn2Factory.eINSTANCE.createDataObject();
        element.setId(id);
        return element;
    }

    private static LaneSet mockLaneSet(String name, Lane ... children) {
        LaneSet laneSet = (LaneSet)Mockito.mock(LaneSet.class);
        laneSet.setName(name);
        Mockito.when((Object)laneSet.getName()).thenReturn((Object)name);
        Mockito.when((Object)laneSet.getLanes()).thenReturn(Arrays.asList(children));
        return laneSet;
    }

    private static Lane mockLane(String id, String name, FlowNode ... children) {
        LaneMock lane = new LaneMock(Arrays.asList(children));
        lane.setId(id);
        lane.setName(name);
        return lane;
    }

    private static Lane mockLane(String id, String name, LaneSet childLineSet) {
        LaneMock lane = new LaneMock(childLineSet);
        lane.setId(id);
        lane.setName(name);
        return lane;
    }

    private static class LaneMock
    extends LaneImpl {
        List<FlowNode> children;
        LaneSet childLineSet;

        LaneMock(List<FlowNode> children) {
            this.children = children;
        }

        LaneMock(LaneSet childLineSet) {
            this.childLineSet = childLineSet;
        }

        public List<FlowNode> getFlowNodeRefs() {
            return this.children;
        }

        public LaneSet getChildLaneSet() {
            return this.childLineSet;
        }
    }
}

