/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.List;
import org.eclipse.bpmn2.Assignment;
import org.eclipse.bpmn2.DataInput;
import org.eclipse.bpmn2.DataInputAssociation;
import org.eclipse.bpmn2.DataOutput;
import org.eclipse.bpmn2.DataOutputAssociation;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.impl.PropertyImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.InitializedVariable;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.ParsedAssignmentsInfo;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.FlatVariableScope;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.VariableScope;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.AssignmentsInfo;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ParsedAssignmentsInfoTest {
    private static final String ASSIGNMENTS_INFO = "Years of Service:Integer||Data Test:Boolean||[din]Years of Service=35,[dout]Data Test->BooleanTest";
    private ParsedAssignmentsInfo tested;

    @Before
    public void setup() {
        AssignmentsInfo assignmentsInfos = new AssignmentsInfo(ASSIGNMENTS_INFO);
        this.tested = ParsedAssignmentsInfo.of((AssignmentsInfo)assignmentsInfos);
    }

    @Test
    public void testCreateInitializedInputVariables() {
        String DATA_INPUT_ID = "_Years-of-ServiceInputX";
        String DATA_INPUT_NAME = "Years of Service";
        String DATA_INPUT_ASSOCIATION_ID = "Years of Service";
        String DATA_INPUT_ASSOCIATION_VALUE = "<![CDATA[35]]>";
        String INIT_INPUT_VAR_ID = "Years-of-Service";
        String INIT_INPUT_VAR_TYPE = "Integer";
        FlatVariableScope variableScope = new FlatVariableScope();
        List initializedInputVariables = this.tested.createInitializedInputVariables("", (VariableScope)variableScope);
        Assert.assertEquals((long)initializedInputVariables.size(), (long)1L);
        InitializedVariable.InitializedInputVariable initializedInputVariable = (InitializedVariable.InitializedInputVariable)initializedInputVariables.get(0);
        DataInput dataInput = initializedInputVariable.getDataInput();
        DataInputAssociation dataInputAssociation = initializedInputVariable.getDataInputAssociation();
        DataInput target = (DataInput)dataInputAssociation.getTargetRef();
        List assignments = dataInputAssociation.getAssignment();
        Assignment assignment = (Assignment)assignments.get(0);
        FormalExpression from = (FormalExpression)assignment.getFrom();
        String dataInputID = dataInput.getId();
        String dataInputName = dataInput.getName();
        String dataInputAssociationID = target.getName();
        String dataInputAssociationValue = from.getBody();
        String initVarID = initializedInputVariable.getIdentifier();
        String initVarType = initializedInputVariable.getType();
        Assert.assertEquals((Object)dataInputID, (Object)"_Years-of-ServiceInputX");
        Assert.assertEquals((Object)dataInputName, (Object)"Years of Service");
        Assert.assertEquals((Object)dataInputAssociationID, (Object)"Years of Service");
        Assert.assertEquals((Object)dataInputAssociationValue, (Object)"<![CDATA[35]]>");
        Assert.assertEquals((Object)initVarID, (Object)"Years-of-Service");
        Assert.assertEquals((Object)initVarType, (Object)"Integer");
    }

    @Test
    public void testCreateInitializedOutputVariables() {
        String DATA_OUTPUT_ID = "_Data-TestOutputX";
        String DATA_OUTPUT_NAME = "Data Test";
        String DATA_OUTPUT_ASSOCIATION_ID = "Data Test";
        String DATA_OUTPUT_ASSOCIATION_VALUE = "BooleanTest";
        String INIT_OUTPUT_VAR_ID = "Data-Test";
        String INIT_OUTPUT_VAR_TYPE = "Boolean";
        FlatVariableScope variableScope = new FlatVariableScope();
        variableScope.declare("", "BooleanTest", "Boolean");
        List initializedOutputVariables = this.tested.createInitializedOutputVariables("", (VariableScope)variableScope);
        Assert.assertEquals((long)1L, (long)initializedOutputVariables.size());
        InitializedVariable.InitializedOutputVariable initializedOutputVariable = (InitializedVariable.InitializedOutputVariable)initializedOutputVariables.get(0);
        DataOutput dataOuput = initializedOutputVariable.getDataOutput();
        DataOutputAssociation dataOutputAssociation = initializedOutputVariable.getDataOutputAssociation();
        List sourceRef = dataOutputAssociation.getSourceRef();
        DataOutput source = (DataOutput)sourceRef.get(0);
        PropertyImpl target = (PropertyImpl)dataOutputAssociation.getTargetRef();
        String dataOuputID = dataOuput.getId();
        String dataOutputName = dataOuput.getName();
        String dataOutputAssociationID = source.getName();
        String dataOutputAssocationValue = target.getId();
        String initVarID = initializedOutputVariable.getIdentifier();
        String initVarType = initializedOutputVariable.getType();
        Assert.assertEquals((Object)dataOuputID, (Object)"_Data-TestOutputX");
        Assert.assertEquals((Object)dataOutputName, (Object)"Data Test");
        Assert.assertEquals((Object)dataOutputAssociationID, (Object)"Data Test");
        Assert.assertEquals((Object)dataOutputAssocationValue, (Object)"BooleanTest");
        Assert.assertEquals((Object)initVarID, (Object)"Data-Test");
        Assert.assertEquals((Object)initVarType, (Object)"Boolean");
    }

    @Test
    public void fromString() {
        String original = "|input1:String,input2:String||output1:String,output2:String|[din]pv1->input1,[din]pv2->input2,[dout]output1->pv2,[dout]output2->pv2";
        this.assertParseUnparse(original);
    }

    @Test
    public void fromString2() {
        String original = "||IntermediateMessageEventCatchingOutputVar1:String||[dout]IntermediateMessageEventCatchingOutputVar1->var1";
        this.assertParseUnparse(original);
    }

    private void assertParseUnparse(String original) {
        ParsedAssignmentsInfo assignmentsInfo = ParsedAssignmentsInfo.fromString((String)original);
        String s1 = assignmentsInfo.toString();
        String s2 = ParsedAssignmentsInfo.fromString((String)s1).toString();
        Assert.assertEquals((Object)original, (Object)s2);
    }
}

