/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.intermediate.BoundaryCatchingIntermediateEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.IntermediateSignalEventCatching;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.BaseCancellingEventExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.signal.CancellingSignalEventExecutionSet;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class BoundaryCatchingIntermediateSignalEventTest
extends BoundaryCatchingIntermediateEventTest<IntermediateSignalEventCatching> {
    private static final String BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/boundarySignalEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_53B585C7-7515-4842-9312-29C830D8FE8C";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_7DA9CD2F-8A42-41FA-AB34-4FBD0688E095";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_E852903C-50C5-4969-9C55-DE998FA5300B";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_0541428C-F510-4AC3-AC4A-27DBAC940406";
    private static final String EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_B6249505-965A-4F69-9C15-154D12C0CF3D";
    private static final String FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID = "_2DFEFD1C-3E0D-4BCB-A250-C7BDAB741B55";
    private static final String EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_4F8B8564-5EA5-494D-9E86-3154F1C0D7C8";
    private static final String FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID = "_73B535D0-C805-4F76-B00E-22D6DEE29C8F";
    private static final String SLA_DUE_DATE = "12/25/1983";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 31;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary signal01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "signal01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "signal01";
        String EVENT_DATA_OUTPUT = "||signal01:String||[dout]signal01->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 31);
        IntermediateSignalEventCatching filledTopEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "Boundary signal01 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledTopEvent.getExecutionSet(), "signal01", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopEvent.getDataIOSet(), "||signal01:String||[dout]signal01->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 31);
        IntermediateSignalEventCatching emptyTopEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
        this.assertSignalEventExecutionSet(emptyTopEvent.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptyTopEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Boundary signal03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "signal03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "signal03";
        String EVENT_DATA_OUTPUT = "||signal03:String||[dout]signal03->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 31);
        IntermediateSignalEventCatching filledSubprocessEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Boundary signal03 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "signal03", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||signal03:String||[dout]signal03->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 31);
        IntermediateSignalEventCatching emptySubprocessEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false, 0);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertSignalEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "Boundary signal02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "signal02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "signal02";
        String EVENT_DATA_OUTPUT = "||signal02:String||[dout]signal02->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 31);
        IntermediateSignalEventCatching filledSubprocessEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID, false, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Boundary signal02 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "signal02", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||signal02:String||[dout]signal02->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 31);
        IntermediateSignalEventCatching emptyEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID, false, 2);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
        this.assertSignalEventExecutionSet(emptyEvent.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptyEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesEmptyProperties() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 31);
        IntermediateSignalEventCatching emptySubprocessEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, false, 2);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
        this.assertSignalEventExecutionSet(emptySubprocessEvent.getExecutionSet(), "", false, "");
        this.assertDataIOSet(emptySubprocessEvent.getDataIOSet(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithEdgesFilledProperties() {
        String EVENT_NAME = "Boundary signal04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "signal04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "signal04";
        String EVENT_DATA_OUTPUT = "||signal04:String||[dout]signal04->processGlobalVar";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 31);
        IntermediateSignalEventCatching filledSubprocessEvent = (IntermediateSignalEventCatching)this.getCatchingIntermediateNodeById(diagram, FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID, false, 2);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Boundary signal04 ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "signal04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertSignalEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "signal04", true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "||signal04:String||[dout]signal04->processGlobalVar");
    }

    @Override
    String getBpmnCatchingIntermediateEventFilePath() {
        return BPMN_CATCHING_INTERMEDIATE_EVENT_FILE_PATH;
    }

    @Override
    Class<IntermediateSignalEventCatching> getCatchingIntermediateEventType() {
        return IntermediateSignalEventCatching.class;
    }

    @Override
    String[] getFilledTopLevelEventIds() {
        return new String[]{FILLED_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventIds() {
        return new String[]{FILLED_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledTopLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_TOP_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptyTopLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String[] getFilledSubprocessLevelEventWithEdgesIds() {
        return new String[]{FILLED_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID};
    }

    @Override
    String getEmptySubprocessLevelEventWithEdgesId() {
        return EMPTY_WITH_EDGES_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertSignalEventExecutionSet(CancellingSignalEventExecutionSet executionSet, String eventName, boolean isCancelling, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getSignalRef()).isNotNull();
        Assertions.assertThat((String)executionSet.getSignalRef().getValue()).isEqualTo((Object)eventName);
        this.assertEventCancelActivity((BaseCancellingEventExecutionSet)executionSet, isCancelling);
        this.assertEventSlaDueDate((BaseCancellingEventExecutionSet)executionSet, slaDueDate);
    }
}

