/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.nodes;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.BPMNDiagramMarshallerBaseTest;
import org.kie.workbench.common.stunner.bpmn.definition.BaseGateway;
import org.kie.workbench.common.stunner.bpmn.definition.property.gateway.DefaultRoute;
import org.kie.workbench.common.stunner.bpmn.definition.property.gateway.GatewayExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

public abstract class GatewayNodeTest<T extends BaseGateway>
extends BPMNDiagramMarshallerBaseTest {
    protected final int DIAGRAM_NODE_SIZE = 10;

    @Test
    public void testMarshallTopLevelGatewayFilledProperties() throws Exception {
        this.checkNodeMarshalling(this.getGatewayNodeType(), this.getFilledTopLevelGatewayId());
    }

    @Test
    public void testMarshallTopLevelEmptyGatewayProperties() throws Exception {
        this.checkNodeMarshalling(this.getGatewayNodeType(), this.getEmptyTopLevelGatewayId());
    }

    @Test
    public void testMarshallSubprocessLevelGatewayFilledProperties() throws Exception {
        this.checkNodeMarshalling(this.getGatewayNodeType(), this.getFilledSubprocessLevelGatewayId());
    }

    @Test
    public void testMarshallSubprocessLevelGatewayEmptyProperties() throws Exception {
        this.checkNodeMarshalling(this.getGatewayNodeType(), this.getEmptySubprocessLevelGatewayId());
    }

    abstract Class<T> getGatewayNodeType();

    abstract String getGatewayNodeFilePath();

    abstract String getFilledTopLevelGatewayId();

    abstract String getEmptyTopLevelGatewayId();

    abstract String getFilledSubprocessLevelGatewayId();

    abstract String getEmptySubprocessLevelGatewayId();

    private void assertNodesEqualsAfterMarshalling(Diagram<Graph, Metadata> before, Diagram<Graph, Metadata> after, String nodeId, Class<T> startType) {
        T nodeBeforeMarshalling = this.getGatewayNodeById(before, nodeId, startType);
        T nodeAfterMarshalling = this.getGatewayNodeById(after, nodeId, startType);
        Assertions.assertThat(nodeBeforeMarshalling).isEqualTo(nodeAfterMarshalling);
    }

    T getGatewayNodeById(Diagram<Graph, Metadata> diagram, String id, Class<T> type) {
        Node node = diagram.getGraph().getNode(id);
        Assertions.assertThat((Object)node).isNotNull();
        return (T)((BaseGateway)type.cast(((Definition)node.getContent()).getDefinition()));
    }

    void checkNodeMarshalling(Class gatewayNodeType, String nodeID) throws Exception {
        Diagram<Graph, Metadata> initialDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getGatewayNodeFilePath());
        int AMOUNT_OF_NODES_IN_DIAGRAM = this.getNodes(initialDiagram).size();
        String resultXml = this.marshaller.marshall(initialDiagram);
        Diagram<Graph, Metadata> marshalledDiagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getStream(resultXml));
        this.assertDiagram(marshalledDiagram, AMOUNT_OF_NODES_IN_DIAGRAM);
        this.assertNodesEqualsAfterMarshalling(initialDiagram, marshalledDiagram, nodeID, gatewayNodeType);
    }

    void assertGeneralSet(BPMNGeneralSet generalSet, String nodeName, String documentation) {
        Assertions.assertThat((Object)generalSet).isNotNull();
        Assertions.assertThat((Object)generalSet.getName()).isNotNull();
        Assertions.assertThat((Object)generalSet.getDocumentation()).isNotNull();
        Assertions.assertThat((String)generalSet.getName().getValue()).isEqualTo((Object)nodeName);
        Assertions.assertThat((String)generalSet.getDocumentation().getValue()).isEqualTo((Object)documentation);
    }

    void assertGatewayExecutionSet(GatewayExecutionSet gatewayExecutionSet, String value) {
        Assertions.assertThat((Object)gatewayExecutionSet).isNotNull();
        DefaultRoute defaultRoute = gatewayExecutionSet.getDefaultRoute();
        Assertions.assertThat((Object)defaultRoute).isNotNull();
        Assertions.assertThat((String)defaultRoute.getValue()).isEqualTo((Object)value);
    }
}

