/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks;

import org.junit.Ignore;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks.BaseServiceTaskTest;
import org.kie.workbench.common.stunner.bpmn.workitem.ServiceTask;

public class WebServiceTaskTest
extends BaseServiceTaskTest<ServiceTask> {
    private static final String BPMN_TASK_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/webServiceTasks.bpmn";
    private static final String EMPTY_TOP_LEVEL_TASK_ID = "_5A6F1F2B-0DA7-4CC9-A0DC-3E084C1CC04B";
    private static final String FILLED_TOP_LEVEL_TASK_JAVA_ID = "_A1F87E6F-4661-40A0-82FD-40EFA8B4EB0D";
    private static final String FILLED_TOP_LEVEL_TASK_JAVASCRIPT_ID = "_CECED7C4-5723-4A2A-87ED-C335149B2B09";
    private static final String FILLED_TOP_LEVEL_TASK_MVEL_ID = "_88C979F8-BA89-45C5-B537-E0A69354C77D";
    private static final String EMPTY_SUBPROCESS_LEVEL_TASK_ID = "_5D642034-18F7-4923-B5A5-522E7DA239A6";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_JAVA_ID = "_35A8D726-E7BD-4C1C-BE59-F4798BFE7D41";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID = "_597F6FAF-BE24-4D85-AF01-B97B98404A03";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_MVEL_ID = "_68B36482-F5F7-401D-A3A1-A9F396F5BB65";
    private static final String EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID = "_B31AD4AA-05F4-4FFC-931D-3D2B08FC5BD2";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVA_ID = "_52DDB629-4972-4322-857A-FC3784F063C9";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID = "_C79B91B0-0EC1-47B4-B4C6-0EBECFE86BFE";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_MVEL_ID = "_C6C31E27-BC23-4F39-B842-1BB7E46A732B";
    private static final String EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID = "_3DAE301C-D97B-46FA-819B-D977C9C4E40D";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVA_ID = "_93B7896F-D263-46D8-BC54-9E117FB426C3";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVASCRIPT_ID = "_B413F625-D2B0-4243-88F1-15C275695752";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_MVEL_ID = "_EBAEE436-8140-4E58-8C74-D31EE2225D9E";
    private static final String EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID = "_CED3E374-DC2F-49C3-9793-66E6DD305CFF";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVA_ID = "_C9E2A420-7C21-4E30-BE2A-36583F0A0C07";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID = "_098C8C0E-A580-4CA6-B4C0-604E934BD2A8";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_MVEL_ID = "_914BF590-F197-4294-86BF-9978E2FF1AED";
    private static final String EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID = "_34A5EEA0-7164-4DF3-B321-5651606EFF70";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVA_ID = "_48F6449C-CF57-4BE7-9778-32BABF22228B";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVASCRIPT_ID = "_32F3054C-C641-409A-8EA4-2857801DAE7A";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_MVEL_ID = "_43B109C6-A65C-40DF-97DF-33723FC77B3B";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 69;
    private static final String EMPTY_TASK_DATA_INPUT_OUTPUT = "||||";
    private static final String TASK_SCRIPT_JAVA_LANGUAGE = "java";
    private static final String TASK_SCRIPT_JAVASCRIPT_LANGUAGE = "javascript";
    private static final String TASK_SCRIPT_MVEL_LANGUAGE = "mvel";
    private static final boolean IS_ASYNC = true;
    private static final boolean IS_NOT_ASYNC = false;
    private static final boolean AD_HOC_AUTOSTART = true;
    private static final boolean NOT_AD_HOC_AUTOSTART = false;

    @Override
    @Test
    public void testUnmarshallTopLevelTaskFilledProperties() {
        String TASK_NAME_JAVA = "WebService task01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "WebService task01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action from WebService Task.\");";
        String TASK_NAME_JAVASCRIPT = "WebService task04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "WebService task04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action from WebService Task.\");";
        String TASK_NAME_MVEL = "WebService task07 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "WebService task07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action from WebService Task.\");";
        String TASK_DATA_INPUT_OUTPUT = "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        this.assertDiagram(this.getDiagram(), 69);
        ServiceTask filledTopLevelTaskJava = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_JAVA_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTaskJava.getGeneral(), "WebService task01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledTopLevelTaskJava.getExecutionSet(), "System.out.println(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledTopLevelTaskJava.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ServiceTask filledTopLevelTaskJavascript = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTaskJavascript.getGeneral(), "WebService task04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledTopLevelTaskJavascript.getExecutionSet(), "console.log(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledTopLevelTaskJavascript.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ServiceTask filledTopLevelTaskMvel = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_MVEL_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTaskMvel.getGeneral(), "WebService task07 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledTopLevelTaskMvel.getExecutionSet(), "System.out.println(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledTopLevelTaskMvel.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Ignore(value="The test is ignored because there is a bug in new Marshaller.\nIt should be enabled after these issues will be resolved:\nhttps://issues.jboss.org/browse/JBPM-7072\nhttps://issues.jboss.org/browse/JBPM-7726")
    @Test
    public void testUnmarshallTopLevelEmptyTaskProperties() {
        this.assertDiagram(this.getDiagram(), 69);
        ServiceTask emptyTopLevelTask = (ServiceTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TOP_LEVEL_TASK_ID, 0, false);
        this.assertGeneralSet(emptyTopLevelTask.getGeneral(), "", "");
        this.assertServiceTaskExecutionSet(emptyTopLevelTask.getExecutionSet(), "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, "");
        this.assertDataIOSet(emptyTopLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskFilledProperties() {
        String TASK_NAME_JAVA = "WebService task10 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "WebService task10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action from WebService Task.\");";
        String TASK_NAME_JAVASCRIPT = "WebService task13 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "WebService task13 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action from WebService Task.\");";
        String TASK_NAME_MVEL = "WebService task16 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "WebService task16 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action from WebService Task.\");";
        String TASK_DATA_INPUT_OUTPUT = "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        this.assertDiagram(this.getDiagram(), 69);
        ServiceTask filledSubprocessLevelTaskJava = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_JAVA_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "WebService task10 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), "System.out.println(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledSubprocessLevelTaskJava.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ServiceTask filledSubprocessLevelTaskJavascript = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskJavascript.getGeneral(), "WebService task13 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task13 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledSubprocessLevelTaskJavascript.getExecutionSet(), "console.log(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledSubprocessLevelTaskJavascript.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ServiceTask filledSubprocessLevelTaskMvel = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_MVEL_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskMvel.getGeneral(), "WebService task16 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task16 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledSubprocessLevelTaskMvel.getExecutionSet(), "System.out.println(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledSubprocessLevelTaskMvel.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Ignore(value="The test is ignored because there is a bug in new Marshaller.\nIt should be enabled after these issues will be resolved:\nhttps://issues.jboss.org/browse/JBPM-7072\nhttps://issues.jboss.org/browse/JBPM-7726")
    @Test
    public void testUnmarshallSubprocessLevelTaskEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 69);
        ServiceTask emptySubprocessLevelTask = (ServiceTask)this.getTaskNodeById(this.getDiagram(), EMPTY_SUBPROCESS_LEVEL_TASK_ID, 0, false);
        this.assertGeneralSet(emptySubprocessLevelTask.getGeneral(), "", "");
        this.assertServiceTaskExecutionSet(emptySubprocessLevelTask.getExecutionSet(), "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, "");
        this.assertDataIOSet(emptySubprocessLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskOneIncomeFilledProperties() {
        String TASK_NAME_JAVA = "WebService task02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "WebService task02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action from WebService Task.\");";
        String TASK_NAME_JAVASCRIPT = "WebService task05 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "WebService task05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action from WebService Task.\");";
        String TASK_NAME_MVEL = "WebService task08 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "WebService task08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action from WebService Task.\");";
        String TASK_DATA_INPUT_OUTPUT = "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        this.assertDiagram(this.getDiagram(), 69);
        ServiceTask filledTopLevelTaskJava = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVA_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTaskJava.getGeneral(), "WebService task02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledTopLevelTaskJava.getExecutionSet(), "System.out.println(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledTopLevelTaskJava.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ServiceTask filledTopLevelTaskJavascript = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTaskJavascript.getGeneral(), "WebService task05 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledTopLevelTaskJavascript.getExecutionSet(), "console.log(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledTopLevelTaskJavascript.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ServiceTask filledTopLevelTaskMvel = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_MVEL_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTaskMvel.getGeneral(), "WebService task08 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledTopLevelTaskMvel.getExecutionSet(), "System.out.println(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledTopLevelTaskMvel.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Ignore(value="The test is ignored because there is a bug in new Marshaller.\nIt should be enabled after these issues will be resolved:\nhttps://issues.jboss.org/browse/JBPM-7072\nhttps://issues.jboss.org/browse/JBPM-7726")
    @Test
    public void testUnmarshallTopLevelTaskOneIncomeEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 69);
        ServiceTask emptyTopLevelTask = (ServiceTask)this.getTaskNodeById(this.getDiagram(), EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID, 1, true);
        this.assertGeneralSet(emptyTopLevelTask.getGeneral(), "", "");
        this.assertServiceTaskExecutionSet(emptyTopLevelTask.getExecutionSet(), "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, "");
        this.assertDataIOSet(emptyTopLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Ignore(value="The test is ignored because there is a bug in new Marshaller.\nIt should be enabled after these issues will be resolved:\nhttps://issues.jboss.org/browse/JBPM-7072\nhttps://issues.jboss.org/browse/JBPM-7726")
    @Test
    public void testUnmarshallSubprocessLevelTaskOneIncomeEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 69);
        ServiceTask emptySubprocessLevelTask = (ServiceTask)this.getTaskNodeById(this.getDiagram(), EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID, 1, true);
        this.assertGeneralSet(emptySubprocessLevelTask.getGeneral(), "", "");
        this.assertServiceTaskExecutionSet(emptySubprocessLevelTask.getExecutionSet(), "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, "");
        this.assertDataIOSet(emptySubprocessLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskOneIncomeFilledProperties() {
        String TASK_NAME_JAVA = "WebService task11 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "WebService task11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action from WebService Task.\");";
        String TASK_NAME_JAVASCRIPT = "WebService task14 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "WebService task14 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action from WebService Task.\");";
        String TASK_NAME_MVEL = "WebService task17 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "WebService task17 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action from WebService Task.\");";
        String TASK_DATA_INPUT_OUTPUT = "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        this.assertDiagram(this.getDiagram(), 69);
        ServiceTask filledSubprocessLevelTaskJava = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVA_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "WebService task11 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), "System.out.println(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledSubprocessLevelTaskJava.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ServiceTask filledSubprocessLevelTaskJavascript = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJavascript.getGeneral(), "WebService task14 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task14 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledSubprocessLevelTaskJavascript.getExecutionSet(), "console.log(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledSubprocessLevelTaskJavascript.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ServiceTask filledSubprocessLevelTaskMvel = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_MVEL_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskMvel.getGeneral(), "WebService task17 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task17 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledSubprocessLevelTaskMvel.getExecutionSet(), "System.out.println(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledSubprocessLevelTaskMvel.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskTwoIncomesFilledProperties() {
        String TASK_NAME_JAVA = "WebService task03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "WebService task03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action from WebService Task.\");";
        String TASK_NAME_JAVASCRIPT = "WebService task06 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "WebService task06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action from WebService Task.\");";
        String TASK_NAME_MVEL = "WebService task09 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "WebService task09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action from WebService Task.\");";
        String TASK_DATA_INPUT_OUTPUT = "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        this.assertDiagram(this.getDiagram(), 69);
        ServiceTask filledTopLevelTaskJava = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVA_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTaskJava.getGeneral(), "WebService task03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledTopLevelTaskJava.getExecutionSet(), "System.out.println(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledTopLevelTaskJava.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ServiceTask filledTopLevelTaskJavascript = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTaskJavascript.getGeneral(), "WebService task06 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledTopLevelTaskJavascript.getExecutionSet(), "console.log(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledTopLevelTaskJavascript.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ServiceTask filledTopLevelTaskMvel = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_MVEL_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTaskMvel.getGeneral(), "WebService task09 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledTopLevelTaskMvel.getExecutionSet(), "System.out.println(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledTopLevelTaskMvel.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Ignore(value="The test is ignored because there is a bug in new Marshaller.\nIt should be enabled after these issues will be resolved:\nhttps://issues.jboss.org/browse/JBPM-7072\nhttps://issues.jboss.org/browse/JBPM-7726")
    @Test
    public void testUnmarshallTopLevelTaskTwoIncomesEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 69);
        ServiceTask emptyTopLevelTask = (ServiceTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID, 2, true);
        this.assertGeneralSet(emptyTopLevelTask.getGeneral(), "", "");
        this.assertServiceTaskExecutionSet(emptyTopLevelTask.getExecutionSet(), "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, "");
        this.assertDataIOSet(emptyTopLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Ignore(value="The test is ignored because there is a bug in new Marshaller.\nIt should be enabled after these issues will be resolved:\nhttps://issues.jboss.org/browse/JBPM-7072\nhttps://issues.jboss.org/browse/JBPM-7726")
    @Test
    public void testUnmarshallSubprocessLevelTaskTwoIncomesEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 69);
        ServiceTask emptySubprocessLevelTask = (ServiceTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID, 2, true);
        this.assertGeneralSet(emptySubprocessLevelTask.getGeneral(), "", "");
        this.assertServiceTaskExecutionSet(emptySubprocessLevelTask.getExecutionSet(), "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, "");
        this.assertDataIOSet(emptySubprocessLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskTwoIncomesFilledProperties() {
        String TASK_NAME_JAVA = "WebService task12 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "WebService task12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action from WebService Task.\");";
        String TASK_NAME_JAVASCRIPT = "WebService task15 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "WebService task15 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action from WebService Task.\");";
        String TASK_NAME_MVEL = "WebService task18 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "WebService task18 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action from WebService Task.\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action from WebService Task.\");";
        String TASK_DATA_INPUT_OUTPUT = "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        this.assertDiagram(this.getDiagram(), 69);
        ServiceTask filledSubprocessLevelTaskJava = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVA_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "WebService task12 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), "System.out.println(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledSubprocessLevelTaskJava.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ServiceTask filledSubprocessLevelTaskJavascript = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJavascript.getGeneral(), "WebService task15 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task15 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledSubprocessLevelTaskJavascript.getExecutionSet(), "console.log(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledSubprocessLevelTaskJavascript.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        ServiceTask filledSubprocessLevelTaskMvel = (ServiceTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_MVEL_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskMvel.getGeneral(), "WebService task18 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "WebService task18 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertServiceTaskExecutionSet(filledSubprocessLevelTaskMvel.getExecutionSet(), "System.out.println(\"On Entry Action from WebService Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action from WebService Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true, "12/25/1983");
        this.assertDataIOSet(filledSubprocessLevelTaskMvel.getDataIOSet(), "|Endpoint:String,Interface:String,Mode:String,Namespace:String,Operation:String,Parameter:String,Url:String,input:String||Result:java.lang.Object,output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testMarshallTopLevelTaskFilledProperties() {
        this.checkTaskMarshalling(FILLED_TOP_LEVEL_TASK_JAVA_ID, 0, false);
        this.checkTaskMarshalling(FILLED_TOP_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.checkTaskMarshalling(FILLED_TOP_LEVEL_TASK_MVEL_ID, 0, false);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelTaskFilledProperties() {
        this.checkTaskMarshalling(FILLED_SUBPROCESS_LEVEL_TASK_JAVA_ID, 0, false);
        this.checkTaskMarshalling(FILLED_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.checkTaskMarshalling(FILLED_SUBPROCESS_LEVEL_TASK_MVEL_ID, 0, false);
    }

    @Override
    @Test
    public void testMarshallTopLevelTaskOneIncomeFilledProperties() {
        this.checkTaskMarshalling(FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVA_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_TOP_LEVEL_TASK_MVEL_ID, 1, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelTaskOneIncomeFilledProperties() {
        this.checkTaskMarshalling(FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVA_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_MVEL_ID, 1, true);
    }

    @Override
    @Test
    public void testMarshallTopLevelTaskTwoIncomesFilledProperties() {
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVA_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_TOP_LEVEL_TASK_MVEL_ID, 2, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelTaskTwoIncomesFilledProperties() {
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVA_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_MVEL_ID, 2, true);
    }

    @Override
    String getBpmnTaskFilePath() {
        return BPMN_TASK_FILE_PATH;
    }

    @Override
    Class<ServiceTask> getTaskType() {
        return ServiceTask.class;
    }

    @Override
    String getFilledTopLevelTaskId() {
        return null;
    }

    @Override
    String getEmptyTopLevelTaskId() {
        return EMPTY_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelTaskId() {
        return EMPTY_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getFilledTopLevelTaskOneIncomeId() {
        return null;
    }

    @Override
    String getEmptyTopLevelTaskOneIncomeId() {
        return EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskOneIncomeId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelTaskOneIncomeId() {
        return EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getFilledTopLevelTaskTwoIncomesId() {
        return null;
    }

    @Override
    String getEmptyTopLevelTaskTwoIncomesId() {
        return EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskTwoIncomesId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelTaskTwoIncomesId() {
        return EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID;
    }
}

