/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.designer.repository.vfs;

import java.net.URI;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.jbpm.designer.repository.vfs.RepositoryDescriptor;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemNotFoundException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.spaces.Space;

@ApplicationScoped
public class RepositoryDescriptorProvider {
    @Inject
    @Named(value="ioStrategy")
    private IOService ioService;
    @Inject
    private RepositoryService repositoryService;
    private Map<String, RepositoryDescriptor> knownRepositories = new ConcurrentHashMap<String, RepositoryDescriptor>();

    @PostConstruct
    public void init() {
        Collection active = this.repositoryService.getAllRepositoriesFromAllUserSpaces();
        if (active != null) {
            for (Repository repo : active) {
                for (Branch branch : repo.getBranches()) {
                    this.buildAndRegister(repo, branch.getName());
                }
            }
        }
    }

    public RepositoryDescriptor getRepositoryDescriptor(Space space, String repositoryAlias, String branchName) {
        if (branchName == null) {
            branchName = "master";
        }
        if (this.knownRepositories.containsKey(branchName + "@" + space.getName() + "/" + repositoryAlias)) {
            return this.knownRepositories.get(branchName + "@" + space.getName() + "/" + repositoryAlias);
        }
        Repository repository = this.repositoryService.getRepositoryFromSpace(space, repositoryAlias);
        if (repository != null) {
            return this.buildAndRegister(repository, branchName);
        }
        throw new FileSystemNotFoundException("Repository with alias " + repositoryAlias + " not found in space " + space.getName());
    }

    private RepositoryDescriptor buildAndRegister(Repository repository, String branchName) {
        if (!repository.getDefaultBranch().isPresent()) {
            throw new IllegalStateException("Repository should have at least one branch.");
        }
        String repoUri = ((Branch)repository.getDefaultBranch().get()).getPath().toURI().replaceFirst("://.*?@", "://" + branchName + "@").replaceAll("\\s", "");
        URI root = URI.create(repoUri);
        FileSystem fs = this.ioService.getFileSystem(root);
        Path rootPath = fs.provider().getPath(root);
        RepositoryDescriptor descriptor = new RepositoryDescriptor(root, fs, rootPath);
        this.knownRepositories.put(branchName + "@" + repository.getSpace().getName() + "/" + repository.getAlias().replaceAll("\\s", ""), descriptor);
        return descriptor;
    }
}

