/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.impl;

import java.text.MessageFormat;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefinition;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.storage.impl.AbstractExperimentalFeaturesStorage;
import org.uberfire.io.IOService;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

@Dependent
@Named(value="user")
public class UserExperimentalFeaturesStorageImpl
extends AbstractExperimentalFeaturesStorage {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserExperimentalFeaturesStorageImpl.class);
    public static final String USER_FOLDER = "/experimental/users/{0}/.experimental";

    @Inject
    public UserExperimentalFeaturesStorageImpl(SessionInfo sessionInfo, SpacesAPI spaces, @Named(value="configIO") IOService ioService, ExperimentalFeatureDefRegistry defRegistry) {
        super(sessionInfo, spaces, ioService, defRegistry);
    }

    @PostConstruct
    public void init() {
        this.initializeFileSystem();
    }

    @Override
    protected Collection<ExperimentalFeatureDefinition> getSupportedDefinitions() {
        return this.defRegistry.getUserFeatures();
    }

    @Override
    public Collection<ExperimentalFeatureImpl> getFeatures() {
        return this.readFeatures();
    }

    @Override
    public String getStoragePath() {
        return MessageFormat.format(USER_FOLDER, this.sessionInfo.getIdentity().getIdentifier());
    }

    @Override
    protected Logger log() {
        return LOGGER;
    }
}

