/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.expression;

import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.backend.expression.BaseExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.DMNFeelExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.MVELExpressionEvaluator;

public class ExpressionEvaluatorFactory {
    private final ClassLoader classLoader;
    private final ScenarioSimulationModel.Type type;
    private BaseExpressionEvaluator baseExpressionEvaluator;
    private DMNFeelExpressionEvaluator dmnFeelExpressionEvaluator;
    private MVELExpressionEvaluator mvelExpressionEvaluator;

    public static ExpressionEvaluatorFactory create(ClassLoader classLoader, ScenarioSimulationModel.Type type) {
        return new ExpressionEvaluatorFactory(classLoader, type);
    }

    private ExpressionEvaluatorFactory(ClassLoader classLoader, ScenarioSimulationModel.Type type) {
        this.classLoader = classLoader;
        this.type = type;
    }

    public ExpressionEvaluator getOrCreate(FactMappingValue factMappingValue) {
        if (ScenarioSimulationModel.Type.DMN.equals((Object)this.type)) {
            return this.getOrCreateDMNExpressionEvaluator();
        }
        Object rawValue = factMappingValue.getRawValue();
        if (rawValue instanceof String && ((String)rawValue).trim().startsWith("#")) {
            return this.getOrCreateMVELExpressionEvaluator();
        }
        return this.getOrCreateBaseExpressionEvaluator();
    }

    private ExpressionEvaluator getOrCreateBaseExpressionEvaluator() {
        if (this.baseExpressionEvaluator == null) {
            this.baseExpressionEvaluator = new BaseExpressionEvaluator(this.classLoader);
        }
        return this.baseExpressionEvaluator;
    }

    private ExpressionEvaluator getOrCreateMVELExpressionEvaluator() {
        if (this.mvelExpressionEvaluator == null) {
            this.mvelExpressionEvaluator = new MVELExpressionEvaluator(this.classLoader);
        }
        return this.mvelExpressionEvaluator;
    }

    private ExpressionEvaluator getOrCreateDMNExpressionEvaluator() {
        if (this.dmnFeelExpressionEvaluator == null) {
            this.dmnFeelExpressionEvaluator = new DMNFeelExpressionEvaluator(this.classLoader);
        }
        return this.dmnFeelExpressionEvaluator;
    }
}

