/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.fluent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.scenariosimulation.backend.fluent.RuleScenarioExecutableBuilder;
import org.kie.api.definition.rule.Rule;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.DefaultAgendaEventListener;
import org.kie.internal.definition.rule.InternalRule;

public class CoverageAgendaListener
extends DefaultAgendaEventListener {
    protected Map<String, Integer> ruleExecuted = new HashMap<String, Integer>();
    protected List<String> auditsMessages = new ArrayList<String>();

    public static String generateAuditMessage(String ruleName) {
        return "Executed rule: " + ruleName;
    }

    public void beforeMatchFired(BeforeMatchFiredEvent beforeMatchFiredEvent) {
        InternalRule rule = (InternalRule)beforeMatchFiredEvent.getMatch().getRule();
        String ruleKey = RuleScenarioExecutableBuilder.prettyFullyQualifiedName((Rule)rule);
        this.ruleExecuted.compute(ruleKey, (r, counter) -> counter == null ? 1 : counter + 1);
        this.auditsMessages.add(CoverageAgendaListener.generateAuditMessage(ruleKey));
    }

    public Map<String, Integer> getRuleExecuted() {
        return Collections.unmodifiableMap(this.ruleExecuted);
    }

    public List<String> getAuditsMessages() {
        return Collections.unmodifiableList(this.auditsMessages);
    }
}

