/*
 * Decompiled with CFR 0.152.
 */
package org.drools.scenariosimulation.backend.runner;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.ExpressionIdentifier;
import org.drools.scenariosimulation.api.model.FactIdentifier;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluator;
import org.drools.scenariosimulation.backend.expression.ExpressionEvaluatorFactory;
import org.drools.scenariosimulation.backend.fluent.DMNScenarioExecutableBuilder;
import org.drools.scenariosimulation.backend.runner.AbstractRunnerHelper;
import org.drools.scenariosimulation.backend.runner.ScenarioException;
import org.drools.scenariosimulation.backend.runner.model.ResultWrapper;
import org.drools.scenariosimulation.backend.runner.model.ScenarioExpect;
import org.drools.scenariosimulation.backend.runner.model.ScenarioGiven;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResult;
import org.drools.scenariosimulation.backend.runner.model.ScenarioResultMetadata;
import org.drools.scenariosimulation.backend.runner.model.ScenarioRunnerData;
import org.kie.api.runtime.KieContainer;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNModel;
import org.kie.dmn.api.core.DMNResult;
import org.kie.dmn.api.core.ast.DecisionNode;

public class DMNScenarioRunnerHelper
extends AbstractRunnerHelper {
    @Override
    protected Map<String, Object> executeScenario(KieContainer kieContainer, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluatorFactory expressionEvaluatorFactory, SimulationDescriptor simulationDescriptor) {
        if (!ScenarioSimulationModel.Type.DMN.equals((Object)simulationDescriptor.getType())) {
            throw new ScenarioException("Impossible to run a not-DMN simulation with DMN runner");
        }
        DMNScenarioExecutableBuilder executableBuilder = DMNScenarioExecutableBuilder.createBuilder(kieContainer);
        executableBuilder.setActiveModel(simulationDescriptor.getDmnFilePath());
        for (ScenarioGiven input : scenarioRunnerData.getGivens()) {
            executableBuilder.setValue(input.getFactIdentifier().getName(), input.getValue());
        }
        return executableBuilder.run().getOutputs();
    }

    @Override
    protected ScenarioResultMetadata extractResultMetadata(Map<String, Object> requestContext, ScenarioWithIndex scenarioWithIndex) {
        DMNModel dmnModel = (DMNModel)requestContext.get(DMNScenarioExecutableBuilder.DMN_MODEL);
        DMNResult dmnResult = (DMNResult)requestContext.get(DMNScenarioExecutableBuilder.DMN_RESULT);
        ScenarioResultMetadata scenarioResultMetadata = new ScenarioResultMetadata(scenarioWithIndex);
        for (DecisionNode decision : dmnModel.getDecisions()) {
            scenarioResultMetadata.addAvailable(decision.getName());
        }
        AtomicInteger counter = new AtomicInteger(0);
        for (DMNDecisionResult decisionResult : dmnResult.getDecisionResults()) {
            if (DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED.equals((Object)decisionResult.getEvaluationStatus())) {
                scenarioResultMetadata.addExecuted(decisionResult.getDecisionName());
            }
            if (decisionResult.getMessages().isEmpty()) {
                scenarioResultMetadata.addAuditMessage(counter.addAndGet(1), decisionResult.getDecisionName(), decisionResult.getEvaluationStatus().name());
                continue;
            }
            decisionResult.getMessages().forEach(dmnMessage -> scenarioResultMetadata.addAuditMessage(counter.addAndGet(1), dmnMessage.getText(), dmnMessage.getLevel().name()));
        }
        return scenarioResultMetadata;
    }

    @Override
    protected void verifyConditions(SimulationDescriptor simulationDescriptor, ScenarioRunnerData scenarioRunnerData, ExpressionEvaluatorFactory expressionEvaluatorFactory, Map<String, Object> requestContext) {
        DMNResult dmnResult = (DMNResult)requestContext.get(DMNScenarioExecutableBuilder.DMN_RESULT);
        for (ScenarioExpect output : scenarioRunnerData.getExpects()) {
            FactIdentifier factIdentifier = output.getFactIdentifier();
            String decisionName = factIdentifier.getName();
            DMNDecisionResult decisionResult = dmnResult.getDecisionResultByName(decisionName);
            if (decisionResult == null) {
                throw new ScenarioException("DMN execution has not generated a decision result with name " + decisionName);
            }
            for (FactMappingValue expectedResult : output.getExpectedResult()) {
                ExpressionIdentifier expressionIdentifier = expectedResult.getExpressionIdentifier();
                FactMapping factMapping = (FactMapping)simulationDescriptor.getFactMapping(factIdentifier, expressionIdentifier).orElseThrow(() -> new IllegalStateException("Wrong expression, this should not happen"));
                ExpressionEvaluator expressionEvaluator = expressionEvaluatorFactory.getOrCreate(expectedResult);
                ScenarioResult scenarioResult = this.fillResult(expectedResult, () -> this.getSingleFactValueResult(factMapping, expectedResult, decisionResult, expressionEvaluator), expressionEvaluator);
                scenarioRunnerData.addResult(scenarioResult);
            }
        }
    }

    protected ResultWrapper getSingleFactValueResult(FactMapping factMapping, FactMappingValue expectedResult, DMNDecisionResult decisionResult, ExpressionEvaluator expressionEvaluator) {
        Object resultRaw = decisionResult.getResult();
        DMNDecisionResult.DecisionEvaluationStatus evaluationStatus = decisionResult.getEvaluationStatus();
        if (!DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED.equals((Object)evaluationStatus)) {
            return ResultWrapper.createErrorResultWithErrorMessage("The decision " + decisionResult.getDecisionName() + " has not been successfully evaluated: " + evaluationStatus);
        }
        List elementsWithoutClass = factMapping.getExpressionElementsWithoutClass();
        if (resultRaw != null) {
            for (ExpressionElement expressionElement : elementsWithoutClass) {
                if (!(resultRaw instanceof Map)) {
                    throw new ScenarioException("Wrong resultRaw structure because it is not a complex type as expected");
                }
                Map result = (Map)resultRaw;
                resultRaw = result.get(expressionElement.getStep());
            }
        }
        Class<?> resultClass = resultRaw != null ? resultRaw.getClass() : null;
        Object expectedResultRaw = expectedResult.getRawValue();
        return this.getResultWrapper(factMapping.getClassName(), expectedResult, expressionEvaluator, expectedResultRaw, resultRaw, resultClass);
    }

    @Override
    protected Object createObject(String className, Map<List<String>, Object> params, ClassLoader classLoader) {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        for (Map.Entry<List<String>, Object> listObjectEntry : params.entrySet()) {
            List<String> allSteps = listObjectEntry.getKey();
            List<String> steps = allSteps.subList(0, allSteps.size() - 1);
            String lastStep = allSteps.get(allSteps.size() - 1);
            Map<String, Object> targetMap = toReturn;
            for (String step : steps) {
                targetMap = (Map)targetMap.computeIfAbsent(step, k -> new HashMap());
            }
            targetMap.put(lastStep, listObjectEntry.getValue());
        }
        return toReturn;
    }
}

