/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.workbench.pr.model;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jbpm.workbench.common.model.GenericErrorSummary;
import org.jbpm.workbench.common.model.GenericSummary;
import org.jbpm.workbench.pr.model.ProcessInstanceKey;
import org.jbpm.workbench.pr.model.UserTaskSummary;

@Portable
public class ProcessInstanceSummary
extends GenericErrorSummary<Long> {
    private String serverTemplateId;
    private Long processInstanceId;
    private String processId;
    private String processName;
    private String processVersion;
    private Integer state;
    private Date startTime;
    private Date endTime;
    private String deploymentId;
    private String initiator;
    private String processInstanceDescription;
    private Long parentId;
    private String correlationKey;
    private Map<String, String> domainData = new HashMap<String, String>();
    private List<UserTaskSummary> activeTasks;
    private Date lastModificationDate;
    private Integer slaCompliance;
    private Date slaDueDate;

    public ProcessInstanceSummary(String serverTemplateId, Long processInstanceId, String processId, String deploymentId, String processName, String processVersion, Integer state, Date startTime, Date endTime, String initiator, String processInstanceDescription, String correlationKey, Long parentId, Date lastModificationDate, Integer slaCompliance, Date slaDueDate, Integer errorCount) {
        super(errorCount, (Object)processInstanceId, processName);
        this.serverTemplateId = serverTemplateId;
        this.processInstanceId = processInstanceId;
        this.processId = processId;
        this.processName = processName;
        this.deploymentId = deploymentId;
        this.processVersion = processVersion;
        this.state = state;
        this.startTime = startTime;
        this.endTime = endTime;
        this.initiator = initiator;
        this.processInstanceDescription = processInstanceDescription;
        this.correlationKey = correlationKey;
        this.parentId = parentId;
        this.lastModificationDate = lastModificationDate;
        this.slaCompliance = slaCompliance;
        this.slaDueDate = slaDueDate;
    }

    public ProcessInstanceSummary() {
    }

    public void addDomainData(String key, String value) {
        this.domainData.put(key, value);
    }

    public String getDomainDataValue(String key) {
        return this.domainData.get(key);
    }

    public Map<String, String> getDomainData() {
        return this.domainData;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessVersion() {
        return this.processVersion;
    }

    public void setProcessVersion(String processVersion) {
        this.processVersion = processVersion;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getInitiator() {
        return this.initiator;
    }

    public void setInitiator(String initiator) {
        this.initiator = initiator;
    }

    public String getProcessInstanceDescription() {
        return this.processInstanceDescription;
    }

    public void setProcessInstanceDescription(String processInstanceDescription) {
        this.processInstanceDescription = processInstanceDescription;
    }

    public List<UserTaskSummary> getActiveTasks() {
        return this.activeTasks;
    }

    public void setActiveTasks(List<UserTaskSummary> activeTasks) {
        this.activeTasks = activeTasks;
    }

    public String getCorrelationKey() {
        return this.correlationKey;
    }

    public void setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDate(Date lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
    }

    public Integer getSlaCompliance() {
        return this.slaCompliance;
    }

    public void setSlaCompliance(Integer slaCompliance) {
        this.slaCompliance = slaCompliance;
    }

    public Date getSlaDueDate() {
        return this.slaDueDate;
    }

    public void setSlaDueDate(Date slaDueDate) {
        this.slaDueDate = slaDueDate;
    }

    public String getServerTemplateId() {
        return this.serverTemplateId;
    }

    public void setServerTemplateId(String serverTemplateId) {
        this.serverTemplateId = serverTemplateId;
    }

    public ProcessInstanceKey getProcessInstanceKey() {
        return new ProcessInstanceKey(this.serverTemplateId, this.deploymentId, this.processInstanceId);
    }

    public String toString() {
        return "ProcessInstanceSummary{serverTemplateId='" + this.serverTemplateId + '\'' + ", processInstanceId=" + this.processInstanceId + ", processId='" + this.processId + '\'' + ", processName='" + this.processName + '\'' + ", processVersion='" + this.processVersion + '\'' + ", state=" + this.state + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", deploymentId='" + this.deploymentId + '\'' + ", initiator='" + this.initiator + '\'' + ", processInstanceDescription='" + this.processInstanceDescription + '\'' + ", parentId=" + this.parentId + ", correlationKey='" + this.correlationKey + '\'' + ", domainData=" + this.domainData + ", activeTasks=" + this.activeTasks + ", lastModificationDate=" + this.lastModificationDate + ", slaCompliance=" + this.slaCompliance + ", slaDueDate=" + this.slaDueDate + ", id=" + this.id + ", name='" + this.name + '\'' + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    @NonPortable
    public static final class Builder {
        private ProcessInstanceSummary processInstanceSummary = new ProcessInstanceSummary();

        private Builder() {
        }

        public Builder withErrorCount(Integer errorCount) {
            this.processInstanceSummary.setErrorCount(errorCount);
            return this;
        }

        public Builder withServerTemplateId(String serverTemplateId) {
            this.processInstanceSummary.setServerTemplateId(serverTemplateId);
            return this;
        }

        public Builder withProcessInstanceId(Long processInstanceId) {
            this.processInstanceSummary.setProcessInstanceId(processInstanceId);
            this.processInstanceSummary.setId(processInstanceId);
            return this;
        }

        public Builder withProcessId(String processId) {
            this.processInstanceSummary.setProcessId(processId);
            return this;
        }

        public Builder withProcessName(String processName) {
            this.processInstanceSummary.setProcessName(processName);
            this.processInstanceSummary.setName(processName);
            return this;
        }

        public Builder withProcessVersion(String processVersion) {
            this.processInstanceSummary.setProcessVersion(processVersion);
            return this;
        }

        public Builder withCallbacks(List<GenericSummary.LabeledCommand> callbacks) {
            this.processInstanceSummary.setCallbacks(callbacks);
            return this;
        }

        public Builder withState(Integer state) {
            this.processInstanceSummary.setState(state);
            return this;
        }

        public Builder withStartTime(Date startTime) {
            this.processInstanceSummary.setStartTime(startTime);
            return this;
        }

        public Builder withEndTime(Date endTime) {
            this.processInstanceSummary.setEndTime(endTime);
            return this;
        }

        public Builder withDeploymentId(String deploymentId) {
            this.processInstanceSummary.setDeploymentId(deploymentId);
            return this;
        }

        public Builder withInitiator(String initiator) {
            this.processInstanceSummary.setInitiator(initiator);
            return this;
        }

        public Builder withProcessInstanceDescription(String processInstanceDescription) {
            this.processInstanceSummary.setProcessInstanceDescription(processInstanceDescription);
            return this;
        }

        public Builder withParentId(Long parentId) {
            this.processInstanceSummary.setParentId(parentId);
            return this;
        }

        public Builder withCorrelationKey(String correlationKey) {
            this.processInstanceSummary.setCorrelationKey(correlationKey);
            return this;
        }

        public Builder withActiveTasks(List<UserTaskSummary> activeTasks) {
            this.processInstanceSummary.setActiveTasks(activeTasks);
            return this;
        }

        public Builder withLastModificationDate(Date lastModificationDate) {
            this.processInstanceSummary.setLastModificationDate(lastModificationDate);
            return this;
        }

        public Builder withSlaCompliance(Integer slaCompliance) {
            this.processInstanceSummary.setSlaCompliance(slaCompliance);
            return this;
        }

        public Builder withSlaDueDate(Date slaDueDate) {
            this.processInstanceSummary.setSlaDueDate(slaDueDate);
            return this;
        }

        public ProcessInstanceSummary build() {
            return this.processInstanceSummary;
        }
    }
}

