/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.util;

import java.util.Arrays;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String s) {
        return null == s || s.trim().length() == 0;
    }

    public static boolean nonEmpty(String s) {
        return !StringUtils.isEmpty(s);
    }

    public static boolean hasNonEmpty(String ... values) {
        return values != null && Arrays.stream(values).anyMatch(StringUtils::nonEmpty);
    }

    public static boolean isQuotedConstant(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        return str.startsWith("\"") && str.endsWith("\"");
    }

    public static String createQuotedConstant(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return "\"" + str + "\"";
    }

    public static String createQuotedConstantOptionalNumeric(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return "\"" + str + "\"";
        }
        return str;
    }

    public static String createUnquotedConstant(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (str.startsWith("\"")) {
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }
}

