/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.rule.backend.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import org.drools.workbench.models.commons.backend.rule.RuleModelDRLPersistenceImpl;
import org.drools.workbench.models.commons.backend.rule.RuleModelIActionPersistenceExtension;
import org.drools.workbench.models.datamodel.rule.RuleModel;
import org.drools.workbench.screens.guided.rule.backend.server.GuidedRuleEditorServiceUtilities;
import org.drools.workbench.screens.guided.rule.type.GuidedRuleDRLResourceTypeDefinition;
import org.drools.workbench.screens.guided.rule.type.GuidedRuleDSLRResourceTypeDefinition;
import org.guvnor.common.services.backend.util.CommentedOptionFactory;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.ext.editor.commons.backend.service.helper.CopyHelper;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.workbench.type.FileNameUtil;
import org.uberfire.workbench.type.ResourceTypeDefinition;

@ApplicationScoped
public class GuidedRuleEditorCopyHelper
implements CopyHelper {
    private IOService ioService;
    private GuidedRuleDRLResourceTypeDefinition drlResourceType;
    private GuidedRuleDSLRResourceTypeDefinition dslrResourceType;
    private GuidedRuleEditorServiceUtilities utilities;
    private CommentedOptionFactory commentedOptionFactory;
    private DataModelService dataModelService;
    private Collection<RuleModelIActionPersistenceExtension> persistenceExtensions = new ArrayList<RuleModelIActionPersistenceExtension>();

    public GuidedRuleEditorCopyHelper() {
    }

    @Inject
    public GuidedRuleEditorCopyHelper(@Named(value="ioStrategy") IOService ioService, GuidedRuleDRLResourceTypeDefinition drlResourceType, GuidedRuleDSLRResourceTypeDefinition dslrResourceType, GuidedRuleEditorServiceUtilities utilities, CommentedOptionFactory commentedOptionFactory, DataModelService dataModelService, Instance<RuleModelIActionPersistenceExtension> persistenceExtensionInstance) {
        this.ioService = ioService;
        this.drlResourceType = drlResourceType;
        this.dslrResourceType = dslrResourceType;
        this.utilities = utilities;
        this.commentedOptionFactory = commentedOptionFactory;
        this.dataModelService = dataModelService;
        persistenceExtensionInstance.forEach(this.persistenceExtensions::add);
    }

    public boolean supports(org.uberfire.backend.vfs.Path destination) {
        return this.drlResourceType.accept(destination) || this.dslrResourceType.accept(destination);
    }

    public void postProcess(org.uberfire.backend.vfs.Path source, org.uberfire.backend.vfs.Path destination) {
        Path _destination = Paths.convert((org.uberfire.backend.vfs.Path)destination);
        String drl = this.ioService.readAllString(_destination);
        String[] dsls = this.utilities.loadDslsForPackage(destination);
        List<String> globals = this.utilities.loadGlobalsForPackage(destination);
        RuleModel model = null;
        String ruleName = null;
        if (this.drlResourceType.accept(destination)) {
            model = RuleModelDRLPersistenceImpl.getInstance().unmarshal(drl, globals, this.dataModelService.getDataModel(destination), this.persistenceExtensions);
            ruleName = FileNameUtil.removeExtension((org.uberfire.backend.vfs.Path)destination, (ResourceTypeDefinition)this.drlResourceType);
        } else if (this.dslrResourceType.accept(destination)) {
            model = RuleModelDRLPersistenceImpl.getInstance().unmarshalUsingDSL(drl, globals, this.dataModelService.getDataModel(destination), this.persistenceExtensions, dsls);
            ruleName = FileNameUtil.removeExtension((org.uberfire.backend.vfs.Path)destination, (ResourceTypeDefinition)this.dslrResourceType);
        }
        if (model != null) {
            model.name = ruleName;
            this.ioService.write(_destination, RuleModelDRLPersistenceImpl.getInstance().marshal(model), new OpenOption[]{this.commentedOptionFactory.makeCommentedOption("File [" + source.toURI() + "] copied to [" + destination.toURI() + "].")});
        }
    }
}

