/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import java.lang.Double;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class CanvasRenderingContext2D implements CanvasPathMethods {
  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface ClipOptFillRuleOrPathUnionType {
    @JsOverlay
    static ClipOptFillRuleOrPathUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Path2D asPath2D() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isPath2D() {
      return (Object) this instanceof Path2D;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface CreatePatternImageUnionType {
    @JsOverlay
    static CreatePatternImageUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default HTMLCanvasElement asHTMLCanvasElement() {
      return Js.cast(this);
    }

    @JsOverlay
    default HTMLImageElement asHTMLImageElement() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isHTMLCanvasElement() {
      return (Object) this instanceof HTMLCanvasElement;
    }

    @JsOverlay
    default boolean isHTMLImageElement() {
      return (Object) this instanceof HTMLImageElement;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface DrawImageImageUnionType {
    @JsOverlay
    static DrawImageImageUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default HTMLCanvasElement asHTMLCanvasElement() {
      return Js.cast(this);
    }

    @JsOverlay
    default HTMLImageElement asHTMLImageElement() {
      return Js.cast(this);
    }

    @JsOverlay
    default HTMLVideoElement asHTMLVideoElement() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isHTMLCanvasElement() {
      return (Object) this instanceof HTMLCanvasElement;
    }

    @JsOverlay
    default boolean isHTMLImageElement() {
      return (Object) this instanceof HTMLImageElement;
    }

    @JsOverlay
    default boolean isHTMLVideoElement() {
      return (Object) this instanceof HTMLVideoElement;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface FillOptFillRuleOrPathUnionType {
    @JsOverlay
    static FillOptFillRuleOrPathUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default Path2D asPath2D() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isPath2D() {
      return (Object) this instanceof Path2D;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface FillStyleUnionType {
    @JsOverlay
    static FillStyleUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default CanvasGradient asCanvasGradient() {
      return Js.cast(this);
    }

    @JsOverlay
    default CanvasPattern asCanvasPattern() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isCanvasGradient() {
      return (Object) this instanceof CanvasGradient;
    }

    @JsOverlay
    default boolean isCanvasPattern() {
      return (Object) this instanceof CanvasPattern;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface SetFillColorP0UnionType {
    @JsOverlay
    static SetFillColorP0UnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.castToDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface SetStrokeColorP0UnionType {
    @JsOverlay
    static SetStrokeColorP0UnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default double asDouble() {
      return Js.castToDouble(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isDouble() {
      return (Object) this instanceof Double;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface StrokeStyleUnionType {
    @JsOverlay
    static StrokeStyleUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default CanvasGradient asCanvasGradient() {
      return Js.cast(this);
    }

    @JsOverlay
    default CanvasPattern asCanvasPattern() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isCanvasGradient() {
      return (Object) this instanceof CanvasGradient;
    }

    @JsOverlay
    default boolean isCanvasPattern() {
      return (Object) this instanceof CanvasPattern;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  public HTMLCanvasElement canvas;
  public String fillColor;
  public FillStyleUnionType fillStyle;
  public String font;
  public double globalAlpha;
  public String globalCompositeOperation;
  public String lineCap;
  public double lineDashOffset;
  public String lineJoin;
  public double lineWidth;
  public double miterLimit;
  public double shadowBlur;
  public String shadowColor;
  public double shadowOffsetX;
  public double shadowOffsetY;
  public String strokeColor;
  public StrokeStyleUnionType strokeStyle;
  public String textAlign;
  public String textBaseline;

  public native void arc(
      double x, double y, double radius, double startAngle, double endAngle, boolean anticlockwise);

  public native void arc(double x, double y, double radius, double startAngle, double endAngle);

  public native void arcTo(double x1, double y1, double x2, double y2, double radius);

  public native void beginPath();

  public native void bezierCurveTo(
      double cp1x, double cp1y, double cp2x, double cp2y, double x, double y);

  public native void clearRect(double x, double y, double w, double h);

  public native void clip();

  public native void clip(ClipOptFillRuleOrPathUnionType optFillRuleOrPath, String optFillRule);

  public native void clip(ClipOptFillRuleOrPathUnionType optFillRuleOrPath);

  @JsOverlay
  public final void clip(Path2D optFillRuleOrPath, String optFillRule) {
    clip(Js.<ClipOptFillRuleOrPathUnionType>uncheckedCast(optFillRuleOrPath), optFillRule);
  }

  @JsOverlay
  public final void clip(Path2D optFillRuleOrPath) {
    clip(Js.<ClipOptFillRuleOrPathUnionType>uncheckedCast(optFillRuleOrPath));
  }

  @JsOverlay
  public final void clip(String optFillRuleOrPath, String optFillRule) {
    clip(Js.<ClipOptFillRuleOrPathUnionType>uncheckedCast(optFillRuleOrPath), optFillRule);
  }

  @JsOverlay
  public final void clip(String optFillRuleOrPath) {
    clip(Js.<ClipOptFillRuleOrPathUnionType>uncheckedCast(optFillRuleOrPath));
  }

  public native void closePath();

  public native ImageData createImageData(double sw, double sh);

  public native CanvasGradient createLinearGradient(double x0, double y0, double x1, double y1);

  public native CanvasPattern createPattern(CreatePatternImageUnionType image, String repetition);

  @JsOverlay
  public final CanvasPattern createPattern(HTMLCanvasElement image, String repetition) {
    return createPattern(Js.<CreatePatternImageUnionType>uncheckedCast(image), repetition);
  }

  @JsOverlay
  public final CanvasPattern createPattern(HTMLImageElement image, String repetition) {
    return createPattern(Js.<CreatePatternImageUnionType>uncheckedCast(image), repetition);
  }

  public native CanvasGradient createRadialGradient(
      double x0, double y0, double r0, double x1, double y1, double r1);

  public native void drawImage(
      DrawImageImageUnionType image,
      double dx,
      double dy,
      double dw,
      double dh,
      double sx,
      double sy,
      double sw,
      double sh);

  public native void drawImage(
      DrawImageImageUnionType image,
      double dx,
      double dy,
      double dw,
      double dh,
      double sx,
      double sy,
      double sw);

  public native void drawImage(
      DrawImageImageUnionType image,
      double dx,
      double dy,
      double dw,
      double dh,
      double sx,
      double sy);

  public native void drawImage(
      DrawImageImageUnionType image, double dx, double dy, double dw, double dh, double sx);

  public native void drawImage(
      DrawImageImageUnionType image, double dx, double dy, double dw, double dh);

  public native void drawImage(DrawImageImageUnionType image, double dx, double dy, double dw);

  public native void drawImage(DrawImageImageUnionType image, double dx, double dy);

  @JsOverlay
  public final void drawImage(
      HTMLCanvasElement image,
      double dx,
      double dy,
      double dw,
      double dh,
      double sx,
      double sy,
      double sw,
      double sh) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh, sx, sy, sw, sh);
  }

  @JsOverlay
  public final void drawImage(
      HTMLCanvasElement image,
      double dx,
      double dy,
      double dw,
      double dh,
      double sx,
      double sy,
      double sw) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh, sx, sy, sw);
  }

  @JsOverlay
  public final void drawImage(
      HTMLCanvasElement image, double dx, double dy, double dw, double dh, double sx, double sy) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh, sx, sy);
  }

  @JsOverlay
  public final void drawImage(
      HTMLCanvasElement image, double dx, double dy, double dw, double dh, double sx) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh, sx);
  }

  @JsOverlay
  public final void drawImage(HTMLCanvasElement image, double dx, double dy, double dw, double dh) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh);
  }

  @JsOverlay
  public final void drawImage(HTMLCanvasElement image, double dx, double dy, double dw) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw);
  }

  @JsOverlay
  public final void drawImage(HTMLCanvasElement image, double dx, double dy) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy);
  }

  @JsOverlay
  public final void drawImage(
      HTMLImageElement image,
      double dx,
      double dy,
      double dw,
      double dh,
      double sx,
      double sy,
      double sw,
      double sh) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh, sx, sy, sw, sh);
  }

  @JsOverlay
  public final void drawImage(
      HTMLImageElement image,
      double dx,
      double dy,
      double dw,
      double dh,
      double sx,
      double sy,
      double sw) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh, sx, sy, sw);
  }

  @JsOverlay
  public final void drawImage(
      HTMLImageElement image, double dx, double dy, double dw, double dh, double sx, double sy) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh, sx, sy);
  }

  @JsOverlay
  public final void drawImage(
      HTMLImageElement image, double dx, double dy, double dw, double dh, double sx) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh, sx);
  }

  @JsOverlay
  public final void drawImage(HTMLImageElement image, double dx, double dy, double dw, double dh) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh);
  }

  @JsOverlay
  public final void drawImage(HTMLImageElement image, double dx, double dy, double dw) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw);
  }

  @JsOverlay
  public final void drawImage(HTMLImageElement image, double dx, double dy) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy);
  }

  @JsOverlay
  public final void drawImage(
      HTMLVideoElement image,
      double dx,
      double dy,
      double dw,
      double dh,
      double sx,
      double sy,
      double sw,
      double sh) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh, sx, sy, sw, sh);
  }

  @JsOverlay
  public final void drawImage(
      HTMLVideoElement image,
      double dx,
      double dy,
      double dw,
      double dh,
      double sx,
      double sy,
      double sw) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh, sx, sy, sw);
  }

  @JsOverlay
  public final void drawImage(
      HTMLVideoElement image, double dx, double dy, double dw, double dh, double sx, double sy) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh, sx, sy);
  }

  @JsOverlay
  public final void drawImage(
      HTMLVideoElement image, double dx, double dy, double dw, double dh, double sx) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh, sx);
  }

  @JsOverlay
  public final void drawImage(HTMLVideoElement image, double dx, double dy, double dw, double dh) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw, dh);
  }

  @JsOverlay
  public final void drawImage(HTMLVideoElement image, double dx, double dy, double dw) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy, dw);
  }

  @JsOverlay
  public final void drawImage(HTMLVideoElement image, double dx, double dy) {
    drawImage(Js.<DrawImageImageUnionType>uncheckedCast(image), dx, dy);
  }

  public native void ellipse(
      double x,
      double y,
      double radiusX,
      double radiusY,
      double rotation,
      double startAngle,
      double endAngle,
      boolean anticlockwise);

  public native void ellipse(
      double x,
      double y,
      double radiusX,
      double radiusY,
      double rotation,
      double startAngle,
      double endAngle);

  public native void fill();

  public native void fill(FillOptFillRuleOrPathUnionType optFillRuleOrPath, String optFillRule);

  public native void fill(FillOptFillRuleOrPathUnionType optFillRuleOrPath);

  @JsOverlay
  public final void fill(Path2D optFillRuleOrPath, String optFillRule) {
    fill(Js.<FillOptFillRuleOrPathUnionType>uncheckedCast(optFillRuleOrPath), optFillRule);
  }

  @JsOverlay
  public final void fill(Path2D optFillRuleOrPath) {
    fill(Js.<FillOptFillRuleOrPathUnionType>uncheckedCast(optFillRuleOrPath));
  }

  @JsOverlay
  public final void fill(String optFillRuleOrPath, String optFillRule) {
    fill(Js.<FillOptFillRuleOrPathUnionType>uncheckedCast(optFillRuleOrPath), optFillRule);
  }

  @JsOverlay
  public final void fill(String optFillRuleOrPath) {
    fill(Js.<FillOptFillRuleOrPathUnionType>uncheckedCast(optFillRuleOrPath));
  }

  public native void fillRect(double x, double y, double w, double h);

  public native void fillText(String text, double x, double y, double maxWidth);

  public native void fillText(String text, double x, double y);

  public native ImageData getImageData(double sx, double sy, double sw, double sh);

  public native double[] getLineDash();

  public native boolean isPointInPath(double x, double y, String fillRule);

  public native boolean isPointInPath(double x, double y);

  public native boolean isPointInStroke(double x, double y);

  public native void lineTo(double x, double y);

  public native TextMetrics measureText(String text);

  public native void moveTo(double x, double y);

  public native void putImageData(
      ImageData imagedata,
      double dx,
      double dy,
      double dirtyX,
      double dirtyY,
      double dirtyWidth,
      double dirtyHeight);

  public native void putImageData(
      ImageData imagedata, double dx, double dy, double dirtyX, double dirtyY, double dirtyWidth);

  public native void putImageData(
      ImageData imagedata, double dx, double dy, double dirtyX, double dirtyY);

  public native void putImageData(ImageData imagedata, double dx, double dy, double dirtyX);

  public native void putImageData(ImageData imagedata, double dx, double dy);

  public native void quadraticCurveTo(double cpx, double cpy, double x, double y);

  public native void rect(double x, double y, double w, double h);

  public native void restore();

  public native void rotate(double angle);

  public native void save();

  public native void scale(double x, double y);

  public native void setFillColor();

  public native void setFillColor(
      SetFillColorP0UnionType p0, double p1, double p2, double p3, double p4);

  public native void setFillColor(SetFillColorP0UnionType p0, double p1, double p2, double p3);

  public native void setFillColor(SetFillColorP0UnionType p0, double p1, double p2);

  public native void setFillColor(SetFillColorP0UnionType p0, double p1);

  public native void setFillColor(SetFillColorP0UnionType p0);

  @JsOverlay
  public final void setFillColor(String p0, double p1, double p2, double p3, double p4) {
    setFillColor(Js.<SetFillColorP0UnionType>uncheckedCast(p0), p1, p2, p3, p4);
  }

  @JsOverlay
  public final void setFillColor(String p0, double p1, double p2, double p3) {
    setFillColor(Js.<SetFillColorP0UnionType>uncheckedCast(p0), p1, p2, p3);
  }

  @JsOverlay
  public final void setFillColor(String p0, double p1, double p2) {
    setFillColor(Js.<SetFillColorP0UnionType>uncheckedCast(p0), p1, p2);
  }

  @JsOverlay
  public final void setFillColor(String p0, double p1) {
    setFillColor(Js.<SetFillColorP0UnionType>uncheckedCast(p0), p1);
  }

  @JsOverlay
  public final void setFillColor(String p0) {
    setFillColor(Js.<SetFillColorP0UnionType>uncheckedCast(p0));
  }

  @JsOverlay
  public final void setFillColor(double p0, double p1, double p2, double p3, double p4) {
    setFillColor(Js.<SetFillColorP0UnionType>uncheckedCast(p0), p1, p2, p3, p4);
  }

  @JsOverlay
  public final void setFillColor(double p0, double p1, double p2, double p3) {
    setFillColor(Js.<SetFillColorP0UnionType>uncheckedCast(p0), p1, p2, p3);
  }

  @JsOverlay
  public final void setFillColor(double p0, double p1, double p2) {
    setFillColor(Js.<SetFillColorP0UnionType>uncheckedCast(p0), p1, p2);
  }

  @JsOverlay
  public final void setFillColor(double p0, double p1) {
    setFillColor(Js.<SetFillColorP0UnionType>uncheckedCast(p0), p1);
  }

  @JsOverlay
  public final void setFillColor(double p0) {
    setFillColor(Js.<SetFillColorP0UnionType>uncheckedCast(p0));
  }

  public native void setLineDash(double[] p0);

  public native void setStrokeColor();

  public native void setStrokeColor(
      SetStrokeColorP0UnionType p0, double p1, double p2, double p3, double p4);

  public native void setStrokeColor(SetStrokeColorP0UnionType p0, double p1, double p2, double p3);

  public native void setStrokeColor(SetStrokeColorP0UnionType p0, double p1, double p2);

  public native void setStrokeColor(SetStrokeColorP0UnionType p0, double p1);

  public native void setStrokeColor(SetStrokeColorP0UnionType p0);

  @JsOverlay
  public final void setStrokeColor(String p0, double p1, double p2, double p3, double p4) {
    setStrokeColor(Js.<SetStrokeColorP0UnionType>uncheckedCast(p0), p1, p2, p3, p4);
  }

  @JsOverlay
  public final void setStrokeColor(String p0, double p1, double p2, double p3) {
    setStrokeColor(Js.<SetStrokeColorP0UnionType>uncheckedCast(p0), p1, p2, p3);
  }

  @JsOverlay
  public final void setStrokeColor(String p0, double p1, double p2) {
    setStrokeColor(Js.<SetStrokeColorP0UnionType>uncheckedCast(p0), p1, p2);
  }

  @JsOverlay
  public final void setStrokeColor(String p0, double p1) {
    setStrokeColor(Js.<SetStrokeColorP0UnionType>uncheckedCast(p0), p1);
  }

  @JsOverlay
  public final void setStrokeColor(String p0) {
    setStrokeColor(Js.<SetStrokeColorP0UnionType>uncheckedCast(p0));
  }

  @JsOverlay
  public final void setStrokeColor(double p0, double p1, double p2, double p3, double p4) {
    setStrokeColor(Js.<SetStrokeColorP0UnionType>uncheckedCast(p0), p1, p2, p3, p4);
  }

  @JsOverlay
  public final void setStrokeColor(double p0, double p1, double p2, double p3) {
    setStrokeColor(Js.<SetStrokeColorP0UnionType>uncheckedCast(p0), p1, p2, p3);
  }

  @JsOverlay
  public final void setStrokeColor(double p0, double p1, double p2) {
    setStrokeColor(Js.<SetStrokeColorP0UnionType>uncheckedCast(p0), p1, p2);
  }

  @JsOverlay
  public final void setStrokeColor(double p0, double p1) {
    setStrokeColor(Js.<SetStrokeColorP0UnionType>uncheckedCast(p0), p1);
  }

  @JsOverlay
  public final void setStrokeColor(double p0) {
    setStrokeColor(Js.<SetStrokeColorP0UnionType>uncheckedCast(p0));
  }

  public native void setTransform(
      double m11, double m12, double m21, double m22, double dx, double dy);

  public native void stroke();

  public native void stroke(Path2D optStroke);

  public native void strokeRect(double x, double y, double w, double h);

  public native void strokeText(String text, double x, double y, double maxWidth);

  public native void strokeText(String text, double x, double y);

  public native void transform(
      double m11, double m12, double m21, double m22, double dx, double dy);

  public native void translate(double x, double y);
}
