/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.graph.content;

import java.util.Objects;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Portable
public class Bounds {
    private Bound lr;
    private Bound ul;

    public static Bounds create() {
        return Bounds.create(0.0, 0.0, 0.0, 0.0);
    }

    public static Bounds createEmpty() {
        return Bounds.create(null, null);
    }

    public static Bounds createMinBounds(double x1, double y1) {
        return Bounds.create(Bound.create(x1, y1), null);
    }

    public static Bounds create(double x1, double y1, double x2, double y2) {
        return Bounds.create(Bound.create(x1, y1), Bound.create(x2, y2));
    }

    public static Bounds create(Bound xy0, Bound xy1) {
        return new Bounds(xy0, xy1);
    }

    public Bounds(@MapsTo(value="ul") Bound ul, @MapsTo(value="lr") Bound lr) {
        this.ul = ul;
        this.lr = lr;
    }

    public Bound getLowerRight() {
        return this.lr;
    }

    public boolean hasLowerRight() {
        return null != this.lr;
    }

    public Bound getUpperLeft() {
        return this.ul;
    }

    public boolean hasUpperLeft() {
        return null != this.ul;
    }

    public void setLowerRight(Bound lr) {
        this.lr = lr;
    }

    public void setUpperLeft(Bound ul) {
        this.ul = ul;
    }

    public double getX() {
        return this.getUpperLeft().getX();
    }

    public double getY() {
        return this.getUpperLeft().getY();
    }

    public double getWidth() {
        return this.getLowerRight().getX() - this.getUpperLeft().getX();
    }

    public double getHeight() {
        return this.getLowerRight().getY() - this.getUpperLeft().getY();
    }

    public String toString() {
        return "UL=" + this.ul + " | LR=" + this.lr;
    }

    public boolean equals(Object o) {
        if (o instanceof Bounds) {
            Bounds other = (Bounds)o;
            return Objects.equals(this.ul, other.ul) && Objects.equals(this.lr, other.lr);
        }
        return false;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes(Objects.hashCode(this.ul), Objects.hashCode(this.lr));
    }
}

