/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.lookup;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.lookup.AbstractLookupRequest;
import org.kie.workbench.common.stunner.core.lookup.AbstractLookupRequestBuilder;
import org.uberfire.backend.vfs.Path;

@Portable
public class VFSLookupRequest
extends AbstractLookupRequest {
    public static final String CRITERIA_PATH = "path";
    private final Path path;

    public VFSLookupRequest(@MapsTo(value="path") Path path, @MapsTo(value="criteria") String criteria, @MapsTo(value="page") int page, @MapsTo(value="pageSize") int pageSize) {
        super(criteria, page, pageSize);
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    @NonPortable
    public static class Builder
    extends AbstractLookupRequestBuilder<Builder> {
        private Path path;
        private final StringBuilder criteria = new StringBuilder();

        public Builder forPath(Path path) {
            this.criteria.append(this.fromKeyValue(VFSLookupRequest.CRITERIA_PATH, path.toURI()));
            this.path = path;
            return this;
        }

        public VFSLookupRequest build() {
            PortablePreconditions.checkNotNull((String)VFSLookupRequest.CRITERIA_PATH, (Object)this.path);
            return new VFSLookupRequest(this.path, this.getCriteria(), this.page, this.pageSize);
        }

        public String getCriteria() {
            return this.criteria.toString();
        }

        public Path getPath() {
            return this.path;
        }
    }
}

