/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend;

import java.util.Collections;
import java.util.HashMap;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.DocumentRoot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.BaseDirectDiagramMarshaller;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefinitionsHandlerTest {
    @Mock
    private DocumentRoot documentRoot;
    @Mock
    private Definitions definitions;

    @Before
    public void setUp() {
        Mockito.when((Object)this.documentRoot.getDefinitions()).thenReturn((Object)this.definitions);
    }

    @Test
    public void testIsJbpmn1() {
        this.testWithExporterValue("jBPM", true);
        this.testWithExporterValue("JBPM", true);
        this.testWithExporterValue("jbpm", true);
    }

    @Test
    public void testIsNotJbpmn1() {
        this.testWithExporterValue("aris", false);
        this.testWithExporterValue("camunda", false);
        this.testWithExporterValue("other", false);
    }

    private void testWithExporterValue(String exporter, boolean expectedResult) {
        Mockito.when((Object)this.definitions.getExporter()).thenReturn((Object)exporter);
        BaseDirectDiagramMarshaller.DefinitionsHandler handler = new BaseDirectDiagramMarshaller.DefinitionsHandler(this.documentRoot);
        Assert.assertEquals((Object)expectedResult, (Object)handler.isJbpm());
    }

    @Test
    public void testIsJbpm2() {
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        prefixMap.put("someKey", "http://www.jboss.org/drools");
        Mockito.when((Object)this.documentRoot.getXMLNSPrefixMap()).thenReturn(prefixMap);
        BaseDirectDiagramMarshaller.DefinitionsHandler handler = new BaseDirectDiagramMarshaller.DefinitionsHandler(this.documentRoot);
        Assert.assertTrue((boolean)handler.isJbpm());
    }

    @Test
    public void testIsJbpm3() {
        HashMap<String, String> schemaLocation = new HashMap<String, String>();
        schemaLocation.put("http://www.jboss.org/drools", "someLocation");
        Mockito.when((Object)this.documentRoot.getXSISchemaLocation()).thenReturn(schemaLocation);
        BaseDirectDiagramMarshaller.DefinitionsHandler handler = new BaseDirectDiagramMarshaller.DefinitionsHandler(this.documentRoot);
        Assert.assertTrue((boolean)handler.isJbpm());
    }

    @Test
    public void testIsNoJbpm2() {
        Mockito.when((Object)this.documentRoot.getXMLNSPrefixMap()).thenReturn(Collections.emptyMap());
        Mockito.when((Object)this.documentRoot.getXSISchemaLocation()).thenReturn(Collections.emptyMap());
        BaseDirectDiagramMarshaller.DefinitionsHandler handler = new BaseDirectDiagramMarshaller.DefinitionsHandler(this.documentRoot);
        Assert.assertFalse((boolean)handler.isJbpm());
    }
}

