/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.textannotation;

import org.eclipse.bpmn2.TextAnnotation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.TextAnnotationPropertyWriter;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.textannotation.TextAnnotationConverter;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TextAnnotationConverterTest {
    public static final String NAME = "name";
    public static final String DOC = "doc";
    private TextAnnotationConverter tested;
    @Mock
    private PropertyWriterFactory propertyWriterFactory;
    private Node<View<org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation>, ?> node;
    @Mock
    private View<org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation> textAnnotationView;
    private org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation textAnnotation;
    @Mock
    private TextAnnotationPropertyWriter writer;

    @Before
    public void setUp() {
        this.textAnnotation = new org.kie.workbench.common.stunner.bpmn.definition.TextAnnotation();
        this.textAnnotation.getGeneral().getDocumentation().setValue(DOC);
        this.textAnnotation.getGeneral().getName().setValue(NAME);
        this.node = new NodeImpl(UUID.uuid());
        this.node.setContent(this.textAnnotationView);
        Mockito.when((Object)this.textAnnotationView.getDefinition()).thenReturn((Object)this.textAnnotation);
        Mockito.when((Object)this.propertyWriterFactory.of((TextAnnotation)Matchers.any(TextAnnotation.class))).thenReturn((Object)this.writer);
        this.tested = new TextAnnotationConverter(this.propertyWriterFactory);
    }

    @Test
    public void toElement() {
        PropertyWriter propertyWriter = this.tested.toElement(this.node);
        ((TextAnnotationPropertyWriter)Mockito.verify((Object)this.writer)).setName(NAME);
        ((TextAnnotationPropertyWriter)Mockito.verify((Object)this.writer)).setDocumentation(DOC);
        ((TextAnnotationPropertyWriter)Mockito.verify((Object)this.writer)).setAbsoluteBounds(this.node);
        Assert.assertEquals((Object)this.writer, (Object)propertyWriter);
    }
}

