/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.SignalEventDefinition;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.dd.dc.Bounds;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TestUtils;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.BoundaryEventPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.CatchEventPropertyReaderTest;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.EventPropertyReader;
import org.mockito.Mock;
import org.mockito.Mockito;

public class BoundaryEventPropertyReaderTest
extends CatchEventPropertyReaderTest {
    private static final String DOCKER_INFO_METADATA_ELEMENT_NAME = "dockerinfo";
    private static final String DOCKER_INFO_VALUE = "1.0^2.0|";
    private static final float ACTIVITY_X = 100.0f;
    private static final float ACTIVITY_Y = 150.0f;
    float ACTIVITY_WIDTH = 100.0f;
    float ACTIVITY_HEIGHT = 200.0f;
    @Mock
    private BoundaryEvent boundaryEvent;

    @Override
    public void setUp() {
        FeatureMap featureMap = (FeatureMap)Mockito.mock(FeatureMap.class);
        FeatureMap.Entry entry = TestUtils.mockFeatureMapEntry(DOCKER_INFO_METADATA_ELEMENT_NAME, DOCKER_INFO_VALUE);
        Stream<FeatureMap.Entry> entries = Stream.of(entry);
        Mockito.when((Object)featureMap.stream()).thenReturn(entries);
        Mockito.when((Object)this.boundaryEvent.getAnyAttribute()).thenReturn((Object)featureMap);
        super.setUp();
    }

    @Override
    protected EventPropertyReader newPropertyReader() {
        return new BoundaryEventPropertyReader(this.boundaryEvent, this.diagram, this.definitionResolver);
    }

    @Override
    protected void setSignalEventDefinitionOnCurrentMock(SignalEventDefinition eventDefinition) {
        List<SignalEventDefinition> eventDefinitions = Collections.singletonList(eventDefinition);
        Mockito.when((Object)this.boundaryEvent.getEventDefinitions()).thenReturn(eventDefinitions);
        Mockito.when((Object)this.boundaryEvent.getEventDefinitionRefs()).thenReturn((Object)Collections.EMPTY_LIST);
    }

    @Test
    public void testComputeBoundsWhenNoDockerInfoEventOnTop() {
        float eventX = 140.0f;
        float eventY = 122.0f;
        this.testComputeBoundsWhenNoDockerInfo(eventX, eventY, Double.valueOf((double)eventX * 1234.0 - 123400.0).floatValue(), Double.valueOf(-28.0).floatValue());
    }

    @Test
    public void testComputeBoundsWhenNoDockerInfoEventOnRight() {
        float eventX = 100.0f + this.ACTIVITY_WIDTH - 28.0f;
        float eventY = 190.0f;
        this.testComputeBoundsWhenNoDockerInfo(eventX, eventY, Double.valueOf((double)eventX * 1234.0 - 123400.0).floatValue(), Double.valueOf((double)eventY * 1234.0 - 185100.0).floatValue());
    }

    @Test
    public void testComputeBoundsWhenNoDockerInfoEventOnBottom() {
        float eventX = 140.0f;
        float eventY = 150.0f + this.ACTIVITY_WIDTH - 28.0f;
        this.testComputeBoundsWhenNoDockerInfo(eventX, eventY, Double.valueOf((double)eventX * 1234.0 - 123400.0).floatValue(), Double.valueOf((double)eventY * 1234.0 - 185100.0).floatValue());
    }

    @Test
    public void testComputeBoundsWhenNoDockerInfoEventOnLeft() {
        float eventX = 72.0f;
        float eventY = 190.0f;
        this.testComputeBoundsWhenNoDockerInfo(eventX, eventY, Double.valueOf(-28.0).floatValue(), Double.valueOf((double)eventY * 1234.0 - 185100.0).floatValue());
    }

    private void testComputeBoundsWhenNoDockerInfo(float eventX, float eventY, float expectedX, float expectedY) {
        FeatureMap featureMap = (FeatureMap)Mockito.mock(FeatureMap.class);
        ArrayList entries = new ArrayList();
        Mockito.when((Object)featureMap.stream()).thenReturn(entries.stream());
        Mockito.when((Object)this.boundaryEvent.getAnyAttribute()).thenReturn((Object)featureMap);
        String activityId = "activityId";
        Activity sourceActivity = (Activity)Mockito.mock(Activity.class);
        BPMNShape sourceActivityShape = (BPMNShape)Mockito.mock(BPMNShape.class);
        Bounds activityBounds = TestUtils.mockBounds(100.0f, 150.0f, this.ACTIVITY_WIDTH, this.ACTIVITY_HEIGHT);
        Mockito.when((Object)sourceActivity.getId()).thenReturn((Object)activityId);
        Mockito.when((Object)sourceActivityShape.getBounds()).thenReturn((Object)activityBounds);
        Mockito.when((Object)this.definitionResolver.getShape(activityId)).thenReturn((Object)sourceActivityShape);
        Mockito.when((Object)this.definitionResolver.getResolutionFactor()).thenReturn((Object)1.0);
        Mockito.when((Object)this.boundaryEvent.getAttachedToRef()).thenReturn((Object)sourceActivity);
        float eventWidth = 56.0f;
        float eventHeight = 56.0f;
        Bounds eventBounds = TestUtils.mockBounds(eventX, eventY, eventWidth, eventHeight);
        org.kie.workbench.common.stunner.core.graph.content.Bounds result = this.propertyReader.computeBounds(eventBounds);
        Assert.assertEquals((double)expectedX, (double)result.getX(), (double)0.0);
        Assert.assertEquals((double)expectedY, (double)result.getY(), (double)0.0);
    }

    @Override
    protected Event getCurrentEventMock() {
        return this.boundaryEvent;
    }
}

