/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.events.EndEventTest;
import org.kie.workbench.common.stunner.bpmn.definition.EndEscalationEvent;
import org.kie.workbench.common.stunner.bpmn.definition.property.event.escalation.EscalationEventExecutionSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class EndEscalationEventTest
extends EndEventTest<EndEscalationEvent> {
    private static final String BPMN_END_EVENT_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/endEscalationEvents.bpmn";
    private static final String EMPTY_TOP_LEVEL_EVENT_ID = "_F666187F-57FF-40C6-8337-7EAB9F02F58D";
    private static final String FILLED_TOP_LEVEL_EVENT_ID = "_99A5499F-FF6B-440B-83B5-256B7DAEC7A4";
    private static final String EMPTY_SUBPROCESS_LEVEL_EVENT_ID = "_A695D9E9-0CA4-4B1F-8982-C34734D7AB89";
    private static final String FILLED_SUBPROCESS_LEVEL_EVENT_ID = "_04E66211-0445-492E-830B-D20209E10CA8";
    private static final String EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID = "_22884D47-0B31-441D-A744-ED70AAFD0245";
    private static final String FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID = "_DA67C887-2A9C-4C01-AD02-6CD326378456";
    private static final String EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID = "_777E309C-04B8-4777-A0E1-DC0CEA537B88";
    private static final String FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID = "_3933F591-35FA-45A7-84DB-7DCE49FF87B7";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 14;

    @Override
    @Test
    public void testUnmarshallTopLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escEv01";
        String EVENT_DATA_OUTPUT = "input:String||||[din]processGlobalVar->input";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndEscalationEvent filledTopEvent = (EndEscalationEvent)this.getEndNodeById(diagram, FILLED_TOP_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(filledTopEvent.getGeneral(), "Escalation event01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledTopEvent.getExecutionSet(), "escEv01");
        this.assertDataIOSet(filledTopEvent.getDataIOSet(), "input:String||||[din]processGlobalVar->input");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyEventProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndEscalationEvent emptyTopEvent = (EndEscalationEvent)this.getEndNodeById(diagram, EMPTY_TOP_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptyTopEvent.getGeneral(), "", "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escEv03";
        String EVENT_DATA_OUTPUT = "input:String||||[din]processGlobalVar->input";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndEscalationEvent filledSubprocessEvent = (EndEscalationEvent)this.getEndNodeById(diagram, FILLED_SUBPROCESS_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Escalation event03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "escEv03");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "input:String||||[din]processGlobalVar->input");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndEscalationEvent emptySubprocessEvent = (EndEscalationEvent)this.getEndNodeById(diagram, EMPTY_SUBPROCESS_LEVEL_EVENT_ID, false);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escEv02";
        String EVENT_DATA_OUTPUT = "input:String||||[din]processGlobalVar->input";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndEscalationEvent filledSubprocessEvent = (EndEscalationEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Escalation event02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "escEv02");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "input:String||||[din]processGlobalVar->input");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndEscalationEvent emptyEvent = (EndEscalationEvent)this.getEndNodeById(diagram, EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptyEvent.getGeneral(), "", "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeEmptyProperties() throws Exception {
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndEscalationEvent emptySubprocessEvent = (EndEscalationEvent)this.getEndNodeById(diagram, EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(emptySubprocessEvent.getGeneral(), "", "");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelEventWithIncomeFilledProperties() throws Exception {
        String EVENT_NAME = "Escalation event04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String EVENT_DOCUMENTATION = "Escalation event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String EVENT_REF = "escEv04";
        String EVENT_DATA_OUTPUT = "input:String||||[din]processGlobalVar->input";
        Diagram<Graph, Metadata> diagram = this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, BPMN_END_EVENT_FILE_PATH);
        this.assertDiagram(diagram, 14);
        EndEscalationEvent filledSubprocessEvent = (EndEscalationEvent)this.getEndNodeById(diagram, FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID, true);
        this.assertGeneralSet(filledSubprocessEvent.getGeneral(), "Escalation event04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Escalation event04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertEscalationEventExecutionSet(filledSubprocessEvent.getExecutionSet(), "escEv04");
        this.assertDataIOSet(filledSubprocessEvent.getDataIOSet(), "input:String||||[din]processGlobalVar->input");
    }

    @Override
    String getBpmnEndEventFilePath() {
        return BPMN_END_EVENT_FILE_PATH;
    }

    @Override
    Class<EndEscalationEvent> getEndEventType() {
        return EndEscalationEvent.class;
    }

    @Override
    String getFilledTopLevelEventId() {
        return FILLED_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventId() {
        return EMPTY_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventId() {
        return FILLED_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventId() {
        return EMPTY_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledTopLevelEventWithIncomeId() {
        return FILLED_WITH_INCOME_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptyTopLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_TOP_LEVEL_EVENT_ID;
    }

    @Override
    String getFilledSubprocessLevelEventWithIncomeId() {
        return FILLED_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID;
    }

    @Override
    String getEmptySubprocessLevelEventWithIncomeId() {
        return EMPTY_WITH_INCOME_SUBPROCESS_LEVEL_EVENT_ID;
    }

    private void assertEscalationEventExecutionSet(EscalationEventExecutionSet executionSet, String escalationRef) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getEscalationRef());
        Assert.assertEquals((Object)escalationRef, (Object)executionSet.getEscalationRef().getValue());
    }
}

