/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.subprocesses;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.subprocesses.SubProcessTest;
import org.kie.workbench.common.stunner.bpmn.definition.AdHocSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class AdHocSubProcessTest
extends SubProcessTest<AdHocSubprocess> {
    private static final String BPMN_SUB_PROCESS_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/adHocSubProcesses.bpmn";
    private static final String TOP_LEVEL_EMPTY_SUBPROCESS_ID = "_C13AA1A1-8AA5-4F37-821D-616953802599";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_JAVA_ID = "_7FBF0C49-8268-495A-98D9-44CA6D34BE96";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID = "_6F38D400-A187-4845-BA2D-CACEFA63013A";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_MVEL_ID = "_752AED87-C2E8-4E62-8DA1-2FC831F4EA7E";
    private static final String SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID = "_41EBC350-8CF6-4781-84BE-A54A647C779A";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVA_ID = "_F9AD8287-3BD1-4D8E-9888-6524F1E8079C";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID = "_06F7FACD-7F14-4B88-9DF0-30C3D4F859B0";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_MVEL_ID = "_336E3C64-942E-47F9-894F-E15BAF72D514";
    private static final String TOP_LEVEL_SUBPROCESS_WITH_EDGES = "_22F2BA2D-7AA3-4924-973A-452C379E563A";
    private static final String SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES = "_D14DA50A-FA9F-4EE3-A06B-F7F35A923CEE";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 23;
    private static final String ADHOC_COMPLETION_CONDITION_SCRIPT_DEFAULT = "autocomplete";
    private static final String ADHOC_COMPLETION_CONDITION_SCRIPT = "org.kie.api.runtime.process.CaseData(data.get(\"someData\") == true)";
    private static final String ADHOC_COMPLETION_CONDITION_LANGUAGE_MVEL = "mvel";
    private static final String ADHOC_COMPLETION_CONDITION_LANGUAGE_DROOLS = "drools";
    private static final String ADHOC_ORDERING_SEQUENTIAL = "Sequential";
    private static final String ADHOC_ORDERING_PARALLEL = "Parallel";
    private static final String SUBPROCESS_SCRIPT_JAVA_LANGUAGE = "java";
    private static final String SUBPROCESS_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SUBPROCESS_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE = "javascript";
    private static final String SUBPROCESS_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action\");\nprint(\"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");\nprint(\"somevalue\" + \"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");";
    private static final String SUBPROCESS_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action\");\nprint(\"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");\nprint(\"somevalue\" + \"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");";
    private static final String SUBPROCESS_SCRIPT_MVEL_LANGUAGE = "mvel";
    private static final String SUBPROCESS_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SUBPROCESS_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SLA_DUE_DATE = "12/25/1983";

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyPropertiesSubProcess() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        AdHocSubprocess topLevelSubProcess = (AdHocSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_EMPTY_SUBPROCESS_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcess.getGeneral(), "", "");
        this.assertAdHocSubProcessExecutionSet(topLevelSubProcess.getExecutionSet(), "", "mvel", ADHOC_ORDERING_SEQUENTIAL, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, false, "");
        this.assertSubProcessProcessData(topLevelSubProcess.getProcessData(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelFilledPropertiesSubProcess() {
        String SUB_PROCESS_NAME_JAVA = "Ad-hoc sub-process01 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_JAVA = "Ad-hoc sub-process01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_NAME_JAVASCRIPT = "Ad-hoc sub-process02 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_JAVASCRIPT = "Ad-hoc sub-process02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_NAME_MVEL = "Ad-hoc sub-process03 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_MVEL = "Ad-hoc sub-process03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_VARIABLES_JAVA = "subVar01:String:false";
        String SUB_PROCESS_VARIABLES_JAVASCRIPT = "subVar02:String:false";
        String SUB_PROCESS_VARIABLES_MVEL = "subVarString:String:false,subVarCustom:CustomType:false,subVarBoolean:Boolean:false,subVarFloat:Float:false,subVarInteger:Integer:false,subVarObject:Object:false";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        AdHocSubprocess topLevelSubProcessJava = (AdHocSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_JAVA_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessJava.getGeneral(), "Ad-hoc sub-process01 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Ad-hoc sub-process01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertAdHocSubProcessExecutionSet(topLevelSubProcessJava.getExecutionSet(), ADHOC_COMPLETION_CONDITION_SCRIPT_DEFAULT, "mvel", ADHOC_ORDERING_SEQUENTIAL, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, true, SLA_DUE_DATE);
        this.assertSubProcessProcessData(topLevelSubProcessJava.getProcessData(), "subVar01:String:false");
        AdHocSubprocess topLevelSubProcessJavascript = (AdHocSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessJavascript.getGeneral(), "Ad-hoc sub-process02 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Ad-hoc sub-process02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertAdHocSubProcessExecutionSet(topLevelSubProcessJavascript.getExecutionSet(), ADHOC_COMPLETION_CONDITION_SCRIPT, ADHOC_COMPLETION_CONDITION_LANGUAGE_DROOLS, ADHOC_ORDERING_PARALLEL, SUBPROCESS_ON_ENTRY_ACTION_JAVASCRIPT, SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE, SUBPROCESS_ON_EXIT_ACTION_JAVASCRIPT, SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE, true, SLA_DUE_DATE);
        this.assertSubProcessProcessData(topLevelSubProcessJavascript.getProcessData(), "subVar02:String:false");
        AdHocSubprocess topLevelSubProcessMVEL = (AdHocSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_MVEL_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessMVEL.getGeneral(), "Ad-hoc sub-process03 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Ad-hoc sub-process03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertAdHocSubProcessExecutionSet(topLevelSubProcessMVEL.getExecutionSet(), ADHOC_COMPLETION_CONDITION_SCRIPT_DEFAULT, "mvel", ADHOC_ORDERING_SEQUENTIAL, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", "mvel", "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", "mvel", true, SLA_DUE_DATE);
        this.assertSubProcessProcessData(topLevelSubProcessMVEL.getProcessData(), "subVarString:String:false,subVarCustom:CustomType:false,subVarBoolean:Boolean:false,subVarFloat:Float:false,subVarInteger:Integer:false,subVarObject:Object:false");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelSubProcessWithEdges() {
        String SUB_PROCESS_NAME = "Sub-process07";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        AdHocSubprocess topLevelSubProcess = (AdHocSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_SUBPROCESS_WITH_EDGES, 2, 4);
        this.assertGeneralSet(topLevelSubProcess.getGeneral(), "Sub-process07", "");
        this.assertAdHocSubProcessExecutionSet(topLevelSubProcess.getExecutionSet(), ADHOC_COMPLETION_CONDITION_SCRIPT_DEFAULT, "mvel", ADHOC_ORDERING_SEQUENTIAL, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, false, "");
        this.assertSubProcessProcessData(topLevelSubProcess.getProcessData(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelEmptyPropertiesSubProcess() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        AdHocSubprocess subProcessLevelSubProcess = (AdHocSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcess.getGeneral(), "", "");
        this.assertAdHocSubProcessExecutionSet(subProcessLevelSubProcess.getExecutionSet(), "", "mvel", ADHOC_ORDERING_SEQUENTIAL, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, false, "");
        this.assertSubProcessProcessData(subProcessLevelSubProcess.getProcessData(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelFilledPropertiesSubProcess() {
        String SUB_PROCESS_NAME_JAVA = "Ad-hoc sub-process04 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_JAVA = "Ad-hoc sub-process04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_NAME_JAVASCRIPT = "Ad-hoc sub-process05 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_JAVASCRIPT = "Ad-hoc sub-process05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_NAME_MVEL = "Ad-hoc sub-process06 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_MVEL = "Ad-hoc sub-process06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_VARIABLES_JAVA = "subVar04:String:false";
        String SUB_PROCESS_VARIABLES_JAVASCRIPT = "subVar05:String:false";
        String SUB_PROCESS_VARIABLES_MVEL = "subVarString:String:false,subVarCustom:CustomType:false,subVarBoolean:Boolean:false,subVarFloat:Float:false,subVarInteger:Integer:false,subVarObject:Object:false";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        AdHocSubprocess subProcessLevelSubProcessJava = (AdHocSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVA_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessJava.getGeneral(), "Ad-hoc sub-process04 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Ad-hoc sub-process04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertAdHocSubProcessExecutionSet(subProcessLevelSubProcessJava.getExecutionSet(), ADHOC_COMPLETION_CONDITION_SCRIPT_DEFAULT, "mvel", ADHOC_ORDERING_SEQUENTIAL, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, true, SLA_DUE_DATE);
        this.assertSubProcessProcessData(subProcessLevelSubProcessJava.getProcessData(), "subVar04:String:false");
        AdHocSubprocess subProcessLevelSubProcessJavascript = (AdHocSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessJavascript.getGeneral(), "Ad-hoc sub-process05 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Ad-hoc sub-process05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertAdHocSubProcessExecutionSet(subProcessLevelSubProcessJavascript.getExecutionSet(), ADHOC_COMPLETION_CONDITION_SCRIPT, ADHOC_COMPLETION_CONDITION_LANGUAGE_DROOLS, ADHOC_ORDERING_PARALLEL, SUBPROCESS_ON_ENTRY_ACTION_JAVASCRIPT, SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE, SUBPROCESS_ON_EXIT_ACTION_JAVASCRIPT, SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE, true, SLA_DUE_DATE);
        this.assertSubProcessProcessData(subProcessLevelSubProcessJavascript.getProcessData(), "subVar05:String:false");
        AdHocSubprocess subProcessLevelSubProcessMVEL = (AdHocSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_MVEL_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessMVEL.getGeneral(), "Ad-hoc sub-process06 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Ad-hoc sub-process06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertAdHocSubProcessExecutionSet(subProcessLevelSubProcessMVEL.getExecutionSet(), ADHOC_COMPLETION_CONDITION_SCRIPT_DEFAULT, "mvel", ADHOC_ORDERING_SEQUENTIAL, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", "mvel", "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", "mvel", true, SLA_DUE_DATE);
        this.assertSubProcessProcessData(subProcessLevelSubProcessMVEL.getProcessData(), "subVarString:String:false,subVarCustom:CustomType:false,subVarBoolean:Boolean:false,subVarFloat:Float:false,subVarInteger:Integer:false,subVarObject:Object:false");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelSubProcessWithEdges() {
        String SUB_PROCESS_NAME = "Sub-process08";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        AdHocSubprocess subProcessLevelSubProcess = (AdHocSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES, 2, 4);
        this.assertGeneralSet(subProcessLevelSubProcess.getGeneral(), "Sub-process08", "");
        this.assertAdHocSubProcessExecutionSet(subProcessLevelSubProcess.getExecutionSet(), ADHOC_COMPLETION_CONDITION_SCRIPT_DEFAULT, "mvel", ADHOC_ORDERING_SEQUENTIAL, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, false, "");
        this.assertSubProcessProcessData(subProcessLevelSubProcess.getProcessData(), "");
    }

    @Override
    Class<AdHocSubprocess> getSubProcessType() {
        return AdHocSubprocess.class;
    }

    @Override
    String getBpmnSubProcessFilePath() {
        return BPMN_SUB_PROCESS_FILE_PATH;
    }

    @Override
    String getTopLevelEmptyPropertiesSubProcessId() {
        return TOP_LEVEL_EMPTY_SUBPROCESS_ID;
    }

    @Override
    String[] getTopLevelFilledPropertiesSubProcessesIds() {
        return new String[]{TOP_LEVEL_FILLED_SUBPROCESS_JAVA_ID, TOP_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, TOP_LEVEL_FILLED_SUBPROCESS_MVEL_ID};
    }

    @Override
    String getTopLevelSubProcessWithEdgesId() {
        return TOP_LEVEL_SUBPROCESS_WITH_EDGES;
    }

    @Override
    String getSubProcessLevelEmptyPropertiesSubProcessId() {
        return SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID;
    }

    @Override
    String[] getSubProcessLevelFilledPropertiesSubProcessesIds() {
        return new String[]{SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVA_ID, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_MVEL_ID};
    }

    @Override
    String getSubProcessLevelSubProcessWithEdgesId() {
        return SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES;
    }

    private void assertAdHocSubProcessExecutionSet(AdHocSubprocessTaskExecutionSet executionSet, String adHocCompletionConditionScript, String adHocCompletionConditionLanguage, String adHocOrdering, String onEntryActionScriptValue, String onEntryActionScriptLanguage, String onExitActionScriptValue, String onExitActionScriptLanguage, Boolean isAsync, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getAdHocCompletionCondition()).isNotNull();
        Assertions.assertThat((Object)executionSet.getAdHocCompletionCondition().getValue()).isNotNull();
        Assertions.assertThat((Object)executionSet.getAdHocOrdering()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnEntryAction()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnExitAction()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnEntryAction().getValue()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnExitAction().getValue()).isNotNull();
        List onEntryScriptTypeValues = executionSet.getOnEntryAction().getValue().getValues();
        List onExitScriptTypeValues = executionSet.getOnExitAction().getValue().getValues();
        Assertions.assertThat((List)onEntryScriptTypeValues).isNotNull();
        Assertions.assertThat((List)onExitScriptTypeValues).isNotNull();
        Assertions.assertThat(onEntryScriptTypeValues.get(0)).isNotNull();
        Assertions.assertThat(onExitScriptTypeValues.get(0)).isNotNull();
        Assertions.assertThat((String)executionSet.getAdHocCompletionCondition().getValue().getScript()).isEqualTo(adHocCompletionConditionScript);
        Assertions.assertThat((String)executionSet.getAdHocCompletionCondition().getValue().getLanguage()).isEqualTo(adHocCompletionConditionLanguage);
        Assertions.assertThat((String)executionSet.getAdHocOrdering().getValue()).isEqualTo(adHocOrdering);
        Assertions.assertThat((String)((ScriptTypeValue)onEntryScriptTypeValues.get(0)).getScript()).isEqualTo(onEntryActionScriptValue);
        Assertions.assertThat((String)((ScriptTypeValue)onEntryScriptTypeValues.get(0)).getLanguage()).isEqualTo(onEntryActionScriptLanguage);
        Assertions.assertThat((String)((ScriptTypeValue)onExitScriptTypeValues.get(0)).getScript()).isEqualTo(onExitActionScriptValue);
        Assertions.assertThat((String)((ScriptTypeValue)onExitScriptTypeValues.get(0)).getLanguage()).isEqualTo(onExitActionScriptLanguage);
        Assertions.assertThat((Object)executionSet.getSlaDueDate()).isNotNull();
        Assertions.assertThat((String)executionSet.getSlaDueDate().getValue()).isEqualTo(slaDueDate);
        Assertions.assertThat((Object)executionSet.getIsAsync()).isNotNull();
        Assertions.assertThat((Boolean)executionSet.getIsAsync().getValue()).isEqualTo((Object)isAsync);
    }
}

