/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.subprocesses;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.subprocesses.SubProcessTest;
import org.kie.workbench.common.stunner.bpmn.definition.MultipleInstanceSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.MultipleInstanceSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class MultipleInstanceSubProcessTest
extends SubProcessTest<MultipleInstanceSubprocess> {
    private static final String BPMN_SUB_PROCESS_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/multipleInstanceSubProcesses.bpmn";
    private static final String TOP_LEVEL_EMPTY_SUBPROCESS_ID = "_3F304098-64C6-4E53-A653-FDF893D88B3A";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_JAVA_ID = "_BB01C3A5-CEC6-4DE6-A1F7-CC4A8633E4CB";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID = "_F894F69F-A948-446A-A8F2-A072CDF046DD";
    private static final String TOP_LEVEL_FILLED_SUBPROCESS_MVEL_ID = "_AFA1E5FC-9DA4-4BD0-8269-CB99A7D6C3AB";
    private static final String SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID = "_D8C4C140-CFE8-4013-92AF-C72A61CB1D64";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVA_ID = "_98379D8A-1DB6-416E-BFA0-DC4A09A695BD";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID = "_CCD1EB1E-8BEB-471C-BAEE-2965F4C808EC";
    private static final String SUBPROCESS_LEVEL_FILLED_SUBPROCESS_MVEL_ID = "_BFDA818F-F2F2-4902-9707-E4838939B583";
    private static final String TOP_LEVEL_SUBPROCESS_WITH_EDGES = "_3815E005-22BB-44F1-A5DC-387FF966A1BD";
    private static final String SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES = "_8B644D06-C140-4544-9E66-E5C00822411B";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 23;
    private static final String DEFAULT_MULTIPLE_INSTANCE_COLLECTION = null;
    private static final String MULTIPLE_INSTANCE_COLLECTION_INPUT = "miCollectionInput";
    private static final String MULTIPLE_INSTANCE_COLLECTION_OUTPUT = "miCollectionOutput";
    private static final String MULTIPLE_INSTANCE_DATA_INPUT = "collectionItemVarIn:java.lang.Object";
    private static final String MULTIPLE_INSTANCE_DATA_OUTPUT = "collectionItemVarOut:java.lang.Object";
    private static final String MULTIPLE_INSTANCE_COMPLETION_CONDITION = "($ in miCollectionOutput if $ == true).size() == miOutAmountRequired;";
    private static final String SUBPROCESS_SCRIPT_JAVA_LANGUAGE = "java";
    private static final String SUBPROCESS_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SUBPROCESS_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE = "javascript";
    private static final String SUBPROCESS_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action\");\nprint(\"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");\nprint(\"somevalue\" + \"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");";
    private static final String SUBPROCESS_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action\");\nprint(\"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");\nprint(\"somevalue\" + \"~``!@#$%^&*()_+=-{}|\\n\\r][:\\\",.?\");";
    private static final String SUBPROCESS_SCRIPT_MVEL_LANGUAGE = "mvel";
    private static final String SUBPROCESS_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SUBPROCESS_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");";
    private static final String SLA_DUE_DATE = "12/25/1983";

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyPropertiesSubProcess() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        MultipleInstanceSubprocess topLevelSubProcess = (MultipleInstanceSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_EMPTY_SUBPROCESS_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcess.getGeneral(), "", "");
        this.assertMultipleInstanceSubProcessExecutionSet(topLevelSubProcess.getExecutionSet(), DEFAULT_MULTIPLE_INSTANCE_COLLECTION, DEFAULT_MULTIPLE_INSTANCE_COLLECTION, "", "", "", false, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "");
        this.assertSubProcessProcessData(topLevelSubProcess.getProcessData(), "");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelFilledPropertiesSubProcess() {
        String SUB_PROCESS_NAME_JAVA = "Multiple Instance sub-process01 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_JAVA = "Multiple Instance sub-process01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_NAME_JAVASCRIPT = "Multiple Instance sub-process02 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_JAVASCRIPT = "Multiple Instance sub-process02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_NAME_MVEL = "Multiple Instance sub-process03 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_MVEL = "Multiple Instance sub-process03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_VARIABLES_JAVA = "subVar01:String:false";
        String SUB_PROCESS_VARIABLES_JAVASCRIPT = "subVar02:String:false";
        String SUB_PROCESS_VARIABLES_MVEL = "subVarCustom:any.Custom:false,subVarBoolean:Boolean:false,subVarFloat:Float:false,subVarInteger:Integer:false,subVarObject:Object:false,subVarString:String:false";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        MultipleInstanceSubprocess topLevelSubProcessJava = (MultipleInstanceSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_JAVA_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessJava.getGeneral(), "Multiple Instance sub-process01 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Multiple Instance sub-process01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMultipleInstanceSubProcessExecutionSet(topLevelSubProcessJava.getExecutionSet(), MULTIPLE_INSTANCE_COLLECTION_INPUT, MULTIPLE_INSTANCE_COLLECTION_OUTPUT, MULTIPLE_INSTANCE_DATA_INPUT, MULTIPLE_INSTANCE_DATA_OUTPUT, MULTIPLE_INSTANCE_COMPLETION_CONDITION, true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, SLA_DUE_DATE);
        this.assertSubProcessProcessData(topLevelSubProcessJava.getProcessData(), "subVar01:String:false");
        MultipleInstanceSubprocess topLevelSubProcessJavascript = (MultipleInstanceSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessJavascript.getGeneral(), "Multiple Instance sub-process02 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Multiple Instance sub-process02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMultipleInstanceSubProcessExecutionSet(topLevelSubProcessJavascript.getExecutionSet(), MULTIPLE_INSTANCE_COLLECTION_INPUT, MULTIPLE_INSTANCE_COLLECTION_OUTPUT, MULTIPLE_INSTANCE_DATA_INPUT, MULTIPLE_INSTANCE_DATA_OUTPUT, MULTIPLE_INSTANCE_COMPLETION_CONDITION, true, SUBPROCESS_ON_ENTRY_ACTION_JAVASCRIPT, SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE, SUBPROCESS_ON_EXIT_ACTION_JAVASCRIPT, SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE, SLA_DUE_DATE);
        this.assertSubProcessProcessData(topLevelSubProcessJavascript.getProcessData(), "subVar02:String:false");
        MultipleInstanceSubprocess topLevelSubProcessMVEL = (MultipleInstanceSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_FILLED_SUBPROCESS_MVEL_ID, 1, 0);
        this.assertGeneralSet(topLevelSubProcessMVEL.getGeneral(), "Multiple Instance sub-process03 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Multiple Instance sub-process03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMultipleInstanceSubProcessExecutionSet(topLevelSubProcessMVEL.getExecutionSet(), MULTIPLE_INSTANCE_COLLECTION_INPUT, MULTIPLE_INSTANCE_COLLECTION_OUTPUT, MULTIPLE_INSTANCE_DATA_INPUT, MULTIPLE_INSTANCE_DATA_OUTPUT, MULTIPLE_INSTANCE_COMPLETION_CONDITION, true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_MVEL_LANGUAGE, SLA_DUE_DATE);
        this.assertSubProcessProcessData(topLevelSubProcessMVEL.getProcessData(), "subVarCustom:any.Custom:false,subVarBoolean:Boolean:false,subVarFloat:Float:false,subVarInteger:Integer:false,subVarObject:Object:false,subVarString:String:false");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelSubProcessWithEdges() {
        String SUB_PROCESS_NAME = "Multiple Instance Sub-process07";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        MultipleInstanceSubprocess topLevelSubProcess = (MultipleInstanceSubprocess)this.getSubProcessNodeById(diagram, TOP_LEVEL_SUBPROCESS_WITH_EDGES, 2, 4);
        this.assertGeneralSet(topLevelSubProcess.getGeneral(), "Multiple Instance Sub-process07", "");
        this.assertMultipleInstanceSubProcessExecutionSet(topLevelSubProcess.getExecutionSet(), DEFAULT_MULTIPLE_INSTANCE_COLLECTION, DEFAULT_MULTIPLE_INSTANCE_COLLECTION, "", "", "", false, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "");
        this.assertSubProcessProcessData(topLevelSubProcess.getProcessData(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelEmptyPropertiesSubProcess() {
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        MultipleInstanceSubprocess subProcessLevelSubProcess = (MultipleInstanceSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcess.getGeneral(), "", "");
        this.assertMultipleInstanceSubProcessExecutionSet(subProcessLevelSubProcess.getExecutionSet(), DEFAULT_MULTIPLE_INSTANCE_COLLECTION, DEFAULT_MULTIPLE_INSTANCE_COLLECTION, "", "", "", false, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "");
        this.assertSubProcessProcessData(subProcessLevelSubProcess.getProcessData(), "");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelFilledPropertiesSubProcess() {
        String SUB_PROCESS_NAME_JAVA = "Multiple Instance sub-process04 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_JAVA = "Multiple Instance sub-process04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_NAME_JAVASCRIPT = "Multiple Instance sub-process05 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_JAVASCRIPT = "Multiple Instance sub-process05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_NAME_MVEL = "Multiple Instance sub-process06 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_DOCUMENTATION_MVEL = "Multiple Instance sub-process06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String SUB_PROCESS_VARIABLES_JAVA = "subVar04:String:false";
        String SUB_PROCESS_VARIABLES_JAVASCRIPT = "subVar05:String:false";
        String SUB_PROCESS_VARIABLES_MVEL = "subVarCustom:any.Custom:false,subVarBoolean:Boolean:false,subVarFloat:Float:false,subVarInteger:Integer:false,subVarObject:Object:false,subVarString:String:false";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        MultipleInstanceSubprocess subProcessLevelSubProcessJava = (MultipleInstanceSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVA_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessJava.getGeneral(), "Multiple Instance sub-process04 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Multiple Instance sub-process04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMultipleInstanceSubProcessExecutionSet(subProcessLevelSubProcessJava.getExecutionSet(), MULTIPLE_INSTANCE_COLLECTION_INPUT, MULTIPLE_INSTANCE_COLLECTION_OUTPUT, MULTIPLE_INSTANCE_DATA_INPUT, MULTIPLE_INSTANCE_DATA_OUTPUT, MULTIPLE_INSTANCE_COMPLETION_CONDITION, true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, SLA_DUE_DATE);
        this.assertSubProcessProcessData(subProcessLevelSubProcessJava.getProcessData(), "subVar04:String:false");
        MultipleInstanceSubprocess subProcessLevelSubProcessJavascript = (MultipleInstanceSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessJavascript.getGeneral(), "Multiple Instance sub-process05 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Multiple Instance sub-process05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMultipleInstanceSubProcessExecutionSet(subProcessLevelSubProcessJavascript.getExecutionSet(), MULTIPLE_INSTANCE_COLLECTION_INPUT, MULTIPLE_INSTANCE_COLLECTION_OUTPUT, MULTIPLE_INSTANCE_DATA_INPUT, MULTIPLE_INSTANCE_DATA_OUTPUT, MULTIPLE_INSTANCE_COMPLETION_CONDITION, true, SUBPROCESS_ON_ENTRY_ACTION_JAVASCRIPT, SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE, SUBPROCESS_ON_EXIT_ACTION_JAVASCRIPT, SUBPROCESS_SCRIPT_JAVASCRIPT_LANGUAGE, SLA_DUE_DATE);
        this.assertSubProcessProcessData(subProcessLevelSubProcessJavascript.getProcessData(), "subVar05:String:false");
        MultipleInstanceSubprocess subProcessLevelSubProcessMVEL = (MultipleInstanceSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_MVEL_ID, 1, 0);
        this.assertGeneralSet(subProcessLevelSubProcessMVEL.getGeneral(), "Multiple Instance sub-process06 name ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./", "Multiple Instance sub-process06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertMultipleInstanceSubProcessExecutionSet(subProcessLevelSubProcessMVEL.getExecutionSet(), MULTIPLE_INSTANCE_COLLECTION_INPUT, MULTIPLE_INSTANCE_COLLECTION_OUTPUT, MULTIPLE_INSTANCE_DATA_INPUT, MULTIPLE_INSTANCE_DATA_OUTPUT, MULTIPLE_INSTANCE_COMPLETION_CONDITION, true, "System.out.println(\"On Entry Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action\");\nSystem.out.println(\"`&(^*&^(\\n\\r\");\nObject o = kcontext.getVariable(\"hello_world\");", SUBPROCESS_SCRIPT_MVEL_LANGUAGE, SLA_DUE_DATE);
        this.assertSubProcessProcessData(subProcessLevelSubProcessMVEL.getProcessData(), "subVarCustom:any.Custom:false,subVarBoolean:Boolean:false,subVarFloat:Float:false,subVarInteger:Integer:false,subVarObject:Object:false,subVarString:String:false");
    }

    @Override
    @Test
    public void testUnmarshallSubProcessLevelSubProcessWithEdges() {
        String SUB_PROCESS_NAME = "Multiple Instance Sub-process08";
        Diagram<Graph, Metadata> diagram = this.getDiagram();
        this.assertDiagram(diagram, 23);
        MultipleInstanceSubprocess subProcessLevelSubProcess = (MultipleInstanceSubprocess)this.getSubProcessNodeById(diagram, SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES, 2, 4);
        this.assertGeneralSet(subProcessLevelSubProcess.getGeneral(), "Multiple Instance Sub-process08", "");
        this.assertMultipleInstanceSubProcessExecutionSet(subProcessLevelSubProcess.getExecutionSet(), DEFAULT_MULTIPLE_INSTANCE_COLLECTION, DEFAULT_MULTIPLE_INSTANCE_COLLECTION, "", "", "", false, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "", SUBPROCESS_SCRIPT_JAVA_LANGUAGE, "");
        this.assertSubProcessProcessData(subProcessLevelSubProcess.getProcessData(), "");
    }

    @Override
    Class<MultipleInstanceSubprocess> getSubProcessType() {
        return MultipleInstanceSubprocess.class;
    }

    @Override
    String getBpmnSubProcessFilePath() {
        return BPMN_SUB_PROCESS_FILE_PATH;
    }

    @Override
    String getTopLevelEmptyPropertiesSubProcessId() {
        return TOP_LEVEL_EMPTY_SUBPROCESS_ID;
    }

    @Override
    String[] getTopLevelFilledPropertiesSubProcessesIds() {
        return new String[]{TOP_LEVEL_FILLED_SUBPROCESS_JAVA_ID, TOP_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, TOP_LEVEL_FILLED_SUBPROCESS_MVEL_ID};
    }

    @Override
    String getTopLevelSubProcessWithEdgesId() {
        return TOP_LEVEL_SUBPROCESS_WITH_EDGES;
    }

    @Override
    String getSubProcessLevelEmptyPropertiesSubProcessId() {
        return SUBPROCESS_LEVEL_EMPTY_SUBPROCESS_ID;
    }

    @Override
    String[] getSubProcessLevelFilledPropertiesSubProcessesIds() {
        return new String[]{SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVA_ID, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_JAVASCRIPT_ID, SUBPROCESS_LEVEL_FILLED_SUBPROCESS_MVEL_ID};
    }

    @Override
    String getSubProcessLevelSubProcessWithEdgesId() {
        return SUBPROCESS_LEVEL_SUBPROCESS_WITH_EDGES;
    }

    private void assertMultipleInstanceSubProcessExecutionSet(MultipleInstanceSubprocessTaskExecutionSet executionSet, String multipleInstanceCollectionInput, String multipleInstanceCollectionOutput, String multipleInstanceDataInput, String multipleInstanceDataOutput, String multipleInstanceCompletionCondition, boolean isAsync, String onEntryActionScriptValue, String onEntryActionScriptLanguage, String onExitActionScriptValue, String onExitActionScriptLanguage, String slaDueDate) {
        Assertions.assertThat((Object)executionSet).isNotNull();
        Assertions.assertThat((Object)executionSet.getMultipleInstanceCollectionInput()).isNotNull();
        Assertions.assertThat((Object)executionSet.getMultipleInstanceCollectionOutput()).isNotNull();
        Assertions.assertThat((Object)executionSet.getMultipleInstanceDataInput()).isNotNull();
        Assertions.assertThat((Object)executionSet.getMultipleInstanceDataOutput()).isNotNull();
        Assertions.assertThat((Object)executionSet.getMultipleInstanceCompletionCondition()).isNotNull();
        Assertions.assertThat((Object)executionSet.getIsAsync()).isNotNull();
        Assertions.assertThat((Object)executionSet.getSlaDueDate()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnEntryAction()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnExitAction()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnEntryAction().getValue()).isNotNull();
        Assertions.assertThat((Object)executionSet.getOnExitAction().getValue()).isNotNull();
        List onEntryScriptTypeValues = executionSet.getOnEntryAction().getValue().getValues();
        List onExitScriptTypeValues = executionSet.getOnExitAction().getValue().getValues();
        Assertions.assertThat((List)onEntryScriptTypeValues).isNotNull();
        Assertions.assertThat((List)onExitScriptTypeValues).isNotNull();
        Assertions.assertThat(onEntryScriptTypeValues.get(0)).isNotNull();
        Assertions.assertThat(onExitScriptTypeValues.get(0)).isNotNull();
        Assertions.assertThat((String)executionSet.getMultipleInstanceCollectionInput().getValue()).isEqualTo(multipleInstanceCollectionInput);
        Assertions.assertThat((String)executionSet.getMultipleInstanceCollectionOutput().getValue()).isEqualTo(multipleInstanceCollectionOutput);
        Assertions.assertThat((String)executionSet.getMultipleInstanceDataInput().getValue()).isEqualTo(multipleInstanceDataInput);
        Assertions.assertThat((String)executionSet.getMultipleInstanceDataOutput().getValue()).isEqualTo(multipleInstanceDataOutput);
        Assertions.assertThat((String)executionSet.getMultipleInstanceCompletionCondition().getValue()).isEqualTo(multipleInstanceCompletionCondition);
        Assertions.assertThat((Boolean)executionSet.getIsAsync().getValue()).isEqualTo(isAsync);
        Assertions.assertThat((String)executionSet.getSlaDueDate().getValue()).isEqualTo(slaDueDate);
        Assertions.assertThat((String)((ScriptTypeValue)onEntryScriptTypeValues.get(0)).getScript()).isEqualTo(onEntryActionScriptValue);
        Assertions.assertThat((String)((ScriptTypeValue)onEntryScriptTypeValues.get(0)).getLanguage()).isEqualTo(onEntryActionScriptLanguage);
        Assertions.assertThat((String)((ScriptTypeValue)onExitScriptTypeValues.get(0)).getScript()).isEqualTo(onExitActionScriptValue);
        Assertions.assertThat((String)((ScriptTypeValue)onExitScriptTypeValues.get(0)).getLanguage()).isEqualTo(onExitActionScriptLanguage);
    }
}

