/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks.TaskTest;
import org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BusinessRuleTaskExecutionSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeValue;

public class BusinessRuleTaskTest
extends TaskTest<BusinessRuleTask> {
    private static final String BPMN_TASK_FILE_PATH = "org/kie/workbench/common/stunner/bpmn/backend/service/diagram/businessRuleTasks.bpmn";
    private static final String EMPTY_TOP_LEVEL_TASK_ID = "0A575AC2-2D97-484B-A3C9-CA7AC8D1BFA6";
    private static final String FILLED_TOP_LEVEL_TASK_JAVA_ID = "3FE580D6-75F6-402B-8C24-47C95E67EE11";
    private static final String FILLED_TOP_LEVEL_TASK_JAVASCRIPT_ID = "7917DDBD-CA16-40D3-83CF-376BD32F301E";
    private static final String FILLED_TOP_LEVEL_TASK_MVEL_ID = "34628985-F9C4-43A4-AD22-1173275A26CA";
    private static final String EMPTY_SUBPROCESS_LEVEL_TASK_ID = "25D04D0B-9826-462F-A012-01B85BD371CE";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_JAVA_ID = "4E6D1968-9819-4EB3-8A60-70622060BE88";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID = "159A5FF3-472D-4D15-863C-D377DA0E76BC";
    private static final String FILLED_SUBPROCESS_LEVEL_TASK_MVEL_ID = "70EAE6AB-2FF1-416E-8B5A-CDB9B0BE2FDA";
    private static final String EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID = "7AC9EBD3-258E-4118-AB58-2723D30E879F";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVA_ID = "40478C64-73C7-4B74-A278-7170D18F95C9";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID = "F7A7DCA6-C9AC-45AB-9E82-790CCBF6EEA1";
    private static final String FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_MVEL_ID = "53CB534E-11C1-42BE-8697-104EE888B55B";
    private static final String EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID = "85660E3E-FC4B-4869-9BBE-8A5F2F483BF6";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVA_ID = "F1B724ED-14AB-41E6-B0BD-7776D0487908";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVASCRIPT_ID = "2D36CBE3-E497-467E-9A17-7A9B5A69EF7D";
    private static final String FILLED_ONE_INCOME_TOP_LEVEL_TASK_MVEL_ID = "2E098245-15C1-4C77-A719-B4F207B2C516";
    private static final String EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID = "A6425B2C-DF96-4C25-A1EF-2CEA0B23415D";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVA_ID = "38B4D0B8-7F61-406C-91F1-36F3CD231183";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID = "FE864C5E-A212-41CA-9B0E-5BF2D0D9A492";
    private static final String FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_MVEL_ID = "2B18305C-EDC6-4A0C-A6F7-C2FCE6A9AD94";
    private static final String EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID = "B2261986-4D03-4757-8DD9-1C003CC70B42";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVA_ID = "E9C51991-DF8C-4DED-9F9D-846ACDE9AA88";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVASCRIPT_ID = "CF34C3FA-B9A5-49C9-A63A-988F120EAB9D";
    private static final String FILLED_TWO_INCOMES_TOP_LEVEL_TASK_MVEL_ID = "1D6B0146-E20A-488F-8E27-584009BDC92F";
    private static final String DMN_RULE_LANGUAGE_TASK_ID = "_10EAF4D5-66E2-49B4-B2A6-EE5DCA14E9C5";
    private static final int AMOUNT_OF_NODES_IN_DIAGRAM = 70;
    private static final String EMPTY_TASK_DATA_INPUT_OUTPUT = "||||";
    private static final String TASK_SCRIPT_JAVA_LANGUAGE = "java";
    private static final String TASK_SCRIPT_JAVASCRIPT_LANGUAGE = "javascript";
    private static final String TASK_SCRIPT_MVEL_LANGUAGE = "mvel";
    private static final boolean IS_ASYNC = true;
    private static final boolean IS_NOT_ASYNC = false;
    private static final boolean AD_HOC_AUTOSTART = true;
    private static final boolean NOT_AD_HOC_AUTOSTART = false;
    private static final String SLA_DUE_DATE = "12/25/1983";

    @Override
    @Test
    public void testUnmarshallTopLevelTaskFilledProperties() {
        String TASK_NAME_JAVA = "Task01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action from Business Rule Task.\");";
        String TASK_NAME_JAVASCRIPT = "Task04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action from Business Rule Task.\");";
        String TASK_NAME_MVEL = "Task07 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action from Business Rule Task.\");";
        String RULE_FLOW_GROUP = "Group01";
        String TASK_DATA_INPUT_OUTPUT = "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask filledTopLevelTaskJava = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_JAVA_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTaskJava.getGeneral(), "Task01 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task01 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledTopLevelTaskJava.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "System.out.println(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopLevelTaskJava.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        BusinessRuleTask filledTopLevelTaskJavascript = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTaskJavascript.getGeneral(), "Task04 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task04 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledTopLevelTaskJavascript.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "console.log(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopLevelTaskJavascript.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        BusinessRuleTask filledTopLevelTaskMvel = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_TOP_LEVEL_TASK_MVEL_ID, 0, false);
        this.assertGeneralSet(filledTopLevelTaskMvel.getGeneral(), "Task07 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task07 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledTopLevelTaskMvel.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "System.out.println(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopLevelTaskMvel.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelEmptyTaskProperties() {
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask emptyTopLevelTask = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TOP_LEVEL_TASK_ID, 0, false);
        this.assertGeneralSet(emptyTopLevelTask.getGeneral(), "", "");
        this.assertBusinessRuleTaskExecutionSet(emptyTopLevelTask.getExecutionSet(), "http://www.jboss.org/drools/rule", "", "", "", "", "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, "");
        this.assertDataIOSet(emptyTopLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskFilledProperties() {
        String TASK_NAME_JAVA = "Task10 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action from Business Rule Task.\");";
        String TASK_NAME_JAVASCRIPT = "Task13 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task13 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action from Business Rule Task.\");";
        String TASK_NAME_MVEL = "Task16 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task16 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action from Business Rule Task.\");";
        String RULE_FLOW_GROUP = "Group01";
        String TASK_DATA_INPUT_OUTPUT = "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask filledSubprocessLevelTaskJava = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_JAVA_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "Task10 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task10 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "System.out.println(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessLevelTaskJava.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        BusinessRuleTask filledSubprocessLevelTaskJavascript = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskJavascript.getGeneral(), "Task13 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task13 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledSubprocessLevelTaskJavascript.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "console.log(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessLevelTaskJavascript.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        BusinessRuleTask filledSubprocessLevelTaskMvel = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_SUBPROCESS_LEVEL_TASK_MVEL_ID, 0, false);
        this.assertGeneralSet(filledSubprocessLevelTaskMvel.getGeneral(), "Task16 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task16 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledSubprocessLevelTaskMvel.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "System.out.println(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessLevelTaskMvel.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask emptySubprocessLevelTask = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), EMPTY_SUBPROCESS_LEVEL_TASK_ID, 0, false);
        this.assertGeneralSet(emptySubprocessLevelTask.getGeneral(), "", "");
        this.assertBusinessRuleTaskExecutionSet(emptySubprocessLevelTask.getExecutionSet(), "http://www.jboss.org/drools/rule", "", "", "", "", "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, "");
        this.assertDataIOSet(emptySubprocessLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskOneIncomeFilledProperties() {
        String TASK_NAME_JAVA = "Task02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action from Business Rule Task.\");";
        String TASK_NAME_JAVASCRIPT = "Task05 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action from Business Rule Task.\");";
        String TASK_NAME_MVEL = "Task08 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action from Business Rule Task.\");";
        String RULE_FLOW_GROUP = "Group01";
        String TASK_DATA_INPUT_OUTPUT = "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask filledTopLevelTaskJava = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVA_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTaskJava.getGeneral(), "Task02 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task02 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledTopLevelTaskJava.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "System.out.println(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopLevelTaskJava.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        BusinessRuleTask filledTopLevelTaskJavascript = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTaskJavascript.getGeneral(), "Task05 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task05 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledTopLevelTaskJavascript.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "console.log(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopLevelTaskJavascript.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        BusinessRuleTask filledTopLevelTaskMvel = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_TOP_LEVEL_TASK_MVEL_ID, 1, true);
        this.assertGeneralSet(filledTopLevelTaskMvel.getGeneral(), "Task08 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task08 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledTopLevelTaskMvel.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "System.out.println(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopLevelTaskMvel.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskOneIncomeEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask emptyTopLevelTask = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID, 1, true);
        this.assertGeneralSet(emptyTopLevelTask.getGeneral(), "", "");
        this.assertBusinessRuleTaskExecutionSet(emptyTopLevelTask.getExecutionSet(), "http://www.jboss.org/drools/rule", "", "", "", "", "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, "");
        this.assertDataIOSet(emptyTopLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskOneIncomeEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask emptySubprocessLevelTask = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID, 1, true);
        this.assertGeneralSet(emptySubprocessLevelTask.getGeneral(), "", "");
        this.assertBusinessRuleTaskExecutionSet(emptySubprocessLevelTask.getExecutionSet(), "http://www.jboss.org/drools/rule", "", "", "", "", "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, "");
        this.assertDataIOSet(emptySubprocessLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskOneIncomeFilledProperties() {
        String TASK_NAME_JAVA = "Task11 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action from Business Rule Task.\");";
        String TASK_NAME_JAVASCRIPT = "Task14 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task14 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action from Business Rule Task.\");";
        String TASK_NAME_MVEL = "Task17 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task17 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action from Business Rule Task.\");";
        String RULE_FLOW_GROUP = "Group01";
        String TASK_DATA_INPUT_OUTPUT = "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask filledSubprocessLevelTaskJava = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVA_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "Task11 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task11 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "System.out.println(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessLevelTaskJava.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        BusinessRuleTask filledSubprocessLevelTaskJavascript = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJavascript.getGeneral(), "Task14 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task14 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledSubprocessLevelTaskJavascript.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "console.log(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessLevelTaskJavascript.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        BusinessRuleTask filledSubprocessLevelTaskMvel = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_MVEL_ID, 1, true);
        this.assertGeneralSet(filledSubprocessLevelTaskMvel.getGeneral(), "Task17 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task17 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledSubprocessLevelTaskMvel.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "System.out.println(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessLevelTaskMvel.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskTwoIncomesFilledProperties() {
        String TASK_NAME_JAVA = "Task03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action from Business Rule Task.\");";
        String TASK_NAME_JAVASCRIPT = "Task06 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action from Business Rule Task.\");";
        String TASK_NAME_MVEL = "Task09 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action from Business Rule Task.\");";
        String RULE_FLOW_GROUP = "Group01";
        String TASK_DATA_INPUT_OUTPUT = "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask filledTopLevelTaskJava = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVA_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTaskJava.getGeneral(), "Task03 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task03 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledTopLevelTaskJava.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "System.out.println(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopLevelTaskJava.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        BusinessRuleTask filledTopLevelTaskJavascript = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTaskJavascript.getGeneral(), "Task06 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task06 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledTopLevelTaskJavascript.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "console.log(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopLevelTaskJavascript.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        BusinessRuleTask filledTopLevelTaskMvel = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_TOP_LEVEL_TASK_MVEL_ID, 2, true);
        this.assertGeneralSet(filledTopLevelTaskMvel.getGeneral(), "Task09 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task09 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledTopLevelTaskMvel.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "System.out.println(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledTopLevelTaskMvel.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Override
    @Test
    public void testUnmarshallTopLevelTaskTwoIncomesEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask emptyTopLevelTask = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID, 2, true);
        this.assertGeneralSet(emptyTopLevelTask.getGeneral(), "", "");
        this.assertBusinessRuleTaskExecutionSet(emptyTopLevelTask.getExecutionSet(), "http://www.jboss.org/drools/rule", "", "", "", "", "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, "");
        this.assertDataIOSet(emptyTopLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskTwoIncomesEmptyProperties() {
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask emptySubprocessLevelTask = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID, 2, true);
        this.assertGeneralSet(emptySubprocessLevelTask.getGeneral(), "", "");
        this.assertBusinessRuleTaskExecutionSet(emptySubprocessLevelTask.getExecutionSet(), "http://www.jboss.org/drools/rule", "", "", "", "", "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, "");
        this.assertDataIOSet(emptySubprocessLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testUnmarshallSubprocessLevelTaskTwoIncomesFilledProperties() {
        String TASK_NAME_JAVA = "Task12 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVA = "Task12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVA = "System.out.println(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_JAVA = "System.out.println(\"On Exit Action from Business Rule Task.\");";
        String TASK_NAME_JAVASCRIPT = "Task15 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_JAVASCRIPT = "Task15 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_JAVASCRIPT = "console.log(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_JAVASCRIPT = "console.log(\"On Exit Action from Business Rule Task.\");";
        String TASK_NAME_MVEL = "Task18 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./";
        String TASK_DOCUMENTATION_MVEL = "Task18 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./";
        String TASK_ON_ENTRY_ACTION_MVEL = "System.out.println(\"On Entry Action from Business Rule Task.\");";
        String TASK_ON_EXIT_ACTION_MVEL = "System.out.println(\"On Exit Action from Business Rule Task.\");";
        String RULE_FLOW_GROUP = "Group01";
        String TASK_DATA_INPUT_OUTPUT = "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar";
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask filledSubprocessLevelTaskJava = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVA_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJava.getGeneral(), "Task12 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task12 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledSubprocessLevelTaskJava.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "System.out.println(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, "System.out.println(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_JAVA_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessLevelTaskJava.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        BusinessRuleTask filledSubprocessLevelTaskJavascript = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskJavascript.getGeneral(), "Task15 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task15 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledSubprocessLevelTaskJavascript.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "console.log(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, "console.log(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_JAVASCRIPT_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessLevelTaskJavascript.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
        BusinessRuleTask filledSubprocessLevelTaskMvel = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_MVEL_ID, 2, true);
        this.assertGeneralSet(filledSubprocessLevelTaskMvel.getGeneral(), "Task18 name ~!@#$%^&*()_+`-={}|[]\\:\";'<>?,./", "Task18 doc\n ~!@#$%^&*()_+`1234567890-={}|[]\\:\";'<>?,./");
        this.assertBusinessRuleTaskExecutionSet(filledSubprocessLevelTaskMvel.getExecutionSet(), "http://www.jboss.org/drools/rule", "Group01", "", "", "", "System.out.println(\"On Entry Action from Business Rule Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, "System.out.println(\"On Exit Action from Business Rule Task.\");", TASK_SCRIPT_MVEL_LANGUAGE, true, true, SLA_DUE_DATE);
        this.assertDataIOSet(filledSubprocessLevelTaskMvel.getDataIOSet(), "|input:String||output:String|[din]processGlobalVar->input,[dout]output->processGlobalVar");
    }

    @Test
    public void testUnmarshallDMNRuleLanguageProperties() {
        String DMN_LANGUAGE_TASK_NAME = "DMN Task";
        this.assertDiagram(this.getDiagram(), 70);
        BusinessRuleTask emptyTopLevelTask = (BusinessRuleTask)this.getTaskNodeById(this.getDiagram(), DMN_RULE_LANGUAGE_TASK_ID, 0, false);
        this.assertGeneralSet(emptyTopLevelTask.getGeneral(), "DMN Task", "");
        this.assertBusinessRuleTaskExecutionSet(emptyTopLevelTask.getExecutionSet(), "http://www.jboss.org/drools/dmn", "", "Namespace", "DecisionName", "DMNModelName", "", TASK_SCRIPT_JAVA_LANGUAGE, "", TASK_SCRIPT_JAVA_LANGUAGE, false, false, SLA_DUE_DATE);
        this.assertDataIOSet(emptyTopLevelTask.getDataIOSet(), EMPTY_TASK_DATA_INPUT_OUTPUT);
    }

    @Override
    @Test
    public void testMarshallTopLevelTaskFilledProperties() {
        this.checkTaskMarshalling(FILLED_TOP_LEVEL_TASK_JAVA_ID, 0, false);
        this.checkTaskMarshalling(FILLED_TOP_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.checkTaskMarshalling(FILLED_TOP_LEVEL_TASK_MVEL_ID, 0, false);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelTaskFilledProperties() {
        this.checkTaskMarshalling(FILLED_SUBPROCESS_LEVEL_TASK_JAVA_ID, 0, false);
        this.checkTaskMarshalling(FILLED_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 0, false);
        this.checkTaskMarshalling(FILLED_SUBPROCESS_LEVEL_TASK_MVEL_ID, 0, false);
    }

    @Override
    @Test
    public void testMarshallTopLevelTaskOneIncomeFilledProperties() {
        this.checkTaskMarshalling(FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVA_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_TOP_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_TOP_LEVEL_TASK_MVEL_ID, 1, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelTaskOneIncomeFilledProperties() {
        this.checkTaskMarshalling(FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVA_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 1, true);
        this.checkTaskMarshalling(FILLED_ONE_INCOME_SUBPROCESS_LEVEL_TASK_MVEL_ID, 1, true);
    }

    @Override
    @Test
    public void testMarshallTopLevelTaskTwoIncomesFilledProperties() {
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVA_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_TOP_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_TOP_LEVEL_TASK_MVEL_ID, 2, true);
    }

    @Override
    @Test
    public void testMarshallSubprocessLevelTaskTwoIncomesFilledProperties() {
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVA_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_JAVASCRIPT_ID, 2, true);
        this.checkTaskMarshalling(FILLED_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_MVEL_ID, 2, true);
    }

    @Test
    public void testMarshallDMNRuleLanguageProperties() {
        this.checkTaskMarshalling(DMN_RULE_LANGUAGE_TASK_ID, 0, false);
    }

    @Override
    String getBpmnTaskFilePath() {
        return BPMN_TASK_FILE_PATH;
    }

    @Override
    Class<BusinessRuleTask> getTaskType() {
        return BusinessRuleTask.class;
    }

    @Override
    String getFilledTopLevelTaskId() {
        return null;
    }

    @Override
    String getEmptyTopLevelTaskId() {
        return EMPTY_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelTaskId() {
        return EMPTY_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getFilledTopLevelTaskOneIncomeId() {
        return null;
    }

    @Override
    String getEmptyTopLevelTaskOneIncomeId() {
        return EMPTY_ONE_INCOME_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskOneIncomeId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelTaskOneIncomeId() {
        return EMPTY_ONE_INCOME_SUBPROCESS_LEVEL_TASK_ID;
    }

    @Override
    String getFilledTopLevelTaskTwoIncomesId() {
        return null;
    }

    @Override
    String getEmptyTopLevelTaskTwoIncomesId() {
        return EMPTY_TWO_INCOMES_TOP_LEVEL_TASK_ID;
    }

    @Override
    String getFilledSubprocessLevelTaskTwoIncomesId() {
        return null;
    }

    @Override
    String getEmptySubprocessLevelTaskTwoIncomesId() {
        return EMPTY_TWO_INCOMES_SUBPROCESS_LEVEL_TASK_ID;
    }

    private void assertBusinessRuleTaskExecutionSet(BusinessRuleTaskExecutionSet executionSet, String ruleLanguage, String ruleFlowGroup, String namespace, String decisionName, String dmnModelName, String onEntryActionScriptValue, String onEntryActionScriptLanguage, String onExitActionScriptValue, String onExitActionScriptLanguage, boolean isAsync, boolean adHocAutostart, String slaDueDate) {
        Assert.assertNotNull((Object)executionSet);
        Assert.assertNotNull((Object)executionSet.getRuleLanguage());
        Assert.assertNotNull((Object)executionSet.getRuleFlowGroup());
        Assert.assertNotNull((Object)executionSet.getNamespace());
        Assert.assertNotNull((Object)executionSet.getDmnModelName());
        Assert.assertNotNull((Object)executionSet.getDmnModelName());
        Assert.assertNotNull((Object)executionSet.getOnEntryAction());
        Assert.assertNotNull((Object)executionSet.getOnExitAction());
        Assert.assertNotNull((Object)executionSet.getIsAsync());
        Assert.assertNotNull((Object)executionSet.getAdHocAutostart());
        Assert.assertNotNull((Object)executionSet.getSlaDueDate());
        Assert.assertNotNull((Object)executionSet.getOnEntryAction().getValue());
        Assert.assertNotNull((Object)executionSet.getOnExitAction().getValue());
        List onEntryScriptTypeValues = executionSet.getOnEntryAction().getValue().getValues();
        List onExitScriptTypeValues = executionSet.getOnExitAction().getValue().getValues();
        Assert.assertNotNull((Object)onEntryScriptTypeValues);
        Assert.assertNotNull((Object)onExitScriptTypeValues);
        Assert.assertNotNull(onEntryScriptTypeValues.get(0));
        Assert.assertNotNull(onExitScriptTypeValues.get(0));
        Assert.assertEquals((Object)ruleLanguage, (Object)executionSet.getRuleLanguage().getValue());
        Assert.assertEquals((Object)ruleFlowGroup, (Object)executionSet.getRuleFlowGroup().getValue());
        Assert.assertEquals((Object)namespace, (Object)executionSet.getNamespace().getValue());
        Assert.assertEquals((Object)decisionName, (Object)executionSet.getDecisionName().getValue());
        Assert.assertEquals((Object)dmnModelName, (Object)executionSet.getDmnModelName().getValue());
        Assert.assertEquals((Object)slaDueDate, (Object)executionSet.getSlaDueDate().getValue());
        Assert.assertEquals((Object)onEntryActionScriptValue, (Object)((ScriptTypeValue)onEntryScriptTypeValues.get(0)).getScript());
        Assert.assertEquals((Object)onEntryActionScriptLanguage, (Object)((ScriptTypeValue)onEntryScriptTypeValues.get(0)).getLanguage());
        Assert.assertEquals((Object)onExitActionScriptValue, (Object)((ScriptTypeValue)onExitScriptTypeValues.get(0)).getScript());
        Assert.assertEquals((Object)onExitActionScriptLanguage, (Object)((ScriptTypeValue)onExitScriptTypeValues.get(0)).getLanguage());
        Assert.assertEquals((Object)isAsync, (Object)executionSet.getIsAsync().getValue());
        Assert.assertEquals((Object)adHocAutostart, (Object)executionSet.getAdHocAutostart().getValue());
    }

    private void assertDataIOSet(DataIOSet dataIOSet, String value) {
        Assert.assertNotNull((Object)dataIOSet);
        Assert.assertNotNull((Object)dataIOSet.getAssignmentsinfo());
        Assert.assertEquals((Object)value, (Object)dataIOSet.getAssignmentsinfo().getValue());
    }
}

