/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.tasks;

import org.junit.Assert;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.service.diagram.marshalling.BPMNDiagramMarshallerBaseTest;
import org.kie.workbench.common.stunner.bpmn.definition.BaseTask;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.TaskGeneralSet;
import org.kie.workbench.common.stunner.core.definition.service.DiagramMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;

public abstract class TaskTest<T extends BaseTask>
extends BPMNDiagramMarshallerBaseTest {
    static final String EMPTY_VALUE = "";
    static final int ZERO_INCOME_EDGES = 0;
    static final int ONE_INCOME_EDGE = 1;
    static final int TWO_INCOME_EDGES = 2;
    static final boolean HAS_OUTCOME_EDGE = true;
    static final boolean HAS_NO_OUTCOME_EDGE = false;
    private Diagram<Graph, Metadata> diagram;
    private Diagram<Graph, Metadata> roundTripDiagram;

    public Diagram<Graph, Metadata> getDiagram() {
        return this.diagram;
    }

    public void setDiagram(Diagram<Graph, Metadata> diagram) {
        this.diagram = diagram;
    }

    public Diagram<Graph, Metadata> getRoundTripDiagram() {
        return this.roundTripDiagram;
    }

    public void setRoundTripDiagram(Diagram<Graph, Metadata> diagram) {
        this.roundTripDiagram = diagram;
    }

    TaskTest() throws Exception {
        this.marshallDiagramWithNewMarshaller();
    }

    private void marshallDiagramWithNewMarshaller() throws Exception {
        this.setDiagram(this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getBpmnTaskFilePath()));
        this.setRoundTripDiagram(this.unmarshall((DiagramMarshaller<Graph, Metadata, Diagram<Graph, Metadata>>)this.marshaller, this.getStream(this.marshaller.marshall(this.getDiagram()))));
    }

    @Test
    public void testMarshallTopLevelTaskFilledProperties() {
        this.checkTaskMarshalling(this.getFilledTopLevelTaskId(), 0, false);
    }

    @Test
    public void testMarshallTopLevelTaskEmptyProperties() {
        this.checkTaskMarshalling(this.getEmptyTopLevelTaskId(), 0, false);
    }

    @Test
    public void testMarshallSubprocessLevelTaskFilledProperties() {
        this.checkTaskMarshalling(this.getFilledSubprocessLevelTaskId(), 0, false);
    }

    @Test
    public void testMarshallSubprocessLevelTaskEmptyProperties() {
        this.checkTaskMarshalling(this.getEmptySubprocessLevelTaskId(), 0, false);
    }

    @Test
    public void testMarshallTopLevelTaskOneIncomeFilledProperties() {
        this.checkTaskMarshalling(this.getFilledTopLevelTaskOneIncomeId(), 1, true);
    }

    @Test
    public void testMarshallTopLevelTaskOneIncomeEmptyProperties() {
        this.checkTaskMarshalling(this.getEmptyTopLevelTaskOneIncomeId(), 1, true);
    }

    @Test
    public void testMarshallSubprocessLevelTaskOneIncomeFilledProperties() {
        this.checkTaskMarshalling(this.getFilledSubprocessLevelTaskOneIncomeId(), 1, true);
    }

    @Test
    public void testMarshallSubprocessLevelTaskOneIncomeEmptyProperties() {
        this.checkTaskMarshalling(this.getEmptySubprocessLevelTaskOneIncomeId(), 1, true);
    }

    @Test
    public void testMarshallTopLevelTaskTwoIncomesFilledProperties() {
        this.checkTaskMarshalling(this.getFilledTopLevelTaskTwoIncomesId(), 2, true);
    }

    @Test
    public void testMarshallTopLevelTaskTwoIncomesEmptyProperties() {
        this.checkTaskMarshalling(this.getEmptyTopLevelTaskTwoIncomesId(), 2, true);
    }

    @Test
    public void testMarshallSubprocessLevelTaskTwoIncomesFilledProperties() {
        this.checkTaskMarshalling(this.getFilledSubprocessLevelTaskTwoIncomesId(), 2, true);
    }

    @Test
    public void testMarshallSubprocessLevelTaskTwoIncomesEmptyProperties() {
        this.checkTaskMarshalling(this.getEmptySubprocessLevelTaskTwoIncomesId(), 2, true);
    }

    public abstract void testUnmarshallTopLevelTaskFilledProperties() throws Exception;

    public abstract void testUnmarshallTopLevelEmptyTaskProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelTaskFilledProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelTaskEmptyProperties() throws Exception;

    public abstract void testUnmarshallTopLevelTaskOneIncomeFilledProperties() throws Exception;

    public abstract void testUnmarshallTopLevelTaskOneIncomeEmptyProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelTaskOneIncomeEmptyProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelTaskOneIncomeFilledProperties() throws Exception;

    public abstract void testUnmarshallTopLevelTaskTwoIncomesFilledProperties() throws Exception;

    public abstract void testUnmarshallTopLevelTaskTwoIncomesEmptyProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelTaskTwoIncomesEmptyProperties() throws Exception;

    public abstract void testUnmarshallSubprocessLevelTaskTwoIncomesFilledProperties() throws Exception;

    abstract String getBpmnTaskFilePath();

    public int getInitialAmountOfNodes() {
        return this.getNodes(this.getDiagram()).size();
    }

    abstract Class<T> getTaskType();

    abstract String getFilledTopLevelTaskId();

    abstract String getEmptyTopLevelTaskId();

    abstract String getFilledSubprocessLevelTaskId();

    abstract String getEmptySubprocessLevelTaskId();

    abstract String getFilledTopLevelTaskOneIncomeId();

    abstract String getEmptyTopLevelTaskOneIncomeId();

    abstract String getFilledSubprocessLevelTaskOneIncomeId();

    abstract String getEmptySubprocessLevelTaskOneIncomeId();

    abstract String getFilledTopLevelTaskTwoIncomesId();

    abstract String getEmptyTopLevelTaskTwoIncomesId();

    abstract String getFilledSubprocessLevelTaskTwoIncomesId();

    abstract String getEmptySubprocessLevelTaskTwoIncomesId();

    private void assertNodesEqualsAfterMarshalling(Diagram<Graph, Metadata> before, Diagram<Graph, Metadata> after, String nodeId, int amountOfIncomeEdges, boolean hasOutcomeEdge) {
        T nodeBeforeMarshalling = this.getTaskNodeById(before, nodeId, amountOfIncomeEdges, hasOutcomeEdge);
        T nodeAfterMarshalling = this.getTaskNodeById(after, nodeId, amountOfIncomeEdges, hasOutcomeEdge);
        Assert.assertEquals(nodeBeforeMarshalling, nodeAfterMarshalling);
    }

    T getTaskNodeById(Diagram<Graph, Metadata> diagram, String id, int amountOfIncomeEdges, boolean hasOutcomeEdge) {
        Node node = diagram.getGraph().getNode(id);
        Assert.assertNotNull((Object)node);
        Assert.assertEquals((long)(amountOfIncomeEdges + 1), (long)node.getInEdges().size());
        int outcomeEdges = hasOutcomeEdge ? 1 : 0;
        Assert.assertEquals((long)outcomeEdges, (long)node.getOutEdges().size());
        return (T)((BaseTask)this.getTaskType().cast(((Definition)node.getContent()).getDefinition()));
    }

    void checkTaskMarshalling(String nodeID, int amountOfIncomeEdges, boolean hasOutcomeEdge) {
        Diagram<Graph, Metadata> initialDiagram = this.getDiagram();
        Diagram<Graph, Metadata> marshalledDiagram = this.getRoundTripDiagram();
        this.assertDiagram(marshalledDiagram, this.getInitialAmountOfNodes());
        this.assertNodesEqualsAfterMarshalling(initialDiagram, marshalledDiagram, nodeID, amountOfIncomeEdges, hasOutcomeEdge);
    }

    void assertGeneralSet(TaskGeneralSet generalSet, String nodeName, String documentation) {
        Assert.assertNotNull((Object)generalSet);
        Assert.assertNotNull((Object)generalSet.getName());
        Assert.assertNotNull((Object)generalSet.getDocumentation());
        Assert.assertEquals((Object)nodeName, (Object)generalSet.getName().getValue());
        Assert.assertEquals((Object)documentation, (Object)generalSet.getDocumentation().getValue());
    }
}

