/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;
import org.mariadb.jdbc.internal.packet.read.ReadPacketFetcher;
import org.mariadb.jdbc.internal.packet.result.RowPacket;
import org.mariadb.jdbc.internal.queryresults.MariaDbValueObject;
import org.mariadb.jdbc.internal.queryresults.ValueObject;
import org.mariadb.jdbc.internal.util.Options;
import org.mariadb.jdbc.internal.util.buffer.Reader;

public class TextRowPacket
implements RowPacket {
    private final ColumnInformation[] columnInformation;
    private final Options options;
    private final int columnInformationLength;

    public TextRowPacket(ColumnInformation[] columnInformation, Options options, int columnInformationLength) {
        this.columnInformationLength = columnInformationLength;
        this.columnInformation = columnInformation;
        this.options = options;
    }

    @Override
    public ValueObject[] getRow(ReadPacketFetcher packetFetcher, ByteBuffer buffer) throws IOException {
        ValueObject[] valueObjects = new ValueObject[this.columnInformationLength];
        Reader reader = new Reader(buffer);
        for (int i = 0; i < this.columnInformationLength; ++i) {
            while (reader.byteBuffer.remaining() == 0) {
                reader.appendPacket(packetFetcher.getRawPacket());
            }
            long valueLen = reader.getLengthEncodedBinary();
            if (valueLen == -1L) {
                valueObjects[i] = new MariaDbValueObject(null, this.columnInformation[i], this.options);
                continue;
            }
            while ((long)reader.byteBuffer.remaining() < valueLen) {
                reader.appendPacket(packetFetcher.getRawPacket());
            }
            valueObjects[i] = new MariaDbValueObject(reader.readRawBytes((int)valueLen), this.columnInformation[i], this.options);
        }
        return valueObjects;
    }
}

