/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.explorer.backend.server;

import java.util.HashSet;
import java.util.Set;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.structure.repositories.Repository;
import org.kie.workbench.common.screens.explorer.model.FolderItem;
import org.kie.workbench.common.screens.explorer.service.ActiveOptions;
import org.kie.workbench.common.screens.explorer.service.Option;

public class UserExplorerLastData {
    public static final UserExplorerLastData EMPTY = new UserExplorerLastData();
    private LastPackage lastPackage = null;
    private LastFolderItem lastFolderItem = null;
    private Set<Option> options = new HashSet<Option>();

    public boolean isDataEmpty() {
        return this.lastPackage == null && this.lastFolderItem == null;
    }

    public boolean isEmpty() {
        return this.isDataEmpty() && this.options.isEmpty();
    }

    public void setFolderItem(Repository repository, String branch, Module module, FolderItem item) {
        this.lastFolderItem = new LastFolderItem(repository, branch, module, item);
    }

    public void setPackage(Repository repository, String branch, Module module, Package pkg) {
        this.lastPackage = new LastPackage(repository, branch, module, pkg);
    }

    public void setOptions(ActiveOptions options) {
        this.options.clear();
        this.options.addAll(options.getValues());
    }

    public LastPackage getLastPackage() {
        return this.lastPackage;
    }

    public LastFolderItem getLastFolderItem() {
        return this.lastFolderItem;
    }

    public Set<Option> getOptions() {
        return this.options;
    }

    public boolean deleteModule(Module module) {
        boolean changed = false;
        if (this.lastPackage != null && this.lastPackage.getModule().equals((Object)module)) {
            this.lastPackage = null;
            changed = true;
        }
        if (this.lastFolderItem != null && this.lastFolderItem.getModule().equals((Object)module)) {
            this.lastFolderItem = null;
            changed = true;
        }
        return changed;
    }

    static class LastFolderItem {
        Repository repository;
        String branch;
        Module module;
        FolderItem item;

        LastFolderItem() {
        }

        LastFolderItem(Repository repository, String branch, Module module, FolderItem item) {
            this.repository = repository;
            this.branch = branch;
            this.module = module;
            this.item = item;
        }

        Repository getRepository() {
            return this.repository;
        }

        String getBranch() {
            return this.branch;
        }

        Module getModule() {
            return this.module;
        }

        FolderItem getItem() {
            return this.item;
        }
    }

    static class LastPackage {
        Repository repository;
        String branch;
        Module module;
        Package pkg;

        LastPackage() {
        }

        LastPackage(Repository repository, String branch, Module module, Package pkg) {
            this.repository = repository;
            this.branch = branch;
            this.module = module;
            this.pkg = pkg;
        }

        Repository getRepository() {
            return this.repository;
        }

        String getBranch() {
            return this.branch;
        }

        Module getModule() {
            return this.module;
        }

        Package getPkg() {
            return this.pkg;
        }
    }
}

