/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datasource.management.backend.core.impl;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSource;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceProvider;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceProviderFactory;
import org.kie.workbench.common.screens.datasource.management.backend.core.DataSourceRuntimeManager;
import org.kie.workbench.common.screens.datasource.management.backend.core.DeploymentOptions;
import org.kie.workbench.common.screens.datasource.management.backend.core.DriverDeploymentCache;
import org.kie.workbench.common.screens.datasource.management.backend.core.DriverDeploymentCacheEntry;
import org.kie.workbench.common.screens.datasource.management.backend.core.DriverProvider;
import org.kie.workbench.common.screens.datasource.management.backend.core.UnDeploymentOptions;
import org.kie.workbench.common.screens.datasource.management.backend.core.impl.DriverDeploymentCacheImpl;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDef;
import org.kie.workbench.common.screens.datasource.management.model.DataSourceDeploymentInfo;
import org.kie.workbench.common.screens.datasource.management.model.DriverDef;
import org.kie.workbench.common.screens.datasource.management.model.DriverDeploymentInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class DataSourceRuntimeManagerImpl
implements DataSourceRuntimeManager {
    private static final Logger logger = LoggerFactory.getLogger(DataSourceRuntimeManagerImpl.class);
    private DataSourceProvider dataSourceProvider;
    private DriverProvider driverProvider;
    private DriverDeploymentCache driverDeploymentCache = new DriverDeploymentCacheImpl();
    private DataSourceProviderFactory providerFactory;

    public DataSourceRuntimeManagerImpl() {
    }

    @Inject
    public DataSourceRuntimeManagerImpl(DataSourceProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    @PostConstruct
    protected void init() {
        this.dataSourceProvider = this.providerFactory.getDataSourceProvider();
        this.driverProvider = this.providerFactory.getDriverProvider();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized DataSourceDeploymentInfo deployDataSource(DataSourceDef dataSourceDef, DeploymentOptions options) throws Exception {
        try {
            DataSourceDeploymentInfo dataSourceDeploymentInfo = this.dataSourceProvider.getDeploymentInfo(dataSourceDef.getUuid());
            DriverDeploymentInfo driverDeploymentInfo = this.driverProvider.getDeploymentInfo(dataSourceDef.getDriverUuid());
            if (dataSourceDeploymentInfo != null) {
                if (!options.isCreateOrResyncDeployment()) throw new Exception("Data source: " + dataSourceDef + " is already deployed");
                dataSourceDeploymentInfo = this.dataSourceProvider.resync(dataSourceDef, dataSourceDeploymentInfo);
            } else {
                if (driverDeploymentInfo == null) throw new Exception("Required driver: " + dataSourceDef.getDriverUuid() + " is not deployed.");
                dataSourceDeploymentInfo = this.dataSourceProvider.deploy(dataSourceDef);
            }
            if (driverDeploymentInfo == null || this.driverDeploymentCache.get(driverDeploymentInfo) == null) return dataSourceDeploymentInfo;
            this.driverDeploymentCache.get(driverDeploymentInfo).addDependant(dataSourceDeploymentInfo);
            return dataSourceDeploymentInfo;
        }
        catch (Exception e) {
            logger.error("Data source deployment failed for dataSourceDef: " + dataSourceDef, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized DataSourceDeploymentInfo getDataSourceDeploymentInfo(String uuid) throws Exception {
        try {
            return this.dataSourceProvider.getDeploymentInfo(uuid);
        }
        catch (Exception e) {
            logger.error("It was not possible to read the deploymentInfo for data source: " + uuid);
            throw e;
        }
    }

    @Override
    public synchronized void unDeployDataSource(DataSourceDeploymentInfo deploymentInfo, UnDeploymentOptions options) throws Exception {
        try {
            this.dataSourceProvider.undeploy(deploymentInfo);
            this.deReferFromDrivers(deploymentInfo);
        }
        catch (Exception e) {
            logger.error("Data source un-deployment failed for deploymentInfo: " + deploymentInfo, (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized DriverDeploymentInfo deployDriver(DriverDef driverDef, DeploymentOptions options) throws Exception {
        try {
            DriverDeploymentInfo deploymentInfo = this.driverProvider.getDeploymentInfo(driverDef.getUuid());
            if (deploymentInfo != null) {
                if (!options.isCreateOrResyncDeployment()) throw new Exception("Driver: " + driverDef + " is already deployed.");
                deploymentInfo = this.driverProvider.resync(driverDef, deploymentInfo);
            } else {
                deploymentInfo = this.driverProvider.deploy(driverDef);
            }
            this.driverDeploymentCache.put(deploymentInfo, driverDef);
            return deploymentInfo;
        }
        catch (Exception e) {
            logger.error("Driver deployment failed for driverDef: " + driverDef, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized DriverDeploymentInfo getDriverDeploymentInfo(String uuid) throws Exception {
        try {
            DriverDeploymentInfo deploymentInfo = this.driverProvider.getDeploymentInfo(uuid);
            if (deploymentInfo != null && this.driverDeploymentCache.get(deploymentInfo) != null) {
                DriverDeploymentInfo updatedInfo = new DriverDeploymentInfo(deploymentInfo.getDeploymentId(), deploymentInfo.getDriverDeploymentId(), deploymentInfo.isManaged(), deploymentInfo.getUuid(), deploymentInfo.getDriverClass());
                updatedInfo.getDependants().addAll(this.driverDeploymentCache.get(deploymentInfo).getDependants());
                deploymentInfo = updatedInfo;
            }
            return deploymentInfo;
        }
        catch (Exception e) {
            logger.error("It was not possible to read the deploymentInfo for driver: " + uuid);
            throw e;
        }
    }

    @Override
    public synchronized void unDeployDriver(DriverDeploymentInfo deploymentInfo, UnDeploymentOptions options) throws Exception {
        try {
            DriverDeploymentCacheEntry cacheEntry = this.driverDeploymentCache.get(deploymentInfo);
            if (cacheEntry != null && cacheEntry.hasDependants() && options.isSoftUnDeployment()) {
                throw new Exception("Driver: " + deploymentInfo + " can't be un-deployed. It's currently referenced by : " + cacheEntry.getDependants().size() + " data sources");
            }
            this.driverDeploymentCache.remove(deploymentInfo);
            this.driverProvider.undeploy(deploymentInfo);
        }
        catch (Exception e) {
            logger.error("Driver un-deployment failed for deploymentInfo: " + deploymentInfo, (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized DataSource lookupDataSource(String uuid) throws Exception {
        DataSourceDeploymentInfo deploymentInfo = this.dataSourceProvider.getDeploymentInfo(uuid);
        if (deploymentInfo != null) {
            return this.dataSourceProvider.lookupDataSource(deploymentInfo);
        }
        throw new Exception("Data source: " + uuid + " is not deployed in current system.");
    }

    @Override
    public void hasStarted() throws Exception {
        this.driverProvider.hasStarted();
        this.dataSourceProvider.hasStarted();
    }

    private void deReferFromDrivers(DataSourceDeploymentInfo deploymentInfo) {
        for (DriverDeploymentCacheEntry entry : this.driverDeploymentCache.findReferencedEntries(deploymentInfo)) {
            entry.removeDependant(deploymentInfo);
        }
    }
}

