/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.guided.scorecard.backend.server.indexing;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.models.guided.scorecard.backend.GuidedScoreCardXMLPersistence;
import org.drools.workbench.models.guided.scorecard.shared.ScoreCardModel;
import org.drools.workbench.screens.guided.scorecard.backend.server.indexing.GuidedScoreCardIndexVisitor;
import org.drools.workbench.screens.guided.scorecard.type.GuidedScoreCardResourceTypeDefinition;
import org.kie.soup.project.datamodel.oracle.ModuleDataModelOracle;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.AbstractFileIndexer;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.java.nio.file.Path;

@ApplicationScoped
public class GuidedScoreCardFileIndexer
extends AbstractFileIndexer {
    @Inject
    private DataModelService dataModelService;
    @Inject
    protected GuidedScoreCardResourceTypeDefinition type;

    public boolean supportsPath(Path path) {
        return this.type.accept(Paths.convert((Path)path));
    }

    public DefaultIndexBuilder fillIndexBuilder(Path path) throws Exception {
        String content = this.ioService.readAllString(path);
        ScoreCardModel model = GuidedScoreCardXMLPersistence.getInstance().unmarshall(content);
        ModuleDataModelOracle dmo = this.getModuleDataModelOracle(path);
        DefaultIndexBuilder builder = this.getIndexBuilder(path);
        if (builder == null) {
            return null;
        }
        GuidedScoreCardIndexVisitor visitor = new GuidedScoreCardIndexVisitor(dmo, model);
        visitor.visit();
        this.addReferencedResourcesToIndexBuilder(builder, visitor);
        return builder;
    }

    protected ModuleDataModelOracle getModuleDataModelOracle(Path path) {
        return this.dataModelService.getModuleDataModel(Paths.convert((Path)path));
    }
}

